/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.lang.reflect.InvocationTargetException;

public class Exceptions {
    private static final String UNEXPECTED_MESSAGE = "Unexpected Exception";

    public static <T extends Throwable> T withCause(T exception, Throwable cause) {
        try {
            exception.initCause(cause);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return exception;
    }

    public static RuntimeException launderedException(Throwable exception) {
        return Exceptions.launderedException(UNEXPECTED_MESSAGE, exception);
    }

    public static RuntimeException launderedException(String messageForUnexpected, Throwable exception) {
        return Exceptions.launderedException(RuntimeException.class, messageForUnexpected, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, Throwable exception) {
        return Exceptions.launderedException(type, UNEXPECTED_MESSAGE, exception);
    }

    public static <T extends Throwable> T launderedException(Class<T> type, String messageForUnexpected, Throwable exception) {
        if (type.isInstance(exception)) {
            return (T)((Throwable)type.cast(exception));
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InvocationTargetException) {
            return Exceptions.launderedException(type, messageForUnexpected, ((InvocationTargetException)exception).getTargetException());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(messageForUnexpected, exception);
    }

    private Exceptions() {
    }
}

