/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DebugUtil {
    public static void printShortStackTrace(Throwable cause, int maxNumberOfStackLines) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        cause.printStackTrace(writer);
        writer.close();
        String string = stringWriter.getBuffer().toString();
        System.out.println(DebugUtil.firstLinesOf(string, maxNumberOfStackLines + 1));
    }

    public static String firstLinesOf(String string, int maxNumberOfLines) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(string));
            String line = null;
            for (int count = 0; (line = reader.readLine()) != null && count < maxNumberOfLines; ++count) {
                writer.println(line);
            }
            writer.close();
            return stringWriter.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't happen", e);
        }
    }

    public static boolean currentStackTraceContains(String className, String method) {
        try {
            return DebugUtil.currentStackTraceContains(Class.forName(className), method);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean currentStackTraceContains(Class<?> cls, String method) {
        for (StackTraceElement stack : Thread.getAllStackTraces().get(Thread.currentThread())) {
            if (!stack.getClassName().equals(cls.getName()) || !stack.getMethodName().equals(method)) continue;
            return true;
        }
        return false;
    }

    private static class Stack {
        private final Throwable stackTrace;
        private final StackTraceElement[] elements;

        Stack(Throwable stackTrace) {
            this.stackTrace = stackTrace;
            this.elements = stackTrace.getStackTrace();
        }

        public int hashCode() {
            int hashCode = this.stackTrace.getMessage().hashCode();
            for (StackTraceElement element : this.stackTrace.getStackTrace()) {
                hashCode = hashCode * 9 + element.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Stack)) {
                return false;
            }
            Stack o = (Stack)obj;
            if (!this.stackTrace.getMessage().equals(o.stackTrace.getMessage())) {
                return false;
            }
            if (this.elements.length != o.elements.length) {
                return false;
            }
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i].equals(o.elements[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class StackTracer {
        private final Map<Stack, AtomicInteger> uniqueStackTraces = new HashMap<Stack, AtomicInteger>();

        public void add(Throwable t) {
            Stack key = new Stack(t);
            AtomicInteger count = this.uniqueStackTraces.get(key);
            if (count == null) {
                count = new AtomicInteger();
                this.uniqueStackTraces.put(key, count);
            }
            count.incrementAndGet();
        }

        public void print(PrintStream out) {
            long total = 0L;
            for (Map.Entry<Stack, AtomicInteger> entry : this.uniqueStackTraces.entrySet()) {
                out.println(entry.getValue() + " times:");
                entry.getKey().stackTrace.printStackTrace(out);
                total += (long)entry.getValue().get();
            }
            out.println("------");
            out.println("Total:" + total);
        }

        public StackTracer printAtShutdown(final PrintStream out) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StackTracer.this.print(out);
                }
            });
            return this;
        }
    }
}

