/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.StringTokenizer;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaContainer;

public abstract class XaDataSource {
    private byte[] branchId = null;
    private String name = null;

    public XaDataSource(byte[] branchId, String name) {
        this.branchId = branchId;
        this.name = name;
    }

    public abstract XaConnection getXaConnection();

    public abstract void close();

    public byte[] getBranchId() {
        return this.branchId;
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String getFileName(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getRandomIdentifier() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getCurrentLogVersion() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long rotateLogicalLog() throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ReadableByteChannel getLogicalLog(long version) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean hasLogicalLog(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public long getLogicalLogLength(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean deleteLogicalLog(long version) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void keepLogicalLogs(boolean keepLogs) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean isLogicalLogKept() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String getName() {
        return this.name;
    }

    public void setAutoRotate(boolean rotate) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setLogicalLogTargetSize(long size) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected Boolean shouldKeepLog(String config, String resourceName) {
        if (config == null) {
            return null;
        }
        if (config.equals(Boolean.TRUE.toString()) || config.equals(Boolean.FALSE.toString())) {
            return Boolean.parseBoolean(config);
        }
        StringTokenizer tok = new StringTokenizer(config, ",");
        while (tok.hasMoreTokens()) {
            Pair<String, Boolean> parsed = this.parsePossiblyKeyValueConfig(tok.nextToken().trim());
            if (!resourceName.equals(parsed.first())) continue;
            return parsed.other();
        }
        return Boolean.FALSE;
    }

    private Pair<String, Boolean> parsePossiblyKeyValueConfig(String element) {
        int equalsIndex = element.indexOf(61);
        return equalsIndex != -1 ? Pair.of(element.substring(0, equalsIndex), Boolean.parseBoolean(element.substring(equalsIndex + 1))) : Pair.of(element, Boolean.TRUE);
    }

    public ReadableByteChannel getPreparedTransaction(int identifier) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void getPreparedTransaction(int identifier, LogBuffer targetBuffer) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void applyCommittedTransaction(long txId, ReadableByteChannel transaction) throws IOException {
        this.getXaContainer().getResourceManager().applyCommittedTransaction(transaction, txId);
    }

    public long applyPreparedTransaction(ReadableByteChannel transaction) throws IOException {
        return this.getXaContainer().getResourceManager().applyPreparedTransaction(transaction);
    }

    public long getLastCommittedTxId() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setLastCommittedTxId(long txId) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public XaContainer getXaContainer() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Pair<Integer, Long> getMasterForCommittedTx(long txId) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ClosableIterable<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean setRecovered(boolean recovered) {
        return false;
    }

    public LogExtractor getLogExtractor(long startTxId, long endTxIdHint) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

