/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.TransactionDataImpl;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class LockReleaser {
    private static Logger log = Logger.getLogger(LockReleaser.class.getName());
    private final ArrayMap<Transaction, List<LockElement>> lockMap = new ArrayMap(5, true, true);
    private final ArrayMap<Transaction, PrimitiveElement> cowMap = new ArrayMap(5, true, true);
    private NodeManager nodeManager;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private PropertyIndexManager propertyIndexManager;

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public LockReleaser(LockManager lockManager, TransactionManager transactionManager, NodeManager nodeManager, PropertyIndexManager propertyIndexManager) {
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.nodeManager = nodeManager;
        this.propertyIndexManager = propertyIndexManager;
    }

    public LockElement addLockToTransaction(Object resource, LockType type) {
        return this.addLockToTransaction(resource, type, null);
    }

    public LockElement addLockToTransaction(Object resource, LockType type, Transaction tx) throws NotInTransactionException {
        List<LockElement> lockElements = this.lockMap.get(tx = tx == null ? this.getTransaction() : tx);
        if (lockElements != null) {
            LockElement element = new LockElement(resource, type);
            lockElements.add(element);
            return element;
        }
        if (tx == null) {
            type.release(resource, this.lockManager);
            return null;
        }
        lockElements = new ArrayList<LockElement>();
        this.lockMap.put(tx, lockElements);
        LockElement element = new LockElement(resource, type);
        lockElements.add(element);
        try {
            tx.registerSynchronization((Synchronization)new ReadOnlyTxReleaser(tx));
        }
        catch (Exception e) {
            throw new TransactionFailureException("Failed to register lock release synchronization hook", e);
        }
        return element;
    }

    private Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new TransactionFailureException("Failed to get current transaction.", e);
        }
    }

    public Collection<Long> getCowRelationshipRemoveMap(NodeImpl node, String type) {
        ArrayMap cowElements;
        CowNodeElement element;
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement != null && (element = (CowNodeElement)(cowElements = primitiveElement.nodes).get(node.getId())) != null && element.relationshipRemoveMap != null) {
            return (Collection)element.relationshipRemoveMap.get(type);
        }
        return null;
    }

    public Collection<Long> getOrCreateCowRelationshipRemoveMap(NodeImpl node, String type) {
        return this.getPrimitiveElement(true).nodeElement(node.getId(), true).getRelationshipRemoveMap(type, true);
    }

    public void setFirstIds(long nodeId, long firstRel, long firstProp) {
        CowNodeElement nodeElement = this.getPrimitiveElement(true).nodeElement(nodeId, true);
        nodeElement.firstRel = firstRel;
        nodeElement.firstProp = firstProp;
    }

    public ArrayMap<String, RelIdArray> getCowRelationshipAddMap(NodeImpl node) {
        PrimitiveElement primitiveElement = this.getPrimitiveElement(false);
        if (primitiveElement == null) {
            return null;
        }
        CowNodeElement element = primitiveElement.nodeElement(node.getId(), false);
        return element != null ? element.relationshipAddMap : null;
    }

    public RelIdArray getCowRelationshipAddMap(NodeImpl node, String type) {
        ArrayMap<String, RelIdArray> map = this.getCowRelationshipAddMap(node);
        return map != null ? map.get(type) : null;
    }

    public RelIdArray getOrCreateCowRelationshipAddMap(NodeImpl node, String type) {
        return this.getPrimitiveElement(true).nodeElement(node.getId(), true).getRelationshipAddMap(type, true);
    }

    public void commit() {
        this.commit(this.getTransaction());
    }

    public void commit(Transaction tx) {
        this.releaseLocks(tx);
    }

    public void commitCows() {
        Transaction tx = this.getTransaction();
        this.propertyIndexManager.commit(tx);
        this.releaseCows(tx, 3);
    }

    public void rollback() {
        this.rollback(this.getTransaction());
    }

    public void rollback(Transaction tx) {
        this.propertyIndexManager.rollback(tx);
        this.releaseCows(tx, 4);
        this.releaseLocks(tx);
    }

    public boolean hasLocks(Transaction tx) {
        List<LockElement> lockElements = this.lockMap.get(tx);
        return lockElements != null && !lockElements.isEmpty();
    }

    void releaseLocks(Transaction tx) {
        List<LockElement> lockElements = this.lockMap.remove(tx);
        if (lockElements != null) {
            for (LockElement lockElement : lockElements) {
                try {
                    lockElement.releaseIfAcquired(this.lockManager, tx);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Unable to release lock[" + (Object)((Object)lockElement.lockType) + "] on resource[" + lockElement.resource + "]", e);
                }
            }
        }
    }

    void releaseCows(Transaction cowTxId, int param) {
        PrimitiveElement element = this.cowMap.remove(cowTxId);
        if (element == null) {
            return;
        }
        ArrayMap cowNodeElements = element.nodes;
        Set nodeEntrySet = cowNodeElements.entrySet();
        for (Map.Entry entry : nodeEntrySet) {
            NodeImpl node = this.nodeManager.getNodeIfCached((Long)entry.getKey());
            if (node == null) continue;
            CowNodeElement nodeElement = (CowNodeElement)entry.getValue();
            if (param == 3) {
                node.commitRelationshipMaps(nodeElement.relationshipAddMap, nodeElement.relationshipRemoveMap, this.nodeManager);
                node.commitPropertyMaps(nodeElement.propertyAddMap, nodeElement.propertyRemoveMap, nodeElement.firstProp, this.nodeManager);
                continue;
            }
            if (param == 4) continue;
            throw new TransactionFailureException("Unknown transaction status: " + param);
        }
        ArrayMap cowRelElements = element.relationships;
        Set relEntrySet = cowRelElements.entrySet();
        for (Map.Entry entry : relEntrySet) {
            RelationshipImpl rel = this.nodeManager.getRelIfCached((Long)entry.getKey());
            if (rel == null) continue;
            CowRelElement relElement = (CowRelElement)entry.getValue();
            if (param == 3) {
                rel.commitPropertyMaps(relElement.propertyAddMap, relElement.propertyRemoveMap, Record.NO_NEXT_PROPERTY.intValue(), this.nodeManager);
                continue;
            }
            if (param == 4) continue;
            throw new TransactionFailureException("Unknown transaction status: " + param);
        }
        if (element.graph != null && param == 3) {
            this.nodeManager.getGraphProperties().commitPropertyMaps(element.graph.getPropertyAddMap(false), element.graph.getPropertyRemoveMap(false), Record.NO_NEXT_PROPERTY.intValue(), this.nodeManager);
        }
        this.cowMap.remove(cowTxId);
    }

    public void dumpLocks() {
        System.out.print("Locks held: ");
        Iterator<Transaction> itr = this.lockMap.keySet().iterator();
        if (!itr.hasNext()) {
            System.out.println("NONE");
        } else {
            System.out.println();
        }
        while (itr.hasNext()) {
            Transaction transaction = itr.next();
            System.out.println("" + transaction + "->" + this.lockMap.get(transaction).size());
        }
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive) {
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement == null) {
            return null;
        }
        CowEntityElement element = primitive.getEntityElement(primitiveElement, false);
        return element != null ? element.getPropertyRemoveMap(false) : null;
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive) {
        PrimitiveElement primitiveElement = this.cowMap.get(this.getTransaction());
        if (primitiveElement == null) {
            return null;
        }
        CowEntityElement element = primitive.getEntityElement(primitiveElement, false);
        return element != null ? element.getPropertyAddMap(false) : null;
    }

    public PrimitiveElement getPrimitiveElement(boolean create) {
        return this.getPrimitiveElement(this.getTransaction(), create);
    }

    public PrimitiveElement getPrimitiveElement(Transaction tx, boolean create) {
        if (tx == null) {
            throw new NotInTransactionException();
        }
        PrimitiveElement primitiveElement = this.cowMap.get(tx);
        if (primitiveElement == null && create) {
            primitiveElement = new PrimitiveElement();
            this.cowMap.put(tx, primitiveElement);
        }
        return primitiveElement;
    }

    public ArrayMap<Integer, PropertyData> getOrCreateCowPropertyAddMap(Primitive primitive) {
        return primitive.getEntityElement(this.getPrimitiveElement(true), true).getPropertyAddMap(true);
    }

    public ArrayMap<Integer, PropertyData> getOrCreateCowPropertyRemoveMap(Primitive primitive) {
        return primitive.getEntityElement(this.getPrimitiveElement(true), true).getPropertyRemoveMap(true);
    }

    public void deletePrimitive(Primitive primitive) {
        primitive.getEntityElement((PrimitiveElement)this.getPrimitiveElement((boolean)true), (boolean)true).deleted = true;
    }

    public void removeNodeFromCache(long nodeId) {
        if (this.nodeManager != null) {
            this.nodeManager.removeNodeFromCache(nodeId);
        }
    }

    public void addRelationshipType(NameData type) {
        if (this.nodeManager != null) {
            this.nodeManager.addRelationshipType(type);
        }
    }

    public void addPropertyIndex(NameData index) {
        if (this.nodeManager != null) {
            this.nodeManager.addPropertyIndex(index);
        }
    }

    public void removeRelationshipFromCache(long id) {
        if (this.nodeManager != null) {
            this.nodeManager.removeRelationshipFromCache(id);
        }
    }

    public void patchDeletedRelationshipNodes(long relId, long firstNodeId, long firstNodeNextRelId, long secondNodeId, long secondNodeNextRelId) {
        this.nodeManager.patchDeletedRelationshipNodes(relId, firstNodeId, firstNodeNextRelId, secondNodeId, secondNodeNextRelId);
    }

    public void removeRelationshipTypeFromCache(int id) {
        if (this.nodeManager != null) {
            this.nodeManager.removeRelationshipTypeFromCache(id);
        }
    }

    public void removeGraphPropertiesFromCache() {
        if (this.nodeManager != null) {
            this.nodeManager.removeGraphPropertiesFromCache();
        }
    }

    public void clearCache() {
        if (this.nodeManager != null) {
            this.nodeManager.clearCache();
        }
    }

    public TransactionData getTransactionData() {
        TransactionDataImpl result = new TransactionDataImpl();
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            return result;
        }
        PrimitiveElement element = this.cowMap.get(transaction);
        this.populateCreatedNodes(element, result);
        if (element == null) {
            return result;
        }
        if (element.nodes != null) {
            this.populateNodeRelEvent(element, result);
        }
        if (element.relationships != null) {
            this.populateRelationshipPropertyEvents(element, result);
        }
        return result;
    }

    private void populateRelationshipPropertyEvents(PrimitiveElement element, TransactionDataImpl result) {
        Iterator i$ = element.relationships.keySet().iterator();
        while (i$.hasNext()) {
            Object oldValue;
            String key;
            long relId = (Long)i$.next();
            CowRelElement relElement = (CowRelElement)element.relationships.get(relId);
            RelationshipProxy rel = this.nodeManager.newRelationshipProxyById(relId);
            RelationshipImpl relImpl = this.nodeManager.getRelationshipForProxy(relId, null);
            if (relElement.deleted && this.nodeManager.relCreated(relId)) continue;
            if (relElement.propertyAddMap != null && !relElement.deleted) {
                for (PropertyData data : relElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data);
                    oldValue = relImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.getValue();
                    result.assignedProperty(rel, key, newValue, oldValue);
                }
            }
            if (relElement.propertyRemoveMap == null) continue;
            for (PropertyData data : relElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data);
                oldValue = data.getValue();
                if (oldValue != null && !relElement.deleted) {
                    relImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(rel, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result) {
        Iterator i$ = element.nodes.keySet().iterator();
        while (i$.hasNext()) {
            Object oldValue;
            String key;
            long nodeId = (Long)i$.next();
            CowNodeElement nodeElement = (CowNodeElement)element.nodes.get(nodeId);
            NodeProxy node = this.nodeManager.newNodeProxyById(nodeId);
            NodeImpl nodeImpl = this.nodeManager.getNodeForProxy(nodeId, null);
            if (nodeElement.deleted) {
                if (this.nodeManager.nodeCreated(nodeId)) continue;
                result.deleted(node);
            }
            if (nodeElement.relationshipAddMap != null && !nodeElement.deleted) {
                for (String type : nodeElement.relationshipAddMap.keySet()) {
                    RelIdArray createdRels = (RelIdArray)nodeElement.relationshipAddMap.get(type);
                    this.populateNodeRelEvent(element, result, nodeId, createdRels);
                }
            }
            if (nodeElement.relationshipRemoveMap != null) {
                for (String type : nodeElement.relationshipRemoveMap.keySet()) {
                    Collection deletedRels = (Collection)nodeElement.relationshipRemoveMap.get(type);
                    Iterator i$2 = deletedRels.iterator();
                    while (i$2.hasNext()) {
                        RelationshipProxy rel;
                        long relId = (Long)i$2.next();
                        if (this.nodeManager.relCreated(relId) || (rel = this.nodeManager.newRelationshipProxyById(relId)).getStartNode().getId() != nodeId) continue;
                        result.deleted(this.nodeManager.newRelationshipProxyById(relId));
                    }
                }
            }
            if (nodeElement.propertyAddMap != null && !nodeElement.deleted) {
                for (PropertyData data : nodeElement.propertyAddMap.values()) {
                    key = this.nodeManager.getKeyForProperty(data);
                    oldValue = nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                    Object newValue = data.getValue();
                    result.assignedProperty(node, key, newValue, oldValue);
                }
            }
            if (nodeElement.propertyRemoveMap == null) continue;
            for (PropertyData data : nodeElement.propertyRemoveMap.values()) {
                key = this.nodeManager.getKeyForProperty(data);
                oldValue = data.getValue();
                if (oldValue == null && !nodeElement.deleted) {
                    nodeImpl.getCommittedPropertyValue(this.nodeManager, key);
                }
                result.removedProperty(node, key, oldValue);
            }
        }
    }

    private void populateNodeRelEvent(PrimitiveElement element, TransactionDataImpl result, long nodeId, RelIdArray createdRels) {
        RelIdIterator iterator = createdRels.iterator(RelIdArray.DirectionWrapper.BOTH);
        while (iterator.hasNext()) {
            RelationshipProxy rel;
            long relId = iterator.next();
            CowRelElement relElement = (CowRelElement)element.relationships.get(relId);
            if (relElement != null && relElement.deleted || (rel = this.nodeManager.newRelationshipProxyById(relId)).getStartNode().getId() != nodeId) continue;
            result.created(this.nodeManager.newRelationshipProxyById(relId));
        }
    }

    private void populateCreatedNodes(PrimitiveElement element, TransactionDataImpl result) {
        RelIdArray createdNodes = this.nodeManager.getCreatedNodes();
        RelIdIterator iterator = createdNodes.iterator(RelIdArray.DirectionWrapper.BOTH);
        while (iterator.hasNext()) {
            CowNodeElement nodeElement;
            long nodeId = iterator.next();
            if (element != null && element.nodes != null && (nodeElement = (CowNodeElement)element.nodes.get(nodeId)) != null && nodeElement.deleted) continue;
            result.created(this.nodeManager.newNodeProxyById(nodeId));
        }
    }

    boolean hasRelationshipModifications(NodeImpl node) {
        ArrayMap cowElements;
        CowNodeElement element;
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return false;
        }
        PrimitiveElement primitiveElement = this.cowMap.get(tx);
        return primitiveElement != null && (element = (CowNodeElement)(cowElements = primitiveElement.nodes).get(node.getId())) != null && (element.relationshipAddMap != null || element.relationshipRemoveMap != null);
    }

    private class ReadOnlyTxReleaser
    implements Synchronization {
        private final Transaction tx;

        ReadOnlyTxReleaser(Transaction tx) {
            this.tx = tx;
        }

        public void afterCompletion(int status) {
            LockReleaser.this.releaseLocks(this.tx);
        }

        public void beforeCompletion() {
        }
    }

    public static class LockElement {
        private final Object resource;
        private final LockType lockType;
        private boolean released;

        LockElement(Object resource, LockType type) {
            this.resource = resource;
            this.lockType = type;
        }

        public boolean releaseIfAcquired(LockManager lockManager) {
            return this.releaseIfAcquired(lockManager, null);
        }

        public boolean releaseIfAcquired(LockManager lockManager, Transaction tx) {
            if (this.released) {
                return false;
            }
            this.lockType.release(this.resource, lockManager, tx);
            this.released = true;
            return true;
        }

        public String toString() {
            StringBuilder string = new StringBuilder(this.lockType.name()).append("-LockElement[");
            if (this.released) {
                string.append("released,");
            }
            string.append(this.resource);
            return string.append(']').toString();
        }
    }

    public static class CowGraphElement
    extends CowEntityElement {
        CowGraphElement() {
            super(-1L);
        }

        public String toString() {
            return "Graph";
        }
    }

    public static class CowRelElement
    extends CowEntityElement {
        CowRelElement(long id) {
            super(id);
        }

        public String toString() {
            return "Relationship[" + this.id + "]";
        }
    }

    public static class CowNodeElement
    extends CowEntityElement {
        private long firstRel = Record.NO_NEXT_RELATIONSHIP.intValue();
        private long firstProp = Record.NO_NEXT_PROPERTY.intValue();
        private ArrayMap<String, RelIdArray> relationshipAddMap;
        private ArrayMap<String, Collection<Long>> relationshipRemoveMap;

        CowNodeElement(long id) {
            super(id);
        }

        public ArrayMap<String, RelIdArray> getRelationshipAddMap(boolean create) {
            if (this.relationshipAddMap == null && create) {
                this.relationshipAddMap = new ArrayMap();
            }
            return this.relationshipAddMap;
        }

        public RelIdArray getRelationshipAddMap(String type, boolean create) {
            ArrayMap<String, RelIdArray> map = this.getRelationshipAddMap(create);
            if (map == null) {
                return null;
            }
            RelIdArray result = map.get(type);
            if (result == null && create) {
                result = new RelIdArrayWithLoops(type);
                map.put(type, result);
            }
            return result;
        }

        public ArrayMap<String, Collection<Long>> getRelationshipRemoveMap(boolean create) {
            if (this.relationshipRemoveMap == null && create) {
                this.relationshipRemoveMap = new ArrayMap();
            }
            return this.relationshipRemoveMap;
        }

        public Collection<Long> getRelationshipRemoveMap(String type, boolean create) {
            ArrayMap<String, Collection<Long>> map = this.getRelationshipRemoveMap(create);
            if (map == null) {
                return null;
            }
            Collection<Long> result = map.get(type);
            if (result == null && create) {
                result = new HashSet<Long>();
                map.put(type, result);
            }
            return result;
        }

        public String toString() {
            return "Node[" + this.id + "]";
        }
    }

    static class CowEntityElement {
        protected long id;
        protected boolean deleted;
        protected ArrayMap<Integer, PropertyData> propertyAddMap;
        protected ArrayMap<Integer, PropertyData> propertyRemoveMap;

        CowEntityElement(long id) {
            this.id = id;
        }

        public ArrayMap<Integer, PropertyData> getPropertyAddMap(boolean create) {
            this.assertNotDeleted();
            if (this.propertyAddMap == null && create) {
                this.propertyAddMap = new ArrayMap();
            }
            return this.propertyAddMap;
        }

        private void assertNotDeleted() {
            if (this.deleted) {
                throw new IllegalStateException(this + " has been deleted in this tx");
            }
        }

        public ArrayMap<Integer, PropertyData> getPropertyRemoveMap(boolean create) {
            if (this.propertyRemoveMap == null && create) {
                this.propertyRemoveMap = new ArrayMap();
            }
            return this.propertyRemoveMap;
        }
    }

    public static class PrimitiveElement {
        private final ArrayMap<Long, CowNodeElement> nodes = new ArrayMap();
        private final ArrayMap<Long, CowRelElement> relationships = new ArrayMap();
        private CowGraphElement graph;

        PrimitiveElement() {
        }

        public CowNodeElement nodeElement(long id, boolean create) {
            CowNodeElement result = this.nodes.get(id);
            if (result == null && create) {
                result = new CowNodeElement(id);
                this.nodes.put(id, result);
            }
            return result;
        }

        public CowRelElement relationshipElement(long id, boolean create) {
            CowRelElement result = this.relationships.get(id);
            if (result == null && create) {
                result = new CowRelElement(id);
                this.relationships.put(id, result);
            }
            return result;
        }

        public CowGraphElement graphElement(boolean create) {
            if (this.graph == null && create) {
                this.graph = new CowGraphElement();
            }
            return this.graph;
        }
    }
}

