/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class AutoConfigurator {
    private final int totalPhysicalMemMb;
    private final int maxVmUsageMb;
    private final String dbPath;
    private final boolean useMemoryMapped;
    private final FileSystemAbstraction fs;

    public AutoConfigurator(FileSystemAbstraction fs, String dbPath, boolean useMemoryMapped) {
        this(fs, dbPath, useMemoryMapped, AutoConfigurator.physicalMemory(), Runtime.getRuntime().maxMemory());
    }

    AutoConfigurator(FileSystemAbstraction fs, String dbPath, boolean useMemoryMapped, long physicalMemory, long vmMemory) {
        this.fs = fs;
        this.dbPath = dbPath;
        this.useMemoryMapped = useMemoryMapped;
        this.totalPhysicalMemMb = physicalMemory != -1L ? (int)(physicalMemory / 1024L / 1024L) : -1;
        this.maxVmUsageMb = (int)(vmMemory / 1024L / 1024L);
    }

    private static long physicalMemory() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        long mem = -1L;
        try {
            Class<?> beanClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            Method method = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            mem = (Long)method.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return mem;
    }

    public String getNiceMemoryInformation() {
        return "Physical mem: " + this.totalPhysicalMemMb + "MB, Heap size: " + this.maxVmUsageMb + "MB";
    }

    public Map<String, String> configure() {
        HashMap<String, String> autoConfiguredConfig = new HashMap<String, String>();
        if (this.totalPhysicalMemMb > 0) {
            if (this.useMemoryMapped) {
                int availableMem = this.totalPhysicalMemMb - this.maxVmUsageMb;
                availableMem -= (int)((float)availableMem * 0.15f);
                this.assignMemory(autoConfiguredConfig, availableMem);
            } else {
                this.assignMemory(autoConfiguredConfig, this.maxVmUsageMb / 2);
            }
        }
        return autoConfiguredConfig;
    }

    private int calculate(int memLeft, int storeSize, float use, float expand, boolean canExpand) {
        int size = (float)storeSize > (float)memLeft * use ? (int)((float)memLeft * use) : (canExpand ? ((float)storeSize * expand * 5.0f < (float)memLeft * use ? (int)((float)memLeft * use / 5.0f) : (int)((float)memLeft * use)) : storeSize);
        return size;
    }

    private void assignMemory(Map<String, String> config, int availableMem) {
        int nodeStore = this.getFileSizeMb("nodestore.db");
        int relStore = this.getFileSizeMb("relationshipstore.db");
        int propStore = this.getFileSizeMb("propertystore.db");
        int stringStore = this.getFileSizeMb("propertystore.db.strings");
        int arrayStore = this.getFileSizeMb("propertystore.db.arrays");
        int totalSize = nodeStore + relStore + propStore + stringStore + arrayStore;
        boolean expand = false;
        if ((float)totalSize * 1.15f < (float)availableMem) {
            expand = true;
        }
        int memLeft = availableMem;
        relStore = this.calculate(memLeft, relStore, 0.75f, 1.1f, expand);
        nodeStore = this.calculate(memLeft -= relStore, nodeStore, 0.2f, 1.1f, expand);
        propStore = this.calculate(memLeft -= nodeStore, propStore, 0.75f, 1.1f, expand);
        stringStore = this.calculate(memLeft -= propStore, stringStore, 0.75f, 1.1f, expand);
        arrayStore = this.calculate(memLeft -= stringStore, arrayStore, 1.0f, 1.1f, expand);
        memLeft -= arrayStore;
        this.configPut(config, "nodestore.db", nodeStore);
        this.configPut(config, "relationshipstore.db", relStore);
        this.configPut(config, "propertystore.db", propStore);
        this.configPut(config, "propertystore.db.strings", stringStore);
        this.configPut(config, "propertystore.db.arrays", arrayStore);
    }

    private void configPut(Map<String, String> config, String store, int size) {
        String key = "neostore." + store + ".mapped_memory";
        config.put(key, size + "M");
    }

    private int getFileSizeMb(String file) {
        long length = this.fs.getFileSize(this.dbPath + File.separator + "neostore." + file);
        int mb = (int)(length / 1024L / 1024L);
        if (mb > 0) {
            return mb;
        }
        return 1;
    }
}

