/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.util.Bits;

public abstract class LongerShortString
extends Enum<LongerShortString> {
    public static final /* enum */ LongerShortString NUMERICAL;
    public static final /* enum */ LongerShortString DATE;
    public static final /* enum */ LongerShortString UPPER;
    public static final /* enum */ LongerShortString LOWER;
    public static final /* enum */ LongerShortString EMAIL;
    public static final /* enum */ LongerShortString URI;
    public static final /* enum */ LongerShortString ALPHANUM;
    public static final /* enum */ LongerShortString ALPHASYM;
    public static final /* enum */ LongerShortString EUROPEAN;
    public static final int REMOVE_LARGE_ENCODINGS_MASK;
    public static final LongerShortString[] ENCODINGS;
    public static final int ENCODING_COUNT;
    public static final int ALL_BIT_MASK;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_LATIN1 = 10;
    final int encodingHeader;
    final long mask;
    final int step;
    private static final char[] PUNCTUATION;
    private static final int TRANSLATION_COUNT = 256;
    private static final byte[] TRANSLATION;
    private static final int[] REMOVE_MASK;
    private static final LongerShortString[] ENCODINGS_BY_ENCODING;
    private static final /* synthetic */ LongerShortString[] $VALUES;

    public static LongerShortString[] values() {
        return (LongerShortString[])$VALUES.clone();
    }

    public static LongerShortString valueOf(String name) {
        return Enum.valueOf(LongerShortString.class, name);
    }

    private LongerShortString(int encodingHeader, int step) {
        this.encodingHeader = encodingHeader;
        this.mask = Bits.rightOverflowMask(step);
        this.step = step;
    }

    int maxLength(int payloadSize) {
        return ((payloadSize << 3) - 24 - 4 - 4 - 6) / this.step;
    }

    final IllegalArgumentException cannotEncode(byte b) {
        return new IllegalArgumentException("Cannot encode as " + this.name() + ": " + b);
    }

    final char decPunctuation(int code) {
        return PUNCTUATION[code];
    }

    int encTranslate(byte b) {
        if (b < 0) {
            return (0xFF & b) - 192;
        }
        if (b < 32) {
            return this.encPunctuation(b);
        }
        if (b >= 48 && b <= 52) {
            return 91 + b - 48;
        }
        if (b >= 53 && b <= 57) {
            return 123 + b - 53;
        }
        return b;
    }

    abstract int encPunctuation(byte var1);

    abstract char decTranslate(byte var1);

    public static boolean encode(int keyId, String string, PropertyBlock target, int payloadSize) {
        int dataLength = string.length();
        if (dataLength > NUMERICAL.maxLength(payloadSize) || dataLength > 63) {
            return false;
        }
        byte[] data = new byte[dataLength];
        int encodings = LongerShortString.determineEncoding(string, data, dataLength, payloadSize);
        if (encodings != 0 && LongerShortString.tryEncode(encodings, keyId, target, payloadSize, data, dataLength)) {
            return true;
        }
        return LongerShortString.encodeWithCharSet(keyId, string, target, payloadSize, dataLength);
    }

    private static boolean encodeWithCharSet(int keyId, String string, PropertyBlock target, int payloadSize, int stringLength) {
        int maxBytes = PropertyType.getPayloadSize();
        if (stringLength <= maxBytes - 5) {
            if (LongerShortString.encodeLatin1(keyId, string, target)) {
                return true;
            }
            if (LongerShortString.encodeUTF8(keyId, string, target, payloadSize)) {
                return true;
            }
        }
        return false;
    }

    private static boolean tryEncode(int encodings, int keyId, PropertyBlock target, int payloadSize, byte[] data, int length) {
        for (LongerShortString encoding : ENCODINGS) {
            if ((encoding.bitMask() & encodings) == 0 || !encoding.doEncode(keyId, data, target, payloadSize, length)) continue;
            return true;
        }
        return false;
    }

    static int invertedBitMask(LongerShortString ... encoders) {
        return ~LongerShortString.bitMask(encoders);
    }

    private static int bitMask(LongerShortString[] encoders) {
        int result = 0;
        for (LongerShortString encoder : encoders) {
            result |= encoder.bitMask();
        }
        return result;
    }

    private static void setUp(char pos, int value, LongerShortString ... removeEncodings) {
        LongerShortString.TRANSLATION[pos] = (byte)value;
        LongerShortString.REMOVE_MASK[pos] = LongerShortString.invertedBitMask(removeEncodings);
    }

    private static int determineEncoding(String string, byte[] data, int length, int payloadSize) {
        if (length == 0) {
            return 0;
        }
        int encodings = ALL_BIT_MASK;
        if (length > ALPHANUM.maxLength(payloadSize)) {
            encodings &= REMOVE_LARGE_ENCODINGS_MASK;
        }
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0100') {
                return 0;
            }
            data[i] = TRANSLATION[c];
            if ((encodings &= REMOVE_MASK[c]) != 0) continue;
            return 0;
        }
        return encodings;
    }

    int bitMask() {
        return 1 << this.ordinal();
    }

    private static void writeHeader(Bits bits, int keyId, int encoding, int stringLength) {
        bits.put(keyId, 24).put(PropertyType.SHORT_STRING.intValue(), 4).put(encoding, 5).put(stringLength, 6);
    }

    public static String decode(PropertyBlock block) {
        Bits bits = Bits.bitsFromLongs(Arrays.copyOf(block.getValueBlocks(), block.getValueBlocks().length));
        long firstLong = bits.getLongs()[0];
        if ((firstLong & 0xFFFFFF0FFFFFFFFFL) == 0L) {
            return "";
        }
        bits.getInt(24);
        bits.getByte(4);
        byte encoding = bits.getByte(5);
        int stringLength = bits.getByte(6);
        if (encoding == 0) {
            return LongerShortString.decodeUTF8(bits, stringLength);
        }
        if (encoding == 10) {
            return LongerShortString.decodeLatin1(bits, stringLength);
        }
        LongerShortString table = LongerShortString.getEncodingTable(encoding);
        char[] result = new char[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            byte codePoint = bits.getByte(table.step);
            result[i] = table.decTranslate(codePoint);
        }
        return String.valueOf(result);
    }

    private static LongerShortString getEncodingTable(int encodingHeader) {
        LongerShortString encoding = ENCODINGS_BY_ENCODING[encodingHeader];
        if (encoding == null) {
            throw new IllegalArgumentException("Invalid encoding '" + (Object)((Object)encoding) + "'");
        }
        return encoding;
    }

    private static Bits newBits(LongerShortString encoding, int length) {
        return Bits.bits(LongerShortString.calculateNumberOfBlocksUsed(encoding, length) << 3);
    }

    private static Bits newBitsForStep8(int length) {
        return Bits.bits(LongerShortString.calculateNumberOfBlocksUsedForStep8(length) << 3);
    }

    private static boolean encodeLatin1(int keyId, String string, PropertyBlock target) {
        int length = string.length();
        Bits bits = LongerShortString.newBitsForStep8(length);
        LongerShortString.writeHeader(bits, keyId, 10, length);
        if (!LongerShortString.writeLatin1Characters(string, bits)) {
            return false;
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    public static boolean writeLatin1Characters(String string, Bits bits) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c >= '\u0100') {
                return false;
            }
            bits.put(c, 8);
        }
        return true;
    }

    private static boolean encodeUTF8(int keyId, String string, PropertyBlock target, int payloadSize) {
        try {
            byte[] bytes = string.getBytes("UTF-8");
            int length = bytes.length;
            if (length > payloadSize - 3 - 2) {
                return false;
            }
            Bits bits = LongerShortString.newBitsForStep8(length);
            LongerShortString.writeHeader(bits, keyId, 0, length);
            for (byte value : bytes) {
                bits.put(value);
            }
            target.setValueBlocks(bits.getLongs());
            return true;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("All JVMs must support UTF-8", e);
        }
    }

    private boolean doEncode(int keyId, byte[] data, PropertyBlock target, int payloadSize, int length) {
        if (length > this.maxLength(payloadSize)) {
            return false;
        }
        Bits bits = LongerShortString.newBits(this, length);
        LongerShortString.writeHeader(bits, keyId, this.encodingHeader, length);
        if (length > 0) {
            this.translateData(bits, data, length, this.step);
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    private void translateData(Bits bits, byte[] data, int length, int step) {
        for (int i = 0; i < length; ++i) {
            bits.put(this.encTranslate(data[i]), step);
        }
    }

    private static String decodeLatin1(Bits bits, int stringLength) {
        char[] result = new char[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    private static String decodeUTF8(Bits bits, int stringLength) {
        byte[] result = new byte[stringLength];
        for (int i = 0; i < stringLength; ++i) {
            result[i] = bits.getByte();
        }
        try {
            return new String(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("All JVMs must support UTF-8", e);
        }
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int encoding = (int)((firstBlock & 0x1F0000000L) >> 28);
        int length = (int)((firstBlock & 0x7E00000000L) >> 33);
        if (encoding == 0 || encoding == 10) {
            return LongerShortString.calculateNumberOfBlocksUsedForStep8(length);
        }
        return LongerShortString.calculateNumberOfBlocksUsed(LongerShortString.getEncodingTable(encoding), length);
    }

    public static int calculateNumberOfBlocksUsedForStep8(int length) {
        return LongerShortString.totalBits(length << 3);
    }

    public static int calculateNumberOfBlocksUsed(LongerShortString encoding, int length) {
        return LongerShortString.totalBits(length * encoding.step);
    }

    private static int totalBits(int bitsForCharacters) {
        int bitsInTotal = 39 + bitsForCharacters;
        return (bitsInTotal - 1 >> 6) + 1;
    }

    static {
        char c;
        NUMERICAL = new LongerShortString(1, 4){

            @Override
            int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                switch (b) {
                    case 0: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 12;
                    }
                    case 6: {
                        return 13;
                    }
                    case 7: {
                        return 14;
                    }
                    case 8: {
                        return 15;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (char)(codePoint + 48);
                }
                return this.decPunctuation(codePoint - 10 + 6);
            }
        };
        DATE = new LongerShortString(2, 4){

            @Override
            int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                switch (b) {
                    case 0: {
                        return 10;
                    }
                    case 3: {
                        return 11;
                    }
                    case 4: {
                        return 12;
                    }
                    case 5: {
                        return 13;
                    }
                    case 6: {
                        return 14;
                    }
                    case 7: {
                        return 15;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (char)(codePoint + 48);
                }
                switch (codePoint) {
                    case 10: {
                        return ' ';
                    }
                    case 11: {
                        return '-';
                    }
                    case 12: {
                        return ':';
                    }
                    case 13: {
                        return '/';
                    }
                    case 14: {
                        return '+';
                    }
                }
                return ',';
            }
        };
        UPPER = new LongerShortString(3, 5){

            @Override
            int encTranslate(byte b) {
                return super.encTranslate(b) - 64;
            }

            @Override
            int encPunctuation(byte b) {
                return b == 0 ? 64 : b + 90;
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 65 - 1);
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        LOWER = new LongerShortString(4, 5){

            @Override
            int encTranslate(byte b) {
                return super.encTranslate(b) - 96;
            }

            @Override
            int encPunctuation(byte b) {
                return b == 0 ? 96 : b + 122;
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 97 - 1);
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        EMAIL = new LongerShortString(5, 5){

            @Override
            int encTranslate(byte b) {
                return super.encTranslate(b) - 96;
            }

            @Override
            int encPunctuation(byte b) {
                int encOffset = 96;
                if (b == 7) {
                    return encOffset;
                }
                int offset = encOffset + 27;
                switch (b) {
                    case 1: {
                        return 0 + offset;
                    }
                    case 2: {
                        return 1 + offset;
                    }
                    case 3: {
                        return 2 + offset;
                    }
                    case 6: {
                        return 3 + offset;
                    }
                    case 9: {
                        return 4 + offset;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ',';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 97 - 1);
                }
                switch (codePoint) {
                    case 30: {
                        return '+';
                    }
                    case 31: {
                        return '@';
                    }
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        URI = new LongerShortString(6, 6){

            @Override
            int encTranslate(byte b) {
                if (b == 0) {
                    return 0;
                }
                if (b >= 97 && b <= 122) {
                    return b - 96;
                }
                if (b >= 48 && b <= 57) {
                    return b - 16;
                }
                if (b >= 1 && b <= 22) {
                    return b + 41;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 97 - 1);
                }
                if (codePoint <= 41) {
                    return (char)(codePoint - 32 + 48);
                }
                if (codePoint <= 46) {
                    return this.decPunctuation(codePoint - 41);
                }
                return this.decPunctuation(codePoint - 47 + 9);
            }
        };
        ALPHANUM = new LongerShortString(7, 6){

            @Override
            char decTranslate(byte codePoint) {
                return EUROPEAN.decTranslate((byte)(codePoint + 64));
            }

            @Override
            int encTranslate(byte b) {
                if (b < 32) {
                    return this.encPunctuation(b);
                }
                return EUROPEAN.encTranslate(b) - 64;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 32;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        ALPHASYM = new LongerShortString(8, 6){

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(65 + codePoint - 1);
                }
                if (codePoint <= 31) {
                    return this.decPunctuation(codePoint - 27 + 1);
                }
                if (codePoint == 32) {
                    return ';';
                }
                if (codePoint <= 58) {
                    return (char)(97 + codePoint - 33);
                }
                return this.decPunctuation(codePoint - 59 + 9);
            }

            @Override
            int encTranslate(byte b) {
                if (b < 32) {
                    return this.encPunctuation(b);
                }
                return b - 64;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 27;
                    }
                    case 2: {
                        return 28;
                    }
                    case 3: {
                        return 29;
                    }
                    case 4: {
                        return 30;
                    }
                    case 5: {
                        return 31;
                    }
                    case 6: {
                        return 59;
                    }
                    case 7: {
                        return 60;
                    }
                    case 8: {
                        return 61;
                    }
                    case 9: {
                        return 62;
                    }
                    case 10: {
                        return 63;
                    }
                    case 11: {
                        return 32;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        EUROPEAN = new LongerShortString(9, 7){

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 64) {
                    if (codePoint == 23) {
                        return '.';
                    }
                    if (codePoint == 55) {
                        return '-';
                    }
                    return (char)(codePoint + 192);
                }
                if (codePoint == 64) {
                    return ' ';
                }
                if (codePoint == 96) {
                    return '_';
                }
                if (codePoint >= 91 && codePoint < 96) {
                    return (char)(48 + codePoint - 91);
                }
                if (codePoint >= 123 && codePoint < 128) {
                    return (char)(53 + codePoint - 123);
                }
                return (char)codePoint;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 64;
                    }
                    case 1: {
                        return 96;
                    }
                    case 2: {
                        return 23;
                    }
                    case 3: {
                        return 55;
                    }
                    case 7: {
                        return 0;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        $VALUES = new LongerShortString[]{NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, ALPHASYM, EUROPEAN};
        REMOVE_LARGE_ENCODINGS_MASK = LongerShortString.invertedBitMask(ALPHANUM, ALPHASYM, URI, EUROPEAN);
        ENCODINGS = LongerShortString.values();
        ENCODING_COUNT = ENCODINGS.length;
        ALL_BIT_MASK = LongerShortString.bitMask(LongerShortString.values());
        PUNCTUATION = new char[]{' ', '_', '.', '-', ':', '/', ' ', '.', '-', '+', ',', '\'', '@', '|', ';', '*', '?', '&', '%', '#', '(', ')', '$', '<', '>', '='};
        TRANSLATION = new byte[256];
        REMOVE_MASK = new int[256];
        Arrays.fill(TRANSLATION, (byte)-1);
        Arrays.fill(REMOVE_MASK, LongerShortString.invertedBitMask(ENCODINGS));
        LongerShortString.setUp(' ', 0, EMAIL);
        LongerShortString.setUp('_', 1, NUMERICAL, DATE);
        LongerShortString.setUp('.', 2, DATE, ALPHANUM);
        LongerShortString.setUp('-', 3, ALPHANUM);
        LongerShortString.setUp(':', 4, ALPHANUM, NUMERICAL, EUROPEAN, EMAIL);
        LongerShortString.setUp('/', 5, ALPHANUM, NUMERICAL, EUROPEAN, EMAIL);
        LongerShortString.setUp('+', 6, UPPER, LOWER, ALPHANUM, EUROPEAN);
        LongerShortString.setUp(',', 7, UPPER, LOWER, ALPHANUM, EUROPEAN);
        LongerShortString.setUp('\'', 8, DATE, UPPER, LOWER, EMAIL, ALPHANUM, EUROPEAN);
        LongerShortString.setUp('@', 9, NUMERICAL, DATE, UPPER, LOWER, ALPHANUM, EUROPEAN);
        LongerShortString.setUp('|', 10, NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, EUROPEAN);
        LongerShortString[] retainUri = new LongerShortString[]{NUMERICAL, DATE, UPPER, LOWER, EMAIL, ALPHANUM, ALPHASYM, EUROPEAN};
        LongerShortString.setUp(';', 11, retainUri);
        LongerShortString.setUp('*', 12, retainUri);
        LongerShortString.setUp('?', 13, retainUri);
        LongerShortString.setUp('&', 14, retainUri);
        LongerShortString.setUp('%', 15, retainUri);
        LongerShortString.setUp('#', 16, retainUri);
        LongerShortString.setUp('(', 17, retainUri);
        LongerShortString.setUp(')', 18, retainUri);
        LongerShortString.setUp('$', 19, retainUri);
        LongerShortString.setUp('<', 20, retainUri);
        LongerShortString.setUp('>', 21, retainUri);
        LongerShortString.setUp('=', 22, retainUri);
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, LOWER, EMAIL, URI);
        }
        for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, UPPER);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, UPPER, LOWER, EMAIL, ALPHASYM);
        }
        for (c = '\u00c0'; c <= '\u00ff'; c = (char)(c + 1)) {
            if (c == 215 || c == 247) continue;
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, ALPHASYM);
        }
        ENCODINGS_BY_ENCODING = new LongerShortString[ENCODING_COUNT + 1];
        LongerShortString[] arr$ = ENCODINGS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LongerShortString encoding;
            LongerShortString.ENCODINGS_BY_ENCODING[encoding.encodingHeader] = encoding = arr$[i$];
        }
    }
}

