/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.core.ArrayBasedPrimitive;
import org.neo4j.kernel.impl.core.IntArrayIterator;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.CombinedRelIdIterator;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdIterator;

public class NodeImpl
extends ArrayBasedPrimitive {
    private static final RelIdArray[] NO_RELATIONSHIPS = new RelIdArray[0];
    private volatile RelIdArray[] relationships;
    private volatile long relChainPosition = Record.NO_NEXT_RELATIONSHIP.intValue();
    private final long id;

    NodeImpl(long id, long firstRel, long firstProp) {
        this(id, firstRel, firstProp, false);
    }

    NodeImpl(long id, long firstRel, long firstProp, boolean newNode) {
        super(newNode);
        this.id = id;
        if (newNode) {
            this.relationships = NO_RELATIONSHIPS;
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int size() {
        int size = super.size() + 8 + 8 + 8;
        if (this.relationships != null) {
            size = SizeOfs.withArrayOverheadIncludingReferences(size, this.relationships.length);
            for (RelIdArray array : this.relationships) {
                size += array.size();
            }
        }
        return size;
    }

    @Override
    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof NodeImpl && ((NodeImpl)obj).getId() == this.getId();
    }

    @Override
    protected PropertyData changeProperty(NodeManager nodeManager, PropertyData property, Object value) {
        return nodeManager.nodeChangeProperty(this, property, value);
    }

    @Override
    protected PropertyData addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.nodeAddProperty(this, index, value);
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, PropertyData property) {
        nodeManager.nodeRemoveProperty(this, property);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadProperties(this, light);
    }

    Iterable<Relationship> getAllRelationships(NodeManager nodeManager, RelIdArray.DirectionWrapper direction) {
        this.ensureRelationshipMapNotNull(nodeManager);
        boolean hasMore = this.hasMoreRelationshipsToLoad();
        LinkedList<RelIdIterator> relTypeList = new LinkedList<RelIdIterator>();
        boolean hasModifications = nodeManager.getLockReleaser().hasRelationshipModifications(this);
        ArrayMap<String, RelIdArray> addMap = null;
        if (hasModifications) {
            addMap = nodeManager.getCowRelationshipAddMap(this);
        }
        for (RelIdArray src : this.relationships) {
            String type = src.getType();
            Collection<Long> remove = null;
            RelIdArray add = null;
            RelIdIterator iterator = null;
            if (hasModifications) {
                remove = nodeManager.getCowRelationshipRemoveMap(this, type);
                if (addMap != null) {
                    add = addMap.get(type);
                }
                iterator = new CombinedRelIdIterator(type, direction, src, add, remove);
            } else {
                iterator = src.iterator(direction);
            }
            relTypeList.add(iterator);
        }
        if (addMap != null) {
            for (String type : addMap.keySet()) {
                if (this.getRelIdArray(type) != null) continue;
                Collection<Long> remove = nodeManager.getCowRelationshipRemoveMap(this, type);
                RelIdArray add = addMap.get(type);
                relTypeList.add(new CombinedRelIdIterator(type, direction, null, add, remove));
            }
        }
        return new IntArrayIterator(relTypeList, this, direction, nodeManager, new RelationshipType[0], hasMore);
    }

    Iterable<Relationship> getAllRelationshipsOfType(NodeManager nodeManager, RelIdArray.DirectionWrapper direction, RelationshipType ... types) {
        this.ensureRelationshipMapNotNull(nodeManager);
        boolean hasMore = this.hasMoreRelationshipsToLoad();
        LinkedList<RelIdIterator> relTypeList = new LinkedList<RelIdIterator>();
        boolean hasModifications = nodeManager.getLockReleaser().hasRelationshipModifications(this);
        for (RelationshipType type : types) {
            String typeName = type.name();
            RelIdArray src = this.getRelIdArray(typeName);
            Collection<Long> remove = null;
            RelIdArray add = null;
            RelIdIterator iterator = null;
            if (hasModifications) {
                remove = nodeManager.getCowRelationshipRemoveMap(this, typeName);
                add = nodeManager.getCowRelationshipAddMap(this, typeName);
                iterator = new CombinedRelIdIterator(typeName, direction, src, add, remove);
            } else {
                iterator = src != null ? src.iterator(direction) : RelIdArray.empty(typeName).iterator(direction);
            }
            relTypeList.add(iterator);
        }
        return new IntArrayIterator(relTypeList, this, direction, nodeManager, types, hasMore);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager) {
        return this.getAllRelationships(nodeManager, RelIdArray.DirectionWrapper.BOTH);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction dir) {
        return this.getAllRelationships(nodeManager, RelIdArray.wrap(dir));
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.DirectionWrapper.BOTH, type);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType ... types) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.DirectionWrapper.BOTH, types);
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, Direction direction, RelationshipType ... types) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.wrap(direction), types);
    }

    public Relationship getSingleRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        Iterator<Relationship> rels = this.getAllRelationshipsOfType(nodeManager, RelIdArray.wrap(dir), type).iterator();
        if (!rels.hasNext()) {
            return null;
        }
        Relationship rel = rels.next();
        if (rels.hasNext()) {
            throw new NotFoundException("More than one relationship[" + type + ", " + (Object)((Object)dir) + "] found for " + this);
        }
        return rel;
    }

    public Iterable<Relationship> getRelationships(NodeManager nodeManager, RelationshipType type, Direction dir) {
        return this.getAllRelationshipsOfType(nodeManager, RelIdArray.wrap(dir), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NodeManager nodeManager, Node proxy) {
        nodeManager.acquireLock(proxy, LockType.WRITE);
        boolean success = false;
        try {
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getOrCreateCowPropertyRemoveMap(this);
            ArrayMap<Integer, PropertyData> removedProps = nodeManager.deleteNode(this);
            if (removedProps.size() > 0) {
                for (Integer index : removedProps.keySet()) {
                    skipMap.put(index, removedProps.get(index));
                }
            }
            success = true;
        }
        finally {
            nodeManager.releaseLock(proxy, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    public String toString() {
        return "NodeImpl#" + this.getId();
    }

    void addRelationship(NodeManager nodeManager, RelationshipType type, long relId, RelIdArray.DirectionWrapper dir) {
        RelIdArray relationshipSet = nodeManager.getOrCreateCowRelationshipAddMap(this, type.name());
        relationshipSet.add(relId, dir);
    }

    void removeRelationship(NodeManager nodeManager, RelationshipType type, long relId) {
        Collection<Long> relationshipSet = nodeManager.getOrCreateCowRelationshipRemoveMap(this, type.name());
        relationshipSet.add(relId);
    }

    private void ensureRelationshipMapNotNull(NodeManager nodeManager) {
        if (this.relationships == null) {
            this.loadInitialRelationships(nodeManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitialRelationships(NodeManager nodeManager) {
        Triplet<ArrayMap<String, RelIdArray>, List<RelationshipImpl>, Long> rels = null;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (this.relationships == null) {
                try {
                    this.relChainPosition = nodeManager.getRelationshipChainPosition(this);
                }
                catch (InvalidRecordException e) {
                    throw new NotFoundException(this.asProxy(nodeManager) + " concurrently deleted while loading its relationships?", e);
                }
                ArrayMap<String, RelIdArray> tmpRelMap = new ArrayMap<String, RelIdArray>();
                rels = this.getMoreRelationships(nodeManager, tmpRelMap);
                this.relationships = this.toRelIdArray(tmpRelMap);
                if (rels != null) {
                    this.setRelChainPosition(rels.third());
                }
                this.updateSize(nodeManager);
            }
        }
        if (rels != null) {
            nodeManager.putAllInRelCache((Collection)rels.second());
        }
    }

    @Override
    protected void updateSize(NodeManager nodeManager) {
        nodeManager.updateCacheSize(this, this.size());
    }

    private RelIdArray[] toRelIdArray(ArrayMap<String, RelIdArray> tmpRelMap) {
        if (tmpRelMap == null || tmpRelMap.size() == 0) {
            return NO_RELATIONSHIPS;
        }
        RelIdArray[] result = new RelIdArray[tmpRelMap.size()];
        int i = 0;
        for (RelIdArray array : tmpRelMap.values()) {
            result[i++] = array;
        }
        return result;
    }

    private Triplet<ArrayMap<String, RelIdArray>, List<RelationshipImpl>, Long> getMoreRelationships(NodeManager nodeManager, ArrayMap<String, RelIdArray> tmpRelMap) {
        if (!this.hasMoreRelationshipsToLoad()) {
            return null;
        }
        Triplet<ArrayMap<String, RelIdArray>, List<RelationshipImpl>, Long> rels = this.loadMoreRelationshipsFromNodeManager(nodeManager);
        ArrayMap<String, RelIdArray> addMap = rels.first();
        if (addMap.size() == 0) {
            return null;
        }
        for (String type : addMap.keySet()) {
            RelIdArray addRels = addMap.get(type);
            RelIdArray srcRels = tmpRelMap.get(type);
            if (srcRels == null) {
                tmpRelMap.put(type, addRels);
                continue;
            }
            RelIdArray newSrcRels = srcRels.addAll(addRels);
            if (newSrcRels == srcRels) continue;
            tmpRelMap.put(type, newSrcRels);
        }
        return rels;
    }

    boolean hasMoreRelationshipsToLoad() {
        return this.getRelChainPosition() != (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoadStatus getMoreRelationships(NodeManager nodeManager) {
        Triplet<ArrayMap<String, RelIdArray>, List<RelationshipImpl>, Long> rels;
        if (!this.hasMoreRelationshipsToLoad()) {
            return LoadStatus.NOTHING;
        }
        boolean more = false;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            if (!this.hasMoreRelationshipsToLoad()) {
                return LoadStatus.NOTHING;
            }
            rels = this.loadMoreRelationshipsFromNodeManager(nodeManager);
            ArrayMap<String, RelIdArray> addMap = rels.first();
            if (addMap.size() == 0) {
                return LoadStatus.NOTHING;
            }
            for (String type : addMap.keySet()) {
                RelIdArray addRels = addMap.get(type);
                RelIdArray srcRels = this.getRelIdArray(type);
                if (srcRels == null) {
                    this.putRelIdArray(addRels);
                    continue;
                }
                RelIdArray newSrcRels = srcRels.addAll(addRels);
                if (newSrcRels == srcRels) continue;
                this.putRelIdArray(newSrcRels);
            }
            this.setRelChainPosition(rels.third());
            more = this.hasMoreRelationshipsToLoad();
            this.updateSize(nodeManager);
        }
        nodeManager.putAllInRelCache((Collection<RelationshipImpl>)rels.second());
        return more ? LoadStatus.LOADED_MORE : LoadStatus.LOADED_END;
    }

    private Triplet<ArrayMap<String, RelIdArray>, List<RelationshipImpl>, Long> loadMoreRelationshipsFromNodeManager(NodeManager nodeManager) {
        try {
            return nodeManager.getMoreRelationships(this);
        }
        catch (InvalidRecordException e) {
            throw new NotFoundException("Unable to load one or more relationships from " + this.asProxy(nodeManager) + ". This usually happens when relationships are deleted by someone else just as we are about to load them. Please try again.", e);
        }
    }

    private RelIdArray getRelIdArray(String type) {
        for (RelIdArray array : this.relationships) {
            if (!array.getType().equals(type)) continue;
            return array;
        }
        return null;
    }

    private void putRelIdArray(RelIdArray addRels) {
        RelIdArray[] array = this.relationships;
        String expectedType = addRels.getType();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getType().equals(expectedType)) continue;
            array[i] = addRels;
            return;
        }
        array = Arrays.copyOf(array, array.length + 1);
        array[array.length - 1] = addRels;
        this.relationships = array;
    }

    public Relationship createRelationshipTo(NodeManager nodeManager, Node thisProxy, Node otherNode, RelationshipType type) {
        return nodeManager.createRelationship(thisProxy, this, otherNode, type);
    }

    public boolean hasRelationship(NodeManager nodeManager) {
        return this.getRelationships(nodeManager).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType ... types) {
        return this.getRelationships(nodeManager, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction direction, RelationshipType ... types) {
        return this.getRelationships(nodeManager, direction, types).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, Direction dir) {
        return this.getRelationships(nodeManager, dir).iterator().hasNext();
    }

    public boolean hasRelationship(NodeManager nodeManager, RelationshipType type, Direction dir) {
        return this.getRelationships(nodeManager, type, dir).iterator().hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitRelationshipMaps(ArrayMap<String, RelIdArray> cowRelationshipAddMap, ArrayMap<String, Collection<Long>> cowRelationshipRemoveMap, long firstRel, NodeManager nodeManager) {
        if (this.relationships == null) {
            return;
        }
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            Collection<Long> remove;
            if (cowRelationshipAddMap != null) {
                for (String type : cowRelationshipAddMap.keySet()) {
                    RelIdArray add = cowRelationshipAddMap.get(type);
                    remove = null;
                    if (cowRelationshipRemoveMap != null) {
                        remove = cowRelationshipRemoveMap.get(type);
                    }
                    RelIdArray src = this.getRelIdArray(type);
                    this.putRelIdArray(RelIdArray.from(src, add, remove));
                }
            }
            if (cowRelationshipRemoveMap != null) {
                for (String type : cowRelationshipRemoveMap.keySet()) {
                    RelIdArray src;
                    if (cowRelationshipAddMap != null && cowRelationshipAddMap.get(type) != null || (src = this.getRelIdArray(type)) == null) continue;
                    remove = cowRelationshipRemoveMap.get(type);
                    this.putRelIdArray(RelIdArray.from(src, null, remove));
                }
            }
            this.updateSize(nodeManager);
        }
    }

    long getRelChainPosition() {
        return this.relChainPosition;
    }

    void setRelChainPosition(long position) {
        this.relChainPosition = position;
        RelIdArray[] array = this.relationships;
        if (!this.hasMoreRelationshipsToLoad() && array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = array[i].shrink();
            }
        }
    }

    RelIdArray getRelationshipIds(String type) {
        return this.getRelIdArray(type);
    }

    RelIdArray[] getRelationshipIds() {
        return this.relationships;
    }

    @Override
    public LockReleaser.CowEntityElement getEntityElement(LockReleaser.PrimitiveElement element, boolean create) {
        return element.nodeElement(this.getId(), create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return nm.newNodeProxyById(this.getId());
    }

    static enum LoadStatus {
        NOTHING(false, false),
        LOADED_END(true, false),
        LOADED_MORE(true, true);

        private final boolean loaded;
        private final boolean more;

        private LoadStatus(boolean loaded, boolean more) {
            this.loaded = loaded;
            this.more = more;
        }

        public boolean loaded() {
            return this.loaded;
        }

        public boolean hasMoreToLoad() {
            return this.more;
        }
    }
}

