/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.index;

import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;

public abstract class UniqueFactory<T extends PropertyContainer> {
    private final Index<T> index;

    protected abstract T create(Map<String, Object> var1);

    protected abstract void initialize(T var1, Map<String, Object> var2);

    protected abstract void delete(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getOrCreate(String key, Object value) {
        Transaction tx = this.graphDatabase().beginTx();
        try {
            PropertyContainer result = (PropertyContainer)this.index.get(key, value).getSingle();
            if (result == null) {
                Map<String, Object> properties = Collections.singletonMap(key, value);
                T created = this.create(properties);
                result = this.index.putIfAbsent(created, key, value);
                if (result == null) {
                    this.initialize(created, properties);
                    result = created;
                } else {
                    this.delete(created);
                }
            }
            tx.success();
            PropertyContainer propertyContainer = result;
            return (T)propertyContainer;
        }
        finally {
            tx.finish();
        }
    }

    protected final GraphDatabaseService graphDatabase() {
        return this.index.getGraphDatabase();
    }

    protected final Index<T> index() {
        return this.index;
    }

    private UniqueFactory(Index<T> index) {
        this.index = index;
    }

    public static abstract class UniqueRelationshipFactory
    extends UniqueFactory<Relationship> {
        public UniqueRelationshipFactory(Index<Relationship> index) {
            super(index);
        }

        public UniqueRelationshipFactory(GraphDatabaseService graphdb, String index) {
            super(graphdb.index().forRelationships(index));
        }

        @Override
        protected void initialize(Relationship relationship, Map<String, Object> properties) {
        }

        @Override
        protected void delete(Relationship relationship) {
            relationship.delete();
        }
    }

    public static abstract class UniqueNodeFactory
    extends UniqueFactory<Node> {
        public UniqueNodeFactory(Index<Node> index) {
            super(index);
        }

        public UniqueNodeFactory(GraphDatabaseService graphdb, String index) {
            super(graphdb.index().forNodes(index));
        }

        @Override
        protected Node create(Map<String, Object> properties) {
            return this.graphDatabase().createNode();
        }

        @Override
        protected void delete(Node node) {
            node.delete();
        }
    }
}

