/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.lifecycle.Lifecycle;

abstract class AbstractAutoIndexerImpl<T extends PropertyContainer>
implements PropertyTracker<T>,
AutoIndexer<T>,
Lifecycle {
    protected final Set<String> propertyKeysToInclude = new HashSet<String>();
    private volatile boolean enabled;

    @Override
    public void propertyAdded(T primitive, String propertyName, Object propertyValue) {
        if (this.propertyKeysToInclude.contains(propertyName)) {
            this.getIndexInternal().add(primitive, propertyName, propertyValue);
        }
    }

    @Override
    public void propertyChanged(T primitive, String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null) {
            this.getIndexInternal().remove(primitive, propertyName, oldValue);
        }
        if (this.propertyKeysToInclude.contains(propertyName)) {
            this.getIndexInternal().add(primitive, propertyName, newValue);
        }
    }

    @Override
    public void propertyRemoved(T primitive, String propertyName, Object propertyValue) {
        this.getIndexInternal().remove(primitive, propertyName);
    }

    @Override
    public ReadableIndex<T> getAutoIndex() {
        return new IndexWrapper<T>(this.getIndexInternal());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void startAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.add(propName);
    }

    @Override
    public void stopAutoIndexingProperty(String propName) {
        this.propertyKeysToInclude.remove(propName);
    }

    @Override
    public Set<String> getAutoIndexedProperties() {
        return Collections.unmodifiableSet(this.propertyKeysToInclude);
    }

    protected abstract Index<T> getIndexInternal();

    protected Set<String> parseConfigList(String list) {
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<String> toReturn = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            if ((currentToken = currentToken.trim()).length() <= 0) continue;
            toReturn.add(currentToken);
        }
        return toReturn;
    }

    static class ReadOnlyIndexToIndexAdapter<T extends PropertyContainer>
    implements Index<T> {
        private final ReadableIndex<T> delegate;

        public ReadOnlyIndexToIndexAdapter(ReadableIndex<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Class<T> getEntityType() {
            return this.delegate.getEntityType();
        }

        @Override
        public IndexHits<T> get(String key, Object value) {
            return this.delegate.get(key, value);
        }

        @Override
        public IndexHits<T> query(String key, Object queryOrQueryObject) {
            return this.delegate.query(key, queryOrQueryObject);
        }

        @Override
        public IndexHits<T> query(Object queryOrQueryObject) {
            return this.delegate.query(queryOrQueryObject);
        }

        private UnsupportedOperationException readOnlyIndex() {
            return new UnsupportedOperationException("read only index");
        }

        @Override
        public void add(T entity, String key, Object value) {
            throw this.readOnlyIndex();
        }

        @Override
        public T putIfAbsent(T entity, String key, Object value) {
            throw this.readOnlyIndex();
        }

        @Override
        public void remove(T entity, String key, Object value) {
            throw this.readOnlyIndex();
        }

        @Override
        public void remove(T entity, String key) {
            throw this.readOnlyIndex();
        }

        @Override
        public void remove(T entity) {
            throw this.readOnlyIndex();
        }

        @Override
        public void delete() {
            throw this.readOnlyIndex();
        }

        @Override
        public boolean isWriteable() {
            return false;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            return this.delegate.getGraphDatabase();
        }
    }

    private static class IndexWrapper<K extends PropertyContainer>
    implements ReadableIndex<K> {
        private final Index<K> delegate;

        IndexWrapper(Index<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Class<K> getEntityType() {
            return this.delegate.getEntityType();
        }

        @Override
        public IndexHits<K> get(String key, Object value) {
            return this.delegate.get(key, value);
        }

        @Override
        public IndexHits<K> query(String key, Object queryOrQueryObject) {
            return this.delegate.query(key, queryOrQueryObject);
        }

        @Override
        public IndexHits<K> query(Object queryOrQueryObject) {
            return this.delegate.query(queryOrQueryObject);
        }

        @Override
        public boolean isWriteable() {
            return false;
        }

        @Override
        public GraphDatabaseService getGraphDatabase() {
            return this.delegate.getGraphDatabase();
        }
    }
}

