/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Random;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;

public class IndexProviderStore {
    private static final int RECORD_SIZE = 8;
    private static final int RECORD_COUNT = 5;
    private final long creationTime;
    private final long randomIdentifier;
    private long version;
    private final long indexVersion;
    private final FileChannel fileChannel;
    private final ByteBuffer buf = ByteBuffer.allocate(40);
    private long lastCommittedTx;
    private final File file;

    public IndexProviderStore(File file, FileSystemAbstraction fileSystem, long expectedVersion, boolean allowUpgrade) {
        this.file = file;
        try {
            if (!fileSystem.fileExists(file.getAbsolutePath())) {
                this.create(file, fileSystem, expectedVersion);
            }
            this.fileChannel = fileSystem.open(file.getAbsolutePath(), "rw");
            Long[] records = this.readRecordsWithNullDefaults(this.fileChannel, 5, allowUpgrade ? 4 : 5);
            this.creationTime = records[0];
            this.randomIdentifier = records[1];
            this.version = records[2];
            this.lastCommittedTx = records[3];
            Long readIndexVersion = records[4];
            boolean versionDiffers = this.compareExpectedVersionWithStoreVersion(expectedVersion, allowUpgrade, readIndexVersion);
            this.indexVersion = expectedVersion;
            if (versionDiffers) {
                this.writeOut();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean compareExpectedVersionWithStoreVersion(long expectedVersion, boolean allowUpgrade, Long readIndexVersion) {
        boolean versionDiffers;
        boolean bl = versionDiffers = readIndexVersion == null || readIndexVersion != expectedVersion;
        if (versionDiffers) {
            if (readIndexVersion != null && expectedVersion < readIndexVersion) {
                String expected = NeoStore.versionLongToString(expectedVersion);
                String readVersion = NeoStore.versionLongToString(readIndexVersion);
                throw new NotCurrentStoreVersionException(expected, readVersion, "Your index has been upgraded to " + readVersion + " and cannot run with an older version " + expected, false);
            }
            if (!allowUpgrade) {
                throw new UpgradeNotAllowedByConfigurationException();
            }
        }
        return versionDiffers;
    }

    private Long[] readRecordsWithNullDefaults(FileChannel fileChannel, int count, int expectAtLeastCount) throws IOException {
        this.buf.clear();
        int bytesRead = fileChannel.read(this.buf);
        int wholeRecordsRead = bytesRead / 8;
        if (wholeRecordsRead < expectAtLeastCount) {
            throw new RuntimeException("Expected to read at least " + expectAtLeastCount + " records, but could only read " + wholeRecordsRead + " (" + bytesRead + "b)");
        }
        this.buf.flip();
        Long[] result = new Long[count];
        for (int i = 0; i < wholeRecordsRead; ++i) {
            result[i] = this.buf.getLong();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(File file, FileSystemAbstraction fileSystem, long indexVersion) throws IOException {
        if (fileSystem.fileExists(file.getAbsolutePath())) {
            throw new IllegalArgumentException(file + " already exist");
        }
        AbstractInterruptibleChannel fileChannel = null;
        try {
            fileChannel = fileSystem.open(file.getAbsolutePath(), "rw");
            this.write((FileChannel)fileChannel, System.currentTimeMillis(), new Random(System.currentTimeMillis()).nextLong(), 0L, 1L, indexVersion);
        }
        finally {
            fileChannel.close();
        }
    }

    private void write(FileChannel channel, long time, long identifier, long version, long lastCommittedTxId, long indexVersion) throws IOException {
        this.buf.clear();
        this.buf.putLong(time).putLong(identifier).putLong(version).putLong(lastCommittedTxId).putLong(indexVersion);
        this.buf.flip();
        channel.position(0L);
        int written = channel.write(this.buf);
        int expectedLength = 40;
        if (written != expectedLength) {
            throw new RuntimeException("Expected to write " + expectedLength + " bytes, but wrote " + written);
        }
    }

    public File getFile() {
        return this.file;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomNumber() {
        return this.randomIdentifier;
    }

    public long getVersion() {
        return this.version;
    }

    public long getIndexVersion() {
        return this.indexVersion;
    }

    public synchronized long incrementVersion() {
        long current = this.getVersion();
        ++this.version;
        this.writeOut();
        return current;
    }

    public synchronized void setVersion(long version) {
        this.version = version;
        this.writeOut();
    }

    public synchronized void setLastCommittedTx(long txId) {
        this.lastCommittedTx = txId;
    }

    public long getLastCommittedTx() {
        return this.lastCommittedTx;
    }

    private void writeOut() {
        try {
            this.write(this.fileChannel, this.creationTime, this.randomIdentifier, this.version, this.lastCommittedTx, this.indexVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.fileChannel.isOpen()) {
            return;
        }
        this.writeOut();
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

