/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.PropertyTracker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.cache.Cache;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.persistence.EntityIdGenerator;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.transaction.LockException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class NodeManager
implements Lifecycle {
    private static Logger log = Logger.getLogger(NodeManager.class.getName());
    private long referenceNodeId = 0L;
    private Config config;
    private final GraphDatabaseService graphDbService;
    private final Cache<NodeImpl> nodeCache;
    private final Cache<RelationshipImpl> relCache;
    private final CacheProvider cacheProvider;
    private final LockManager lockManager;
    private final TransactionManager transactionManager;
    private final LockReleaser lockReleaser;
    private final PropertyIndexManager propertyIndexManager;
    private final RelationshipTypeHolder relTypeHolder;
    private final PersistenceManager persistenceManager;
    private final EntityIdGenerator idGenerator;
    private final NodeProxy.NodeLookup nodeLookup;
    private final RelationshipProxy.RelationshipLookups relationshipLookups;
    private final List<PropertyTracker<Node>> nodePropertyTrackers;
    private final List<PropertyTracker<Relationship>> relationshipPropertyTrackers;
    private static final int INDEX_COUNT = 2500;
    private static final int LOCK_STRIPE_COUNT = 32;
    private final ReentrantLock[] loadLocks = new ReentrantLock[32];
    private GraphProperties graphProperties;

    public NodeManager(Config config, GraphDatabaseService graphDb, LockManager lockManager, LockReleaser lockReleaser, TransactionManager transactionManager, PersistenceManager persistenceManager, EntityIdGenerator idGenerator, RelationshipTypeHolder relationshipTypeHolder, CacheProvider cacheProvider, PropertyIndexManager propertyIndexManager, NodeProxy.NodeLookup nodeLookup, RelationshipProxy.RelationshipLookups relationshipLookups, Cache<NodeImpl> nodeCache, Cache<RelationshipImpl> relCache) {
        this.config = config;
        this.graphDbService = graphDb;
        this.lockManager = lockManager;
        this.transactionManager = transactionManager;
        this.propertyIndexManager = propertyIndexManager;
        this.lockReleaser = lockReleaser;
        this.persistenceManager = persistenceManager;
        this.idGenerator = idGenerator;
        this.nodeLookup = nodeLookup;
        this.relationshipLookups = relationshipLookups;
        this.relTypeHolder = relationshipTypeHolder;
        this.cacheProvider = cacheProvider;
        this.nodeCache = nodeCache;
        this.relCache = relCache;
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock();
        }
        this.nodePropertyTrackers = new LinkedList<PropertyTracker<Node>>();
        this.relationshipPropertyTrackers = new LinkedList<PropertyTracker<Relationship>>();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public GraphDatabaseService getGraphDbService() {
        return this.graphDbService;
    }

    public CacheProvider getCacheType() {
        return this.cacheProvider;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        NameData[] relTypes = null;
        NameData[] propertyIndexes = null;
        relTypes = this.persistenceManager.loadAllRelationshipTypes();
        propertyIndexes = this.persistenceManager.loadPropertyIndexes(2500);
        this.addRawRelationshipTypes(relTypes);
        this.addPropertyIndexes(propertyIndexes);
        if (propertyIndexes.length < 2500) {
            this.setHasAllpropertyIndexes(true);
        }
    }

    @Override
    public void stop() {
        this.clearCache();
    }

    @Override
    public void shutdown() {
        this.nodeCache.printStatistics();
        this.relCache.printStatistics();
        this.nodeCache.clear();
        this.relCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        long id = this.idGenerator.nextId(Node.class);
        NodeImpl node = new NodeImpl(id, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue(), true);
        NodeProxy proxy = new NodeProxy(id, this.nodeLookup);
        this.acquireLock(proxy, LockType.WRITE);
        boolean success = false;
        try {
            this.persistenceManager.nodeCreate(id);
            this.nodeCache.put(node);
            success = true;
            NodeProxy nodeProxy = proxy;
            return nodeProxy;
        }
        finally {
            this.releaseLock(proxy, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
        }
    }

    public NodeProxy newNodeProxyById(long id) {
        return new NodeProxy(id, this.nodeLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship createRelationship(Node startNodeProxy, NodeImpl startNode, Node endNode, RelationshipType type) {
        if (startNode == null || endNode == null || type == null) {
            throw new IllegalArgumentException("Null parameter, startNode=" + startNode + ", endNode=" + endNode + ", type=" + type);
        }
        if (!this.relTypeHolder.isValidRelationshipType(type)) {
            this.relTypeHolder.addValidRelationshipType(type.name(), true);
        }
        long startNodeId = startNode.getId();
        long endNodeId = endNode.getId();
        NodeImpl secondNode = this.getLightNode(endNodeId);
        if (secondNode == null) {
            this.setRollbackOnly();
            throw new NotFoundException("Second node[" + endNode.getId() + "] deleted");
        }
        long id = this.idGenerator.nextId(Relationship.class);
        int typeId = this.getRelationshipTypeIdFor(type);
        RelationshipImpl rel = this.newRelationshipImpl(id, startNodeId, endNodeId, type, typeId, true);
        boolean firstNodeTaken = false;
        boolean secondNodeTaken = false;
        RelationshipProxy proxy = new RelationshipProxy(id, this.relationshipLookups);
        this.acquireLock(proxy, LockType.WRITE);
        boolean success = false;
        try {
            this.acquireLock(startNodeProxy, LockType.WRITE);
            firstNodeTaken = true;
            this.acquireLock(endNode, LockType.WRITE);
            secondNodeTaken = true;
            this.persistenceManager.relationshipCreate(id, typeId, startNodeId, endNodeId);
            if (startNodeId == endNodeId) {
                startNode.addRelationship(this, type, id, RelIdArray.DirectionWrapper.BOTH);
            } else {
                startNode.addRelationship(this, type, id, RelIdArray.DirectionWrapper.OUTGOING);
                secondNode.addRelationship(this, type, id, RelIdArray.DirectionWrapper.INCOMING);
            }
            this.relCache.put(rel);
            success = true;
            RelationshipProxy relationshipProxy = proxy;
            return relationshipProxy;
        }
        finally {
            boolean releaseFailed = false;
            if (firstNodeTaken) {
                try {
                    this.releaseLock(startNodeProxy, LockType.WRITE);
                }
                catch (Exception e) {
                    releaseFailed = true;
                    log.log(Level.SEVERE, "Failed to release lock", e);
                }
            }
            if (secondNodeTaken) {
                try {
                    this.releaseLock(endNode, LockType.WRITE);
                }
                catch (Exception e) {
                    releaseFailed = true;
                    log.log(Level.SEVERE, "Failed to release lock", e);
                }
            }
            this.releaseLock(proxy, LockType.WRITE);
            if (!success) {
                this.setRollbackOnly();
            }
            if (releaseFailed) {
                throw new LockException("Unable to release locks [" + startNode + "," + endNode + "] in relationship create->" + rel);
            }
        }
    }

    private RelationshipImpl newRelationshipImpl(long id, long startNodeId, long endNodeId, RelationshipType type, int typeId, boolean newRel) {
        return new RelationshipImpl(id, startNodeId, endNodeId, typeId, newRel);
    }

    private ReentrantLock lockId(long id) {
        int stripe = (int)(id / 32768L) % 32;
        if (stripe < 0) {
            stripe *= -1;
        }
        ReentrantLock lock = this.loadLocks[stripe];
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node getNodeByIdOrNull(long nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return new NodeProxy(nodeId, this.nodeLookup);
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            if (this.nodeCache.get(nodeId) != null) {
                NodeProxy nodeProxy = new NodeProxy(nodeId, this.nodeLookup);
                return nodeProxy;
            }
            NodeRecord record = this.persistenceManager.loadLightNode(nodeId);
            if (record == null) {
                Node node2 = null;
                return node2;
            }
            node = new NodeImpl(nodeId, record.getCommittedNextRel(), record.getCommittedNextProp());
            this.nodeCache.put(node);
            NodeProxy nodeProxy = new NodeProxy(nodeId, this.nodeLookup);
            return nodeProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    public Node getNodeById(long nodeId) throws NotFoundException {
        Node node = this.getNodeByIdOrNull(nodeId);
        if (node == null) {
            throw new NotFoundException("Node[" + nodeId + "]");
        }
        return node;
    }

    public RelationshipProxy newRelationshipProxyById(long id) {
        return new RelationshipProxy(id, this.relationshipLookups);
    }

    public Iterator<Node> getAllNodes() {
        final long highId = this.getHighestPossibleIdInUse(Node.class);
        return new PrefetchingIterator<Node>(){
            private long currentId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Node fetchNextOrNull() {
                while (this.currentId <= highId) {
                    try {
                        Node node = NodeManager.this.getNodeByIdOrNull(this.currentId);
                        if (node == null) continue;
                        Node node2 = node;
                        return node2;
                    }
                    finally {
                        ++this.currentId;
                    }
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeImpl getLightNode(long nodeId) {
        NodeImpl node = this.nodeCache.get(nodeId);
        if (node != null) {
            return node;
        }
        ReentrantLock loadLock = this.lockId(nodeId);
        try {
            node = this.nodeCache.get(nodeId);
            if (node != null) {
                NodeImpl nodeImpl = node;
                return nodeImpl;
            }
            NodeRecord record = this.persistenceManager.loadLightNode(nodeId);
            if (record == null) {
                NodeImpl nodeImpl = null;
                return nodeImpl;
            }
            node = new NodeImpl(nodeId, record.getCommittedNextRel(), record.getCommittedNextProp());
            this.nodeCache.put(node);
            NodeImpl nodeImpl = node;
            return nodeImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public NodeImpl getNodeForProxy(long nodeId, LockType lock) {
        NodeImpl node;
        if (lock != null) {
            this.acquireTxBoundLock(new NodeProxy(nodeId, this.nodeLookup), lock);
        }
        if ((node = this.getLightNode(nodeId)) == null) {
            throw new NotFoundException("Node[" + nodeId + "] not found.");
        }
        return node;
    }

    public Node getReferenceNode() throws NotFoundException {
        if (this.referenceNodeId == -1L) {
            throw new NotFoundException("No reference node set");
        }
        return this.getNodeById(this.referenceNodeId);
    }

    public void setReferenceNodeId(long nodeId) {
        this.referenceNodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Relationship getRelationshipByIdOrNull(long relId) {
        RelationshipImpl relationship = this.relCache.get(relId);
        if (relationship != null) {
            return new RelationshipProxy(relId, this.relationshipLookups);
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this.relationshipLookups);
                return relationshipProxy;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                Relationship relationship2 = null;
                return relationship2;
            }
            int typeId = data.getType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            long startNodeId = data.getFirstNode();
            long endNodeId = data.getSecondNode();
            relationship = this.newRelationshipImpl(relId, startNodeId, endNodeId, type, typeId, false);
            this.relCache.put(relationship);
            RelationshipProxy relationshipProxy = new RelationshipProxy(relId, this.relationshipLookups);
            return relationshipProxy;
        }
        finally {
            loadLock.unlock();
        }
    }

    public Relationship getRelationshipById(long id) throws NotFoundException {
        Relationship relationship = this.getRelationshipByIdOrNull(id);
        if (relationship == null) {
            throw new NotFoundException("Relationship[" + id + "]");
        }
        return relationship;
    }

    public Iterator<Relationship> getAllRelationships() {
        final long highId = this.getHighestPossibleIdInUse(Relationship.class);
        return new PrefetchingIterator<Relationship>(){
            private long currentId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Relationship fetchNextOrNull() {
                while (this.currentId <= highId) {
                    try {
                        Relationship relationship = NodeManager.this.getRelationshipByIdOrNull(this.currentId);
                        if (relationship == null) continue;
                        Relationship relationship2 = relationship;
                        return relationship2;
                    }
                    finally {
                        ++this.currentId;
                    }
                }
                return null;
            }
        };
    }

    RelationshipType getRelationshipTypeById(int id) {
        return this.relTypeHolder.getRelationshipType(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipImpl getRelationshipForProxy(long relId, LockType lock) {
        RelationshipImpl relationship;
        if (lock != null) {
            this.acquireTxBoundLock(new RelationshipProxy(relId, this.relationshipLookups), lock);
        }
        if ((relationship = this.relCache.get(relId)) != null) {
            return relationship;
        }
        ReentrantLock loadLock = this.lockId(relId);
        try {
            relationship = this.relCache.get(relId);
            if (relationship != null) {
                RelationshipImpl relationshipImpl = relationship;
                return relationshipImpl;
            }
            RelationshipRecord data = this.persistenceManager.loadLightRelationship(relId);
            if (data == null) {
                throw new NotFoundException("Relationship[" + relId + "] not found.");
            }
            int typeId = data.getType();
            RelationshipType type = this.getRelationshipTypeById(typeId);
            if (type == null) {
                throw new NotFoundException("Relationship[" + data.getId() + "] exist but relationship type[" + typeId + "] not found.");
            }
            relationship = this.newRelationshipImpl(relId, data.getFirstNode(), data.getSecondNode(), type, typeId, false);
            this.relCache.put(relationship);
            RelationshipImpl relationshipImpl = relationship;
            return relationshipImpl;
        }
        finally {
            loadLock.unlock();
        }
    }

    public void removeNodeFromCache(long nodeId) {
        this.nodeCache.remove(nodeId);
    }

    public void removeRelationshipFromCache(long relId) {
        this.relCache.remove(relId);
    }

    Object loadPropertyValue(PropertyData property) {
        return this.persistenceManager.loadPropertyValue(property);
    }

    long getRelationshipChainPosition(NodeImpl node) {
        return this.persistenceManager.getRelationshipChainPosition(node.getId());
    }

    Triplet<ArrayMap<String, RelIdArray>, List<RelationshipImpl>, Long> getMoreRelationships(NodeImpl node) {
        boolean hasLoops;
        long nodeId = node.getId();
        long position = node.getRelChainPosition();
        Pair<Map<RelIdArray.DirectionWrapper, Iterable<RelationshipRecord>>, Long> rels = this.persistenceManager.getMoreRelationships(nodeId, position);
        ArrayMap<String, RelIdArray> newRelationshipMap = new ArrayMap<String, RelIdArray>();
        ArrayList<RelationshipImpl> relsList = new ArrayList<RelationshipImpl>(150);
        Iterable<RelationshipRecord> loops = rels.first().get((Object)RelIdArray.DirectionWrapper.BOTH);
        boolean bl = hasLoops = loops != null;
        if (hasLoops) {
            this.receiveRelationships(loops, newRelationshipMap, relsList, RelIdArray.DirectionWrapper.BOTH, true);
        }
        this.receiveRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.OUTGOING), newRelationshipMap, relsList, RelIdArray.DirectionWrapper.OUTGOING, hasLoops);
        this.receiveRelationships(rels.first().get((Object)RelIdArray.DirectionWrapper.INCOMING), newRelationshipMap, relsList, RelIdArray.DirectionWrapper.INCOMING, hasLoops);
        return Triplet.of(newRelationshipMap, relsList, rels.other());
    }

    private void receiveRelationships(Iterable<RelationshipRecord> rels, ArrayMap<String, RelIdArray> newRelationshipMap, List<RelationshipImpl> relsList, RelIdArray.DirectionWrapper dir, boolean hasLoops) {
        for (RelationshipRecord rel : rels) {
            long relId = rel.getId();
            RelationshipImpl relImpl = this.relCache.get(relId);
            RelationshipType type = null;
            if (relImpl == null) {
                type = this.getRelationshipTypeById(rel.getType());
                assert (type != null);
                relImpl = this.newRelationshipImpl(relId, rel.getFirstNode(), rel.getSecondNode(), type, rel.getType(), false);
                relsList.add(relImpl);
            } else {
                type = this.getRelationshipTypeById(relImpl.getTypeId());
            }
            RelIdArray relationshipSet = newRelationshipMap.get(type.name());
            if (relationshipSet == null) {
                relationshipSet = hasLoops ? new RelIdArrayWithLoops(type.name()) : new RelIdArray(type.name());
                newRelationshipMap.put(type.name(), relationshipSet);
            }
            relationshipSet.add(relId, dir);
        }
    }

    void putAllInRelCache(Collection<RelationshipImpl> relationships) {
        this.relCache.putAll(relationships);
    }

    ArrayMap<Integer, PropertyData> loadGraphProperties(boolean light) {
        return this.persistenceManager.graphLoadProperties(light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(NodeImpl node, boolean light) {
        return this.persistenceManager.loadNodeProperties(node.getId(), light);
    }

    ArrayMap<Integer, PropertyData> loadProperties(RelationshipImpl relationship, boolean light) {
        return this.persistenceManager.loadRelProperties(relationship.getId(), light);
    }

    public void clearCache() {
        this.nodeCache.clear();
        this.relCache.clear();
        this.graphProperties = this.instantiateGraphProperties();
    }

    public Iterable<? extends Cache<?>> caches() {
        return Arrays.asList(this.nodeCache, this.relCache);
    }

    void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            log.log(Level.FINE, "Failed to set transaction rollback only", e);
        }
        catch (SystemException se) {
            log.log(Level.SEVERE, "Failed to set transaction rollback only", se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PropertyContainer> T indexPutIfAbsent(Index<T> index, T entity, String key, Object value) {
        PropertyContainer existing = (PropertyContainer)index.get(key, value).getSingle();
        if (existing != null) {
            return (T)existing;
        }
        IndexLock lock = new IndexLock(index.getName(), key);
        LockType.WRITE.acquire(lock, this.lockManager);
        try {
            existing = (PropertyContainer)index.get(key, value).getSingle();
            if (existing != null) {
                LockType.WRITE.release(lock, this.lockManager);
                PropertyContainer propertyContainer = existing;
                return (T)propertyContainer;
            }
            index.add(entity, key, value);
            T t = null;
            return t;
        }
        finally {
            if (existing == null) {
                LockType.WRITE.unacquire(lock, this.lockManager, this.lockReleaser);
            }
        }
    }

    void acquireLock(Primitive resource, LockType lockType) {
        lockType.acquire(resource.asProxy(this), this.lockManager);
    }

    void acquireLock(PropertyContainer resource, LockType lockType) {
        lockType.acquire(resource, this.lockManager);
    }

    void acquireTxBoundLock(PropertyContainer resource, LockType lockType) {
        lockType.acquire(resource, this.lockManager);
        lockType.unacquire(resource, this.lockManager, this.lockReleaser);
    }

    void acquireIndexLock(String index, String key, LockType lockType) {
        lockType.acquire(new IndexLock(index, key), this.lockManager);
    }

    void releaseLock(Primitive resource, LockType lockType) {
        lockType.unacquire(resource.asProxy(this), this.lockManager, this.lockReleaser);
    }

    void releaseLock(PropertyContainer resource, LockType lockType) {
        lockType.unacquire(resource, this.lockManager, this.lockReleaser);
    }

    void releaseIndexLock(String index, String key, LockType lockType) {
        lockType.unacquire(new IndexLock(index, key), this.lockManager, this.lockReleaser);
    }

    public long getHighestPossibleIdInUse(Class<?> clazz) {
        return this.idGenerator.getHighestPossibleIdInUse(clazz);
    }

    public long getNumberOfIdsInUse(Class<?> clazz) {
        return this.idGenerator.getNumberOfIdsInUse(clazz);
    }

    public void removeRelationshipTypeFromCache(int id) {
        this.relTypeHolder.removeRelType(id);
    }

    void addPropertyIndexes(NameData[] propertyIndexes) {
        this.propertyIndexManager.addPropertyIndexes(propertyIndexes);
    }

    void setHasAllpropertyIndexes(boolean hasAll) {
        this.propertyIndexManager.setHasAll(hasAll);
    }

    PropertyIndex getIndexFor(int keyId) {
        return this.propertyIndexManager.getIndexFor(keyId);
    }

    Iterable<PropertyIndex> index(String key) {
        return this.propertyIndexManager.index(key);
    }

    boolean hasAllPropertyIndexes() {
        return this.propertyIndexManager.hasAll();
    }

    boolean hasIndexFor(int keyId) {
        return this.propertyIndexManager.hasIndexFor(keyId);
    }

    PropertyIndex createPropertyIndex(String key) {
        return this.propertyIndexManager.createPropertyIndex(key);
    }

    int getRelationshipTypeIdFor(RelationshipType type) {
        return this.relTypeHolder.getIdFor(type);
    }

    void addRawRelationshipTypes(NameData[] relTypes) {
        this.relTypeHolder.addRawRelationshipTypes(relTypes);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.relTypeHolder.getRelationshipTypes();
    }

    ArrayMap<Integer, PropertyData> deleteNode(NodeImpl node) {
        this.deletePrimitive(node);
        return this.persistenceManager.nodeDelete(node.getId());
    }

    PropertyData nodeAddProperty(NodeImpl node, PropertyIndex index, Object value) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyAdded(this.getNodeById(node.getId()), index.getKey(), value);
            }
        }
        return this.persistenceManager.nodeAddProperty(node.getId(), index, value);
    }

    PropertyData nodeChangeProperty(NodeImpl node, PropertyData property, Object value) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyChanged(this.getNodeById(node.getId()), this.getIndexFor(property.getIndex()).getKey(), property.getValue(), value);
            }
        }
        return this.persistenceManager.nodeChangeProperty(node.getId(), property, value);
    }

    void nodeRemoveProperty(NodeImpl node, PropertyData property) {
        if (!this.nodePropertyTrackers.isEmpty()) {
            for (PropertyTracker<Node> nodePropertyTracker : this.nodePropertyTrackers) {
                nodePropertyTracker.propertyRemoved(this.getNodeById(node.getId()), this.getIndexFor(property.getIndex()).getKey(), property.getValue());
            }
        }
        this.persistenceManager.nodeRemoveProperty(node.getId(), property);
    }

    PropertyData graphAddProperty(PropertyIndex index, Object value) {
        return this.persistenceManager.graphAddProperty(index, value);
    }

    PropertyData graphChangeProperty(PropertyData property, Object value) {
        return this.persistenceManager.graphChangeProperty(property, value);
    }

    void graphRemoveProperty(PropertyData property) {
        this.persistenceManager.graphRemoveProperty(property);
    }

    ArrayMap<Integer, PropertyData> deleteRelationship(RelationshipImpl rel) {
        this.deletePrimitive(rel);
        return this.persistenceManager.relDelete(rel.getId());
    }

    PropertyData relAddProperty(RelationshipImpl rel, PropertyIndex index, Object value) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyAdded(this.getRelationshipById(rel.getId()), index.getKey(), value);
            }
        }
        return this.persistenceManager.relAddProperty(rel.getId(), index, value);
    }

    PropertyData relChangeProperty(RelationshipImpl rel, PropertyData property, Object value) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyChanged(this.getRelationshipById(rel.getId()), this.getIndexFor(property.getIndex()).getKey(), property.getValue(), value);
            }
        }
        return this.persistenceManager.relChangeProperty(rel.getId(), property, value);
    }

    void relRemoveProperty(RelationshipImpl rel, PropertyData property) {
        if (!this.relationshipPropertyTrackers.isEmpty()) {
            for (PropertyTracker<Relationship> relPropertyTracker : this.relationshipPropertyTrackers) {
                relPropertyTracker.propertyRemoved(this.getRelationshipById(rel.getId()), this.getIndexFor(property.getIndex()).getKey(), property.getValue());
            }
        }
        this.persistenceManager.relRemoveProperty(rel.getId(), property);
    }

    public Collection<Long> getCowRelationshipRemoveMap(NodeImpl node, String type) {
        return this.lockReleaser.getCowRelationshipRemoveMap(node, type);
    }

    public Collection<Long> getOrCreateCowRelationshipRemoveMap(NodeImpl node, String type) {
        return this.lockReleaser.getOrCreateCowRelationshipRemoveMap(node, type);
    }

    public ArrayMap<String, RelIdArray> getCowRelationshipAddMap(NodeImpl node) {
        return this.lockReleaser.getCowRelationshipAddMap(node);
    }

    public RelIdArray getCowRelationshipAddMap(NodeImpl node, String string) {
        return this.lockReleaser.getCowRelationshipAddMap(node, string);
    }

    public RelIdArray getOrCreateCowRelationshipAddMap(NodeImpl node, String string) {
        return this.lockReleaser.getOrCreateCowRelationshipAddMap(node, string);
    }

    public NodeImpl getNodeIfCached(long nodeId) {
        return this.nodeCache.get(nodeId);
    }

    public RelationshipImpl getRelIfCached(long nodeId) {
        return this.relCache.get(nodeId);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyRemoveMap(Primitive primitive) {
        return this.lockReleaser.getCowPropertyRemoveMap(primitive);
    }

    private void deletePrimitive(Primitive primitive) {
        this.lockReleaser.deletePrimitive(primitive);
    }

    public ArrayMap<Integer, PropertyData> getCowPropertyAddMap(Primitive primitive) {
        return this.lockReleaser.getCowPropertyAddMap(primitive);
    }

    public ArrayMap<Integer, PropertyData> getOrCreateCowPropertyAddMap(Primitive primitive) {
        return this.lockReleaser.getOrCreateCowPropertyAddMap(primitive);
    }

    public ArrayMap<Integer, PropertyData> getOrCreateCowPropertyRemoveMap(Primitive primitive) {
        return this.lockReleaser.getOrCreateCowPropertyRemoveMap(primitive);
    }

    LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    LockManager getLockManager() {
        return this.lockManager;
    }

    void addRelationshipType(NameData type) {
        this.relTypeHolder.addRawRelationshipType(type);
    }

    void addPropertyIndex(NameData index) {
        this.propertyIndexManager.addPropertyIndex(index);
    }

    public TransactionData getTransactionData() {
        return this.lockReleaser.getTransactionData();
    }

    RelIdArray getCreatedNodes() {
        return this.persistenceManager.getCreatedNodes();
    }

    boolean nodeCreated(long nodeId) {
        return this.persistenceManager.isNodeCreated(nodeId);
    }

    boolean relCreated(long relId) {
        return this.persistenceManager.isRelationshipCreated(relId);
    }

    public String getKeyForProperty(PropertyData property) {
        return this.propertyIndexManager.getIndexFor(property.getIndex()).getKey();
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.relTypeHolder;
    }

    public void addNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.add(nodePropertyTracker);
    }

    public void removeNodePropertyTracker(PropertyTracker<Node> nodePropertyTracker) {
        this.nodePropertyTrackers.remove(nodePropertyTracker);
    }

    public void addRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.add(relationshipPropertyTracker);
    }

    public void removeRelationshipPropertyTracker(PropertyTracker<Relationship> relationshipPropertyTracker) {
        this.relationshipPropertyTrackers.remove(relationshipPropertyTracker);
    }

    PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    private GraphProperties instantiateGraphProperties() {
        return new GraphProperties(this);
    }

    public GraphProperties getGraphProperties() {
        return this.graphProperties;
    }

    public void removeGraphPropertiesFromCache() {
        this.graphProperties = this.instantiateGraphProperties();
    }

    void updateCacheSize(NodeImpl node, int newSize) {
        this.nodeCache.updateSize(node, newSize);
    }

    void updateCacheSize(RelationshipImpl rel, int newSize) {
        this.relCache.updateSize(rel, newSize);
    }

    public static class IndexLock {
        private final String index;
        private final String key;

        public IndexLock(String index, String key) {
            this.index = index;
            this.key = key;
        }

        public String getIndex() {
            return this.index;
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexLock other = (IndexLock)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return "IndexLock[" + this.index + ":" + this.key + "]";
        }
    }

    public static class Configuration {
        public static final GraphDatabaseSetting.BooleanSetting use_adaptive_cache = GraphDatabaseSettings.use_adaptive_cache;
        public static final GraphDatabaseSetting.FloatSetting adaptive_cache_heap_ratio = GraphDatabaseSettings.adaptive_cache_heap_ratio;
        public static final GraphDatabaseSetting.IntegerSetting min_node_cache_size = GraphDatabaseSettings.min_node_cache_size;
        public static final GraphDatabaseSetting.IntegerSetting min_relationship_cache_size = GraphDatabaseSettings.min_relationship_cache_size;
        public static final GraphDatabaseSetting.IntegerSetting max_node_cache_size = GraphDatabaseSettings.max_node_cache_size;
        public static final GraphDatabaseSetting.IntegerSetting max_relationship_cache_size = GraphDatabaseSettings.max_relationship_cache_size;
    }
}

