/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.StringLogger;

public class ConfigurationMigrator {
    private StringLogger messageLog;
    private boolean anyDeprecatedSettings = false;

    public ConfigurationMigrator(StringLogger messageLog) {
        this.messageLog = messageLog;
    }

    public Map<String, String> migrateConfiguration(Map<String, String> inputParams) {
        HashMap<String, String> migratedConfiguration = new HashMap<String, String>();
        for (Map.Entry<String, String> configEntry : inputParams.entrySet()) {
            String key = configEntry.getKey();
            String value = configEntry.getValue();
            if (key.equals("enable_online_backup")) {
                Integer port = this.parseBackupPort(value);
                if (port != null) {
                    migratedConfiguration.put("online_backup_enabled", "true");
                    migratedConfiguration.put("online_backup_port", port.toString());
                }
                this.deprecationMessage("enable_online_backup has been replaced with online_backup_enabled and online_backup_port");
                continue;
            }
            if (key.equals("neo4j.ext.udc.disable")) {
                if ("true".equalsIgnoreCase(value)) {
                    migratedConfiguration.put("neo4j.ext.udc.enabled", "false");
                } else {
                    migratedConfiguration.put("neo4j.ext.udc.enabled", "true");
                }
                this.deprecationMessage("neo4j.ext.udc.disable has been replaced with neo4j.ext.udc.enabled");
                continue;
            }
            if (key.equals("enable_remote_shell")) {
                Object config = null;
                boolean enable = false;
                if (Config.configValueContainsMultipleParameters(value)) {
                    migratedConfiguration.put("remote_shell_enabled", "true");
                    migratedConfiguration.putAll(ConfigurationMigrator.parseShellConfigParameter(value));
                    continue;
                }
                migratedConfiguration.put("remote_shell_enabled", Boolean.parseBoolean(value) ? "true" : "false");
                continue;
            }
            migratedConfiguration.put(key, value);
        }
        return migratedConfiguration;
    }

    protected void deprecationMessage(String message) {
        if (!this.anyDeprecatedSettings) {
            this.anyDeprecatedSettings = true;
            this.messageLog.logMessage("WARNING! Deprecated configuration options used. See manual for details");
        }
        this.messageLog.logMessage(message);
    }

    private Integer parseBackupPort(String backupConfigValue) {
        if (backupConfigValue != null) {
            if (Config.configValueContainsMultipleParameters(backupConfigValue)) {
                Args args = Config.parseMapFromConfigValue("enable_online_backup", backupConfigValue);
                return args.getNumber("port", 6362).intValue();
            }
            if (Boolean.parseBoolean(backupConfigValue)) {
                return 6362;
            }
        }
        return null;
    }

    private static Map<String, String> parseShellConfigParameter(String shellConfig) {
        Args parsed = Config.parseMapFromConfigValue("enable_remote_shell", shellConfig);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("remote_shell_port", parsed.get("port", "1337"));
        map.put("remote_shell_name", parsed.get("name", "shell"));
        map.put("remote_shell_read_only", parsed.get("readonly", "false"));
        return map;
    }
}

