/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.FileLock;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.FileUtils;

public class DefaultFileSystemAbstraction
implements FileSystemAbstraction {
    @Override
    public FileChannel open(String fileName, String mode) throws IOException {
        return new RandomAccessFile(fileName, mode).getChannel();
    }

    @Override
    public FileLock tryLock(String fileName, FileChannel channel) throws IOException {
        return FileLock.getOsSpecificFileLock(fileName, channel);
    }

    @Override
    public FileChannel create(String fileName) throws IOException {
        return this.open(fileName, "rw");
    }

    @Override
    public boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    @Override
    public long getFileSize(String fileName) {
        return new File(fileName).length();
    }

    @Override
    public boolean deleteFile(String fileName) {
        return FileUtils.deleteFile(new File(fileName));
    }

    @Override
    public boolean renameFile(String from, String to) throws IOException {
        return FileUtils.renameFile(new File(from), new File(to));
    }
}

