/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.Title;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;

public class GraphDatabaseSettingsResourceBundle
extends ResourceBundle {
    @Override
    protected Object handleGetObject(String key) {
        StringBuffer optionsBuilder;
        Field settingField;
        String name;
        if (key.contains(".option.")) {
            name = key.substring(0, key.lastIndexOf(".option."));
            String option = key.substring(key.lastIndexOf(".option.") + ".option.".length());
            Field settingField2 = this.getField(name);
            StringBuffer optionsBuilder2 = new StringBuffer();
            try {
                GraphDatabaseSetting.OptionsSetting optionsSetting = (GraphDatabaseSetting.OptionsSetting)settingField2.get(null);
                Field optionField = this.findOptionField(option, optionsSetting.getClass());
                Description description = optionField.getAnnotation(Description.class);
                if (description != null) {
                    return description.value();
                }
                throw new IllegalResourceException("Could not find resource for property " + key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        name = key.substring(0, key.lastIndexOf("."));
        if (key.endsWith(".description")) {
            settingField = this.getField(name);
            return settingField.getAnnotation(Description.class).value();
        }
        if (key.endsWith(".validationmessage")) {
            settingField = this.getField(name);
            optionsBuilder = new StringBuffer();
            try {
                GraphDatabaseSetting.OptionsSetting optionsSetting = (GraphDatabaseSetting.OptionsSetting)settingField.get(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (key.endsWith(".title")) {
            settingField = this.getField(name);
            Title annotation = settingField.getAnnotation(Title.class);
            if (annotation != null) {
                return annotation.value();
            }
            name = name.replace('_', ' ');
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            return name;
        }
        if (key.endsWith(".default")) {
            settingField = this.getField(name);
            return settingField.getAnnotation(Default.class).value();
        }
        if (key.endsWith(".options")) {
            settingField = this.getField(name);
            optionsBuilder = new StringBuffer();
            try {
                for (String option : ((GraphDatabaseSetting.OptionsSetting)settingField.get(null)).options()) {
                    if (optionsBuilder.length() > 0) {
                        optionsBuilder.append(',');
                    }
                    optionsBuilder.append(option);
                }
                return optionsBuilder.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (key.endsWith(".min")) {
            try {
                settingField = this.getField(name);
                return ((GraphDatabaseSetting.NumberSetting)settingField.get(null)).getMin().toString();
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        if (key.endsWith(".max")) {
            try {
                settingField = this.getField(name);
                return ((GraphDatabaseSetting.NumberSetting)settingField.get(null)).getMax().toString();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        throw new IllegalResourceException("Could not find resource for property " + key);
    }

    private Field getField(String name) {
        for (Field field : GraphDatabaseSettings.class.getFields()) {
            if (!GraphDatabaseSetting.class.isAssignableFrom(field.getType())) continue;
            try {
                GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                if (!setting.name().equals(name)) continue;
                return field;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalResourceException("Could not find resource for property with prefix " + name);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Field field : GraphDatabaseSettings.class.getFields()) {
            try {
                GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                if (field.getAnnotation(Description.class) == null) continue;
                keys.add(setting.name() + ".description");
                keys.add(setting.name() + ".title");
                keys.add(setting.name() + ".validationmessage");
                if (field.getAnnotation(Default.class) != null) {
                    keys.add(setting.name() + ".default");
                }
                if (setting instanceof GraphDatabaseSetting.OptionsSetting) {
                    keys.add(setting.name() + ".options");
                    try {
                        for (String option : ((GraphDatabaseSetting.OptionsSetting)setting).options()) {
                            Field optionField = this.findOptionField(option, setting.getClass());
                            Description description = optionField.getAnnotation(Description.class);
                            if (description == null) continue;
                            keys.add(setting.name() + ".option." + option);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                }
                if (!(setting instanceof GraphDatabaseSetting.NumberSetting)) continue;
                GraphDatabaseSetting.NumberSetting numberSetting = (GraphDatabaseSetting.NumberSetting)setting;
                if (numberSetting.getMin() != null) {
                    keys.add(setting.name() + ".min");
                }
                if (numberSetting.getMax() == null) continue;
                keys.add(setting.name() + ".max");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return keys;
    }

    private Field findOptionField(String option, Class<? extends GraphDatabaseSetting> optionsClass) throws NoSuchFieldException {
        for (Field optionField : optionsClass.getFields()) {
            try {
                if (!option.equals(optionField.get(null))) continue;
                return optionField;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException("No field found for option " + option);
    }
}

