/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.util.ArrayList;
import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.graphdb.factory.Title;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.impl.cache.CacheProvider;

public abstract class GraphDatabaseSettings {
    @Title(value="Read only database")
    @Description(value="Whether database is read-only or not")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting read_only = new GraphDatabaseSetting.BooleanSetting("read_only");
    @Description(value="Select the type of high-level cache to use")
    @Default(value="soft")
    public static final CacheTypeSetting cache_type = new CacheTypeSetting();
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting load_kernel_extensions = new GraphDatabaseSetting.BooleanSetting("load_kernel_extensions");
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting dump_configuration = new GraphDatabaseSetting.BooleanSetting("dump_configuration");
    public static final GraphDatabaseSetting.StringSetting tx_manager_impl = new GraphDatabaseSetting.StringSetting("tx_manager_impl", ".+", "Must be class name of TransactionManager implementation");
    @Description(value="Enable this to be able to upgrade a store from 1.4 -> 1.5 or 1.4 -> 1.6")
    @Default(value="false")
    public static GraphDatabaseSetting.BooleanSetting allow_store_upgrade = new GraphDatabaseSetting.BooleanSetting("allow_store_upgrade");
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting intercept_deserialized_transactions = new GraphDatabaseSetting.BooleanSetting("intercept_deserialized_transactions");
    @Description(value="Enable this to specify a parser other than the default one. 1.5 and 1.6 are available")
    public static final GraphDatabaseSetting.OptionsSetting cypher_parser_version = new CypherParserSetting();
    @Default(value="false")
    public static GraphDatabaseSetting remote_logging_enabled = new GraphDatabaseSetting.BooleanSetting("remote_logging_enabled");
    @Default(value="127.0.0.1")
    public static final GraphDatabaseSetting.StringSetting remote_logging_host = new GraphDatabaseSetting.StringSetting("remote_logging_host", ".+", "Must be a valid hostname");
    @Description(value="Port for remote logging using LogBack SocketAppender")
    @Default(value="4560")
    public static final GraphDatabaseSetting.PortSetting remote_logging_port = new GraphDatabaseSetting.PortSetting("remote_logging_port");
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting use_adaptive_cache = new GraphDatabaseSetting.BooleanSetting("use_adaptive_cache");
    @Default(value="0.77")
    public static final GraphDatabaseSetting.FloatSetting adaptive_cache_heap_ratio = new GraphDatabaseSetting.FloatSetting("adaptive_cache_heap_ratio", "Must be a number", Float.valueOf(0.1f), Float.valueOf(0.95f));
    @Default(value="0")
    public static final GraphDatabaseSetting.IntegerSetting min_node_cache_size = new GraphDatabaseSetting.IntegerSetting("min_node_cache_size", "Must be an integer");
    @Default(value="0")
    public static final GraphDatabaseSetting.IntegerSetting min_relationship_cache_size = new GraphDatabaseSetting.IntegerSetting("min_node_cache_size", "Must be an integer");
    @Default(value="1500")
    public static final GraphDatabaseSetting.IntegerSetting max_node_cache_size = new GraphDatabaseSetting.IntegerSetting("max_node_cache_size", "Must be an integer");
    @Default(value="3500")
    public static final GraphDatabaseSetting.IntegerSetting max_relationship_cache_size = new GraphDatabaseSetting.IntegerSetting("max_node_cache_size", "Must be an integer");
    @Description(value="Enable auto-indexing for nodes")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting node_auto_indexing = new GraphDatabaseSetting.BooleanSetting("node_auto_indexing");
    @Description(value="The node property keys to be auto-indexed, if enabled")
    public static final GraphDatabaseSetting.StringSetting node_keys_indexable = new GraphDatabaseSetting.StringSetting("node_keys_indexable", ".+", "Must be a comma-separated list of keys to be indexed");
    @Description(value="Enable auto-indexing for relationships")
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting relationship_auto_indexing = new GraphDatabaseSetting.BooleanSetting("relationship_auto_indexing");
    @Description(value="The relationship keys to be auto-indexed, if enabled")
    public static final GraphDatabaseSetting.StringSetting relationship_keys_indexable = new GraphDatabaseSetting.StringSetting("relationship_keys_indexable", ".+", "Must be a comma-separated list of keys to be indexed");
    @Default(value="3000")
    public static final GraphDatabaseSetting.IntegerSetting adaptive_cache_worker_sleep_time = new GraphDatabaseSetting.IntegerSetting("adaptive_cache_worker_sleep_time", "Must be nr of milliseconds to sleep between checks");
    @Default(value="1.15")
    public static final GraphDatabaseSetting.FloatSetting adaptive_cache_manager_decrease_ratio = new GraphDatabaseSetting.FloatSetting("adaptive_cache_manager_decrease_ratio", "Must be a number", Float.valueOf(1.0f), null);
    @Default(value="1.1")
    public static final GraphDatabaseSetting.FloatSetting adaptive_cache_manager_increase_ratio = new GraphDatabaseSetting.FloatSetting("adaptive_cache_manager_increase_ratio", "Must be a number", Float.valueOf(1.0f), null);
    @Default(value="2147483647")
    public static GraphDatabaseSetting.IntegerSetting lucene_searcher_cache_size = new GraphDatabaseSetting.IntegerSetting("lucene_searcher_cache_size", "Must be a number", 1, null);
    @Default(value="2147483647")
    public static GraphDatabaseSetting.IntegerSetting lucene_writer_cache_size = new GraphDatabaseSetting.IntegerSetting("lucene_writer_cache_size", "Must be a number", 1, null);
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting intercept_committing_transactions = new GraphDatabaseSetting.BooleanSetting("intercept_committing_transactions");
    public static final GraphDatabaseSetting.StringSetting keep_logical_logs = new GraphDatabaseSetting.StringSetting("keep_logical_logs", ".+", "No value=don't store,true=store all logs,comma separated list=store logs from listed sources");
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting online_backup_enabled = new GraphDatabaseSetting.BooleanSetting("online_backup_enabled");
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting rebuild_idgenerators_fast = new GraphDatabaseSetting.BooleanSetting("rebuild_idgenerators_fast");
    public static final UseMemoryMappedBuffers use_memory_mapped_buffers = new UseMemoryMappedBuffers();
    @Default(value="20M")
    public static final GraphDatabaseSetting.StringSetting nodestore_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.nodestore.db.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="90M")
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="1M")
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_index_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.index.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="1M")
    public static final GraphDatabaseSetting.StringSetting nodestore_propertystore_index_keys_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.index.keys.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="130M")
    public static final GraphDatabaseSetting.StringSetting strings_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.strings.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="130M")
    public static final GraphDatabaseSetting.StringSetting arrays_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.propertystore.db.arrays.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="100M")
    public static final GraphDatabaseSetting.StringSetting relationshipstore_mapped_memory = new GraphDatabaseSetting.StringSetting("neostore.relationshipstore.db.mapped_memory", "\\d+[MG]", "Invalid value %s, must be e.g. 20M");
    @Default(value="100")
    public static final GraphDatabaseSetting.IntegerSetting relationship_grab_size = new GraphDatabaseSetting.IntegerSetting("relationship_grab_size", "Must be a number");
    @Default(value="true")
    public static final GraphDatabaseSetting.BooleanSetting grab_file_lock = new GraphDatabaseSetting.BooleanSetting("grab_file_lock");
    @Default(value="false")
    public static final GraphDatabaseSetting.BooleanSetting backup_slave = new GraphDatabaseSetting.BooleanSetting("backup_slave");
    @Default(value="120")
    public static final GraphDatabaseSetting.IntegerSetting string_block_size = new GraphDatabaseSetting.IntegerSetting("string_block_size", "Must be a number", 1, null);
    @Default(value="120")
    public static final GraphDatabaseSetting.IntegerSetting array_block_size = new GraphDatabaseSetting.IntegerSetting("array_block_size", "Must be a number", 1, null);
    public static final GraphDatabaseSetting.StringSetting node_cache_size = new GraphDatabaseSetting.StringSetting("node_cache_size", "\\d+[MG]", "Must be a valid size");
    public static final GraphDatabaseSetting.StringSetting relationship_cache_size = new GraphDatabaseSetting.StringSetting("relationship_cache_size", "\\d+[MG]", "Must be a valid size");
    @Default(value="1.0")
    public static final GraphDatabaseSetting.FloatSetting node_cache_array_fraction = new GraphDatabaseSetting.FloatSetting("node_cache_array_fraction", "Must be a valid fraction", Float.valueOf(1.0f), Float.valueOf(10.0f));
    @Default(value="1.0")
    public static final GraphDatabaseSetting.FloatSetting relationship_cache_array_fraction = new GraphDatabaseSetting.FloatSetting("relationship_cache_array_fraction", "Must be a valid fraction", Float.valueOf(1.0f), Float.valueOf(10.0f));
    @Default(value="60s")
    public static final GraphDatabaseSetting.StringSetting gcr_cache_min_log_interval = new GraphDatabaseSetting.StringSetting("gcr_cache_min_log_interval", "\\d+(ms|s)", "Must be a valid interval");
    @Default(value="false")
    public static GraphDatabaseSetting.BooleanSetting execution_guard_enabled = new GraphDatabaseSetting.BooleanSetting("execution_guard_enabled");
    @Default(value="100ms")
    public static GraphDatabaseSetting.StringSetting gc_monitor_wait_time = new GraphDatabaseSetting.StringSetting("gc_monitor_wait_time", "\\d+(ms|s)", "Must be a valid duration");
    @Default(value="200ms")
    public static GraphDatabaseSetting.StringSetting gc_monitor_threshold = new GraphDatabaseSetting.StringSetting("gc_monitor_threshold", "\\d+(ms|s)", "Must be a valid duration");

    public static class UseMemoryMappedBuffers
    extends GraphDatabaseSetting.BooleanSetting
    implements GraphDatabaseSetting.DefaultValue {
        public UseMemoryMappedBuffers() {
            super("use_memory_mapped_buffers");
        }

        @Override
        public String getDefaultValue() {
            if (UseMemoryMappedBuffers.osIsWindows()) {
                return "false";
            }
            return "true";
        }
    }

    public static class CypherParserSetting
    extends GraphDatabaseSetting.OptionsSetting {
        @Description(value="Cypher v1.5 syntax")
        public static final String v1_5 = "1.5";
        @Description(value="Cypher v1.6 syntax")
        public static final String v1_6 = "1.6";
        @Description(value="Cypher v1.7 syntax")
        public static final String v1_7 = "1.7";

        public CypherParserSetting() {
            super("cypher_parser_version", v1_5, v1_6, v1_7);
        }
    }

    public static class CacheTypeSetting
    extends GraphDatabaseSetting.OptionsSetting {
        public CacheTypeSetting() {
            super("cache_type", CacheTypeSetting.availableCaches());
        }

        private static String[] availableCaches() {
            ArrayList<String> list = new ArrayList<String>();
            for (CacheProvider provider : Service.load(CacheProvider.class)) {
                list.add(provider.getName());
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

