/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;

public class PropertyBlock {
    private static final int MAX_ARRAY_TOSTRING_SIZE = 4;
    private final List<DynamicRecord> valueRecords = new LinkedList<DynamicRecord>();
    private long[] valueBlocks;
    private boolean isCreated;

    public PropertyType getType() {
        return this.getType(false);
    }

    public PropertyType forceGetType() {
        return this.getType(true);
    }

    private PropertyType getType(boolean force) {
        return this.valueBlocks == null ? null : PropertyType.getPropertyType(this.valueBlocks[0], false);
    }

    public int getKeyIndexId() {
        return (int)(this.valueBlocks[0] & 0xFFFFFFL);
    }

    public void setSingleBlock(long value) {
        this.valueBlocks = new long[1];
        this.valueBlocks[0] = value;
        this.valueRecords.clear();
    }

    public void addValueRecord(DynamicRecord record) {
        this.valueRecords.add(record);
    }

    public List<DynamicRecord> getValueRecords() {
        return this.valueRecords;
    }

    public long getSingleValueBlock() {
        return this.valueBlocks[0];
    }

    public long getSingleValueLong() {
        return (this.valueBlocks[0] & 0xFFFFFFFFF0000000L) >>> 28;
    }

    public int getSingleValueInt() {
        return (int)((this.valueBlocks[0] & 0xFFFFFFFF0000000L) >>> 28);
    }

    public short getSingleValueShort() {
        return (short)((this.valueBlocks[0] & 0xFFFF0000000L) >>> 28);
    }

    public byte getSingleValueByte() {
        return (byte)((this.valueBlocks[0] & 0xFF0000000L) >>> 28);
    }

    public long[] getValueBlocks() {
        return this.valueBlocks;
    }

    public boolean isLight() {
        return this.valueRecords.size() == 0;
    }

    public PropertyData newPropertyData(PropertyRecord parent) {
        return this.newPropertyData(parent, null);
    }

    public PropertyData newPropertyData(PropertyRecord parent, Object extractedValue) {
        return this.getType().newPropertyData(this, parent.getId(), extractedValue);
    }

    public void setValueBlocks(long[] blocks) {
        assert (blocks == null || blocks.length <= PropertyType.getPayloadSizeLongs()) : "i was given an array of size " + blocks.length;
        this.valueBlocks = blocks;
        this.valueRecords.clear();
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public void setCreated() {
        this.isCreated = true;
    }

    public int getSize() {
        return this.valueBlocks == null ? 0 : this.valueBlocks.length * 8;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("PropertyBlock[");
        PropertyType type = this.getType();
        result.append(type == null ? "<unknown type>" : type.name()).append(',');
        result.append("key=").append(this.valueBlocks == null ? "?" : Integer.toString(this.getKeyIndexId()));
        if (type != null) {
            switch (type) {
                case STRING: 
                case ARRAY: {
                    result.append(",firstDynamic=").append(this.getSingleValueBlock());
                    break;
                }
                default: {
                    Object value = type.getValue(this, null);
                    if (value != null && value.getClass().isArray()) {
                        int length = Array.getLength(value);
                        StringBuilder buf = new StringBuilder(value.getClass().getComponentType().getSimpleName()).append("[");
                        for (int i = 0; i < length && i <= 4; ++i) {
                            if (i != 0) {
                                buf.append(",");
                            }
                            buf.append(Array.get(value, i));
                        }
                        if (length > 4) {
                            buf.append(",...");
                        }
                        value = buf.append("]");
                    }
                    result.append(",value=").append(value);
                }
            }
        }
        if (!this.isLight()) {
            result.append(",ValueRecords[");
            Iterator<DynamicRecord> recIt = this.valueRecords.iterator();
            while (recIt.hasNext()) {
                result.append(recIt.next());
                if (!recIt.hasNext()) continue;
                result.append(',');
            }
            result.append(']');
        }
        result.append(']');
        return result.toString();
    }
}

