/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdRange;
import org.neo4j.kernel.impl.nioneo.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.FileUtils;

public class IdGeneratorImpl
implements IdGenerator {
    private static final int HEADER_SIZE = 9;
    private static final byte CLEAN_GENERATOR = 0;
    private static final byte STICKY_GENERATOR = 1;
    public static final long INTEGER_MINUS_ONE = 0xFFFFFFFFL;
    private int grabSize = -1;
    private final AtomicLong nextFreeId = new AtomicLong(-1L);
    private long totalBytesRead = 0L;
    private boolean haveMore = true;
    private long readBlocksTo = 9L;
    private long defraggedIdCount = -1L;
    private final String fileName;
    private final FileSystemAbstraction fs;
    private FileChannel fileChannel = null;
    private final LinkedList<Long> defragedIdList = new LinkedList();
    private final LinkedList<Long> releasedIdList = new LinkedList();
    private final long max;
    private final boolean aggressiveReuse;

    public IdGeneratorImpl(FileSystemAbstraction fs, String fileName, int grabSize, long max, boolean aggressiveReuse) {
        this.fs = fs;
        this.aggressiveReuse = aggressiveReuse;
        if (grabSize < 1) {
            throw new IllegalArgumentException("Illegal grabSize: " + grabSize);
        }
        this.max = max;
        this.fileName = fileName;
        this.grabSize = grabSize;
        this.initGenerator();
    }

    @Override
    public synchronized long nextId() {
        this.assertStillOpen();
        long nextDefragId = this.nextIdFromDefragList();
        if (nextDefragId != -1L) {
            return nextDefragId;
        }
        long id = this.nextFreeId.get();
        if (id == 0xFFFFFFFFL) {
            id = this.nextFreeId.incrementAndGet();
        }
        this.assertIdWithinCapacity(id);
        this.nextFreeId.incrementAndGet();
        return id;
    }

    private void assertIdWithinCapacity(long id) {
        if (id > this.max || id < 0L) {
            throw new UnderlyingStorageException("Id capacity exceeded");
        }
    }

    private long nextIdFromDefragList() {
        Long id;
        if (this.aggressiveReuse && (id = this.releasedIdList.poll()) != null) {
            --this.defraggedIdCount;
            return id;
        }
        if (this.defragedIdList.size() > 0) {
            long id2 = this.defragedIdList.removeFirst();
            if (this.haveMore && this.defragedIdList.size() == 0) {
                this.readIdBatch();
            }
            --this.defraggedIdCount;
            return id2;
        }
        return -1L;
    }

    private void assertStillOpen() {
        if (this.fileChannel == null) {
            throw new IllegalStateException("Closed id generator " + this.fileName);
        }
    }

    @Override
    public synchronized IdRange nextIdBatch(int size) {
        long id;
        this.assertStillOpen();
        int count = 0;
        long[] defragIds = new long[size];
        while (count < size && (id = this.nextIdFromDefragList()) != -1L) {
            defragIds[count++] = id;
        }
        long[] tmpArray = defragIds;
        defragIds = new long[count];
        System.arraycopy(tmpArray, 0, defragIds, 0, count);
        int sizeLeftForRange = size - count;
        long start = this.nextFreeId.get();
        long newHighId = start + (long)sizeLeftForRange;
        this.assertIdWithinCapacity(newHighId);
        this.nextFreeId.set(newHighId);
        return new IdRange(defragIds, start, sizeLeftForRange);
    }

    @Override
    public void setHighId(long id) {
        this.assertIdWithinCapacity(id);
        this.nextFreeId.set(id);
    }

    @Override
    public long getHighId() {
        return this.nextFreeId.get();
    }

    @Override
    public synchronized void freeId(long id) {
        if (id == 0xFFFFFFFFL) {
            return;
        }
        if (this.fileChannel == null) {
            throw new IllegalStateException("Generator closed " + this.fileName);
        }
        if (id < 0L || id >= this.nextFreeId.get()) {
            throw new IllegalArgumentException("Illegal id[" + id + "]");
        }
        this.releasedIdList.add(id);
        ++this.defraggedIdCount;
        if (this.releasedIdList.size() >= this.grabSize) {
            this.writeIdBatch(ByteBuffer.allocate(this.grabSize * 8));
        }
    }

    @Override
    public synchronized void close(boolean shutdown) {
        if (this.nextFreeId.get() == -1L) {
            return;
        }
        ByteBuffer writeBuffer = ByteBuffer.allocate(this.grabSize * 8);
        if (this.releasedIdList.size() > 0) {
            this.writeIdBatch(writeBuffer);
        }
        if (this.defragedIdList.size() > 0) {
            while (this.defragedIdList.size() > 0) {
                this.releasedIdList.add(this.defragedIdList.removeFirst());
            }
            this.writeIdBatch(writeBuffer);
        }
        try {
            this.fileChannel.position(0L);
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.put((byte)1).putLong(this.nextFreeId.get());
            buffer.flip();
            this.fileChannel.write(buffer);
            if (this.totalBytesRead > 9L) {
                long writePosition = 9L;
                long readPosition = this.readBlocksTo;
                if (this.totalBytesRead < this.readBlocksTo) {
                    readPosition = this.totalBytesRead;
                }
                int bytesRead = -1;
                do {
                    writeBuffer.clear();
                    this.fileChannel.position(readPosition);
                    bytesRead = this.fileChannel.read(writeBuffer);
                    readPosition += (long)bytesRead;
                    writeBuffer.flip();
                    this.fileChannel.position(writePosition);
                    writePosition += (long)this.fileChannel.write(writeBuffer);
                } while (bytesRead > 0);
                this.fileChannel.truncate(writePosition);
            }
            this.fileChannel.force(false);
            buffer.clear();
            buffer.put((byte)0);
            buffer.limit(1);
            buffer.flip();
            this.fileChannel.position(0L);
            this.fileChannel.write(buffer);
            this.fileChannel.force(false);
            this.fileChannel.close();
            this.fileChannel = null;
            this.nextFreeId.set(-1L);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to close id generator " + this.fileName, e);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public static void createGenerator(FileSystemAbstraction fs, String fileName) {
        if (fs == null) {
            throw new IllegalArgumentException("Null filesystem");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (fs.fileExists(fileName)) {
            throw new IllegalStateException("Can't create IdGeneratorFile[" + fileName + "], file already exists");
        }
        try {
            FileChannel channel = fs.create(fileName);
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.put((byte)0).putLong(0L).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create id generator" + fileName, e);
        }
    }

    private synchronized void initGenerator() {
        try {
            this.fileChannel = this.fs.open(this.fileName, "rw");
            ByteBuffer buffer = ByteBuffer.allocate(9);
            this.totalBytesRead = this.fileChannel.read(buffer);
            if (this.totalBytesRead != 9L) {
                this.fileChannel.close();
                throw new InvalidIdGeneratorException("Unable to read header, bytes read: " + this.totalBytesRead);
            }
            buffer.flip();
            byte storageStatus = buffer.get();
            if (storageStatus != 0) {
                this.fileChannel.close();
                throw new InvalidIdGeneratorException("Sticky generator[ " + this.fileName + "] delete this id generator and build a new one");
            }
            this.nextFreeId.set(buffer.getLong());
            buffer.flip();
            buffer.put((byte)1).limit(1).flip();
            this.fileChannel.position(0L);
            this.fileChannel.write(buffer);
            this.fileChannel.position(9L);
            this.readBlocksTo = this.fileChannel.size();
            this.defraggedIdCount = (int)(this.readBlocksTo - 9L) / 8;
            this.readIdBatch();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to init id generator " + this.fileName, e);
        }
    }

    private void readIdBatch() {
        if (!this.haveMore) {
            return;
        }
        if (this.totalBytesRead >= this.readBlocksTo) {
            this.haveMore = false;
            return;
        }
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate(this.grabSize * 8);
            if (this.totalBytesRead + (long)readBuffer.capacity() > this.readBlocksTo) {
                readBuffer.clear();
                readBuffer.limit((int)(this.readBlocksTo - this.fileChannel.position()));
            } else {
                readBuffer.clear();
            }
            this.fileChannel.position(this.totalBytesRead);
            int bytesRead = this.fileChannel.read(readBuffer);
            assert (this.fileChannel.position() <= this.readBlocksTo);
            this.totalBytesRead += (long)bytesRead;
            readBuffer.flip();
            assert (bytesRead % 8 == 0);
            int idsRead = bytesRead / 8;
            this.defraggedIdCount -= (long)idsRead;
            for (int i = 0; i < idsRead; ++i) {
                long id = readBuffer.getLong();
                if (id == 0xFFFFFFFFL) continue;
                this.defragedIdList.add(id);
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed reading defragged id batch", e);
        }
    }

    private void writeIdBatch(ByteBuffer writeBuffer) {
        try {
            this.fileChannel.position(this.fileChannel.size());
            writeBuffer.clear();
            while (this.releasedIdList.size() > 0) {
                long id = this.releasedIdList.removeFirst();
                if (id == 0xFFFFFFFFL) continue;
                writeBuffer.putLong(id);
                if (writeBuffer.position() != writeBuffer.capacity()) continue;
                writeBuffer.flip();
                this.fileChannel.write(writeBuffer);
                writeBuffer.clear();
            }
            writeBuffer.flip();
            this.fileChannel.write(writeBuffer);
            this.fileChannel.position(this.totalBytesRead);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to write defragged id  batch", e);
        }
    }

    public synchronized void dumpFreeIds() {
        while (this.haveMore) {
            this.readIdBatch();
        }
        Iterator itr = this.defragedIdList.iterator();
        while (itr.hasNext()) {
            System.out.print(" " + itr.next());
        }
        System.out.println("\nNext free id: " + this.nextFreeId);
        this.close(true);
    }

    @Override
    public synchronized long getNumberOfIdsInUse() {
        return this.nextFreeId.get() - this.defraggedIdCount;
    }

    @Override
    public long getDefragCount() {
        return this.defraggedIdCount;
    }

    public void clearFreeIds() {
        this.releasedIdList.clear();
        this.defragedIdList.clear();
        this.defraggedIdCount = -1L;
        try {
            FileUtils.truncateFile(this.fileChannel, 9L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        if (this.nextFreeId.get() != -1L) {
            throw new RuntimeException("Must be closed to delete");
        }
        if (!this.fs.deleteFile(this.fileName)) {
            throw new UnderlyingStorageException("Unable to delete id generator " + this.fileName);
        }
    }
}

