/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractNameRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractRecord;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicStringStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.NameData;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractNameStore<T extends AbstractNameRecord>
extends AbstractStore
implements Store,
RecordStore<T> {
    private DynamicStringStore nameStore;
    public static final int NAME_STORE_BLOCK_SIZE = 30;

    public AbstractNameStore(String fileName, Configuration configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, DynamicStringStore nameStore) {
        super(fileName, configuration, idType, idGeneratorFactory, fileSystemAbstraction, stringLogger);
        this.nameStore = nameStore;
    }

    DynamicStringStore getNameStore() {
        return this.nameStore;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    @Override
    protected void setRecovered() {
        super.setRecovered();
        this.nameStore.setRecovered();
    }

    @Override
    protected void unsetRecovered() {
        super.unsetRecovered();
        this.nameStore.unsetRecovered();
    }

    @Override
    public void makeStoreOk() {
        this.nameStore.makeStoreOk();
        super.makeStoreOk();
    }

    @Override
    public void rebuildIdGenerators() {
        this.nameStore.rebuildIdGenerators();
        super.rebuildIdGenerators();
    }

    public void updateIdGenerators() {
        this.nameStore.updateHighId();
        this.updateHighId();
    }

    public void freeBlockId(int id) {
        this.nameStore.freeBlockId(id);
    }

    @Override
    protected void closeStorage() {
        if (this.nameStore != null) {
            this.nameStore.close();
            this.nameStore = null;
        }
    }

    @Override
    public void flushAll() {
        this.nameStore.flushAll();
        super.flushAll();
    }

    public NameData[] getNames(int maxCount) {
        LinkedList<NameData> recordList = new LinkedList<NameData>();
        long maxIdInUse = this.getHighestPossibleIdInUse();
        int found = 0;
        int i = 0;
        while ((long)i <= maxIdInUse && found < maxCount) {
            block4: {
                T record;
                try {
                    record = this.getRecord(i);
                }
                catch (InvalidRecordException t) {
                    break block4;
                }
                ++found;
                if (record != null && ((AbstractNameRecord)record).getNameId() != Record.RESERVED.intValue()) {
                    String name = this.getStringFor(record);
                    recordList.add(new NameData(i, name));
                }
            }
            ++i;
        }
        return recordList.toArray(new NameData[recordList.size()]);
    }

    public NameData getName(int id) {
        T record = this.getRecord(id);
        return new NameData(((AbstractRecord)record).getId(), this.getStringFor(record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameData getName(int id, boolean recovered) {
        assert (recovered);
        try {
            this.setRecovered();
            T record = this.getRecord(id);
            NameData nameData = new NameData(((AbstractRecord)record).getId(), this.getStringFor(record));
            return nameData;
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getRecord(int id) {
        T record;
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            record = this.getRecord(id, window, false);
        }
        finally {
            this.releaseWindow(window);
        }
        Collection<DynamicRecord> keyRecords = this.nameStore.getLightRecords(((AbstractNameRecord)record).getNameId());
        for (DynamicRecord keyRecord : keyRecords) {
            ((AbstractNameRecord)record).addNameRecord(keyRecord);
        }
        return record;
    }

    @Override
    public T getRecord(long id) {
        return this.getRecord((int)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T forceGetRecord(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return this.newRecord((int)id);
        }
        try {
            T t = this.getRecord((int)id, window, true);
            return t;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public T forceGetRaw(long id) {
        return (T)this.forceGetRecord(id);
    }

    public Collection<DynamicRecord> allocateNameRecords(int nameId, byte[] chars) {
        return this.nameStore.allocateRecords(nameId, chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLightRecord(int id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            T record = this.getRecord(id, window, false);
            ((AbstractNameRecord)record).setIsLight(true);
            T t = record;
            return t;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(T record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(((AbstractRecord)record).getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(T record) {
        PersistenceWindow window = this.acquireWindow(((AbstractRecord)record).getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
        if (!((AbstractNameRecord)record).isLight()) {
            for (DynamicRecord keyRecord : ((AbstractNameRecord)record).getNameRecords()) {
                this.nameStore.updateRecord(keyRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateRecord(T record) {
        PersistenceWindow window = this.acquireWindow(((AbstractRecord)record).getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    public int nextNameId() {
        return (int)this.nameStore.nextBlockId();
    }

    protected abstract T newRecord(int var1);

    protected T getRecord(int id, PersistenceWindow window, boolean force) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        byte inUseByte = buffer.get();
        boolean bl = inUse = inUseByte == Record.IN_USE.byteValue();
        if (!inUse && !force) {
            throw new InvalidRecordException(this.getClass().getSimpleName() + " Record[" + id + "] not in use");
        }
        if (inUseByte != Record.IN_USE.byteValue() && inUseByte != Record.NOT_IN_USE.byteValue()) {
            throw new InvalidRecordException(this.getClass().getSimpleName() + " Record[" + id + "] unknown in use flag[" + inUse + "]");
        }
        T record = this.newRecord(id);
        ((AbstractBaseRecord)record).setInUse(inUse);
        this.readRecord(record, buffer);
        return record;
    }

    protected void readRecord(T record, Buffer buffer) {
        ((AbstractNameRecord)record).setNameId(buffer.getInt());
    }

    protected void updateRecord(T record, PersistenceWindow window) {
        int id = ((AbstractRecord)record).getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (((AbstractBaseRecord)record).inUse()) {
            buffer.put(Record.IN_USE.byteValue());
            this.writeRecord(record, buffer);
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    protected void writeRecord(T record, Buffer buffer) {
        buffer.putInt(((AbstractNameRecord)record).getNameId());
    }

    public void makeHeavy(T record) {
        ((AbstractNameRecord)record).setIsLight(false);
        Collection<DynamicRecord> keyRecords = this.nameStore.getRecords(((AbstractNameRecord)record).getNameId());
        for (DynamicRecord keyRecord : keyRecords) {
            ((AbstractNameRecord)record).addNameRecord(keyRecord);
        }
    }

    public String getStringFor(T nameRecord) {
        int recordToFind = ((AbstractNameRecord)nameRecord).getNameId();
        Iterator<DynamicRecord> records = ((AbstractNameRecord)nameRecord).getNameRecords().iterator();
        ArrayList<DynamicRecord> relevantRecords = new ArrayList<DynamicRecord>();
        while (recordToFind != Record.NO_NEXT_BLOCK.intValue() && records.hasNext()) {
            DynamicRecord record = records.next();
            if (!record.inUse() || record.getId() != (long)recordToFind) continue;
            recordToFind = (int)record.getNextBlock();
            relevantRecords.add(record);
            records = ((AbstractNameRecord)nameRecord).getNameRecords().iterator();
        }
        return (String)PropertyStore.getStringFor(PropertyStore.readFullByteArray(((AbstractNameRecord)nameRecord).getNameId(), relevantRecords, this.nameStore));
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.nameStore.getWindowPoolStats());
        list.add(this.getWindowPoolStats());
        return list;
    }

    public static interface Configuration
    extends AbstractStore.Configuration {
    }
}

