/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.LinkedList;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractDynamicStore
extends CommonAbstractStore
implements Store,
RecordStore<DynamicRecord> {
    private Configuration conf;
    private int blockSize;
    public static final int BLOCK_HEADER_SIZE = 8;

    public AbstractDynamicStore(String fileName, Configuration conf, IdType idType, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, conf, idType, idGeneratorFactory, fileSystemAbstraction, stringLogger);
        this.conf = conf;
    }

    @Override
    protected int getEffectiveRecordSize() {
        return this.getBlockSize();
    }

    @Override
    public int getRecordSize() {
        return this.getBlockSize();
    }

    @Override
    public int getRecordHeaderSize() {
        return 8;
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        int expectedVersionLength = UTF8.encode(AbstractDynamicStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor())).length;
        long fileSize = this.getFileChannel().size();
        if ((fileSize - (long)expectedVersionLength) % (long)this.blockSize != 0L && !this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Misaligned file size " + fileSize + " for " + this + ", expected version length " + expectedVersionLength));
        }
        if (this.getStoreOk() && !this.isReadOnly()) {
            this.getFileChannel().truncate(fileSize - (long)expectedVersionLength);
        }
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        this.getFileChannel().position(0L);
        this.getFileChannel().read(buffer);
        buffer.flip();
        this.blockSize = buffer.getInt();
        if (this.blockSize <= 0) {
            throw new InvalidRecordException("Illegal block size: " + this.blockSize + " in " + this.getStorageFileName());
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long nextBlockId() {
        return this.nextId();
    }

    public void freeBlockId(long blockId) {
        this.freeId(blockId);
    }

    public static int getRecordSize(int dataSize) {
        return dataSize + 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DynamicRecord record) {
        long blockId = record.getId();
        if (this.isInRecoveryMode()) {
            this.registerIdFromUpdateRecord(blockId);
        }
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(blockId);
            if (record.inUse()) {
                long nextProp = record.getNextBlock();
                int nextModifier = nextProp == (long)Record.NO_NEXT_BLOCK.intValue() ? 0 : (int)((nextProp & 0xF00000000L) >> 8);
                nextModifier |= Record.IN_USE.byteValue() << 28;
                int mostlyNrOfBytesInt = record.getLength();
                assert (mostlyNrOfBytesInt < 0xFFFFFF);
                buffer.putInt(mostlyNrOfBytesInt |= nextModifier).putInt((int)nextProp);
                if (!record.isLight()) {
                    buffer.put(record.getData());
                } else assert (this.getHighId() != record.getId() + 1L);
            } else {
                buffer.put(Record.NOT_IN_USE.byteValue());
                if (!this.isInRecoveryMode()) {
                    this.freeBlockId(blockId);
                }
            }
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public void forceUpdateRecord(DynamicRecord record) {
        this.updateRecord(record);
    }

    protected Collection<DynamicRecord> allocateRecords(long startBlock, byte[] src) {
        assert (this.getFileChannel() != null) : "Store closed, null file channel";
        assert (src != null) : "Null src argument";
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        long nextBlock = startBlock;
        int srcOffset = 0;
        int dataSize = this.getBlockSize() - 8;
        do {
            byte[] data;
            DynamicRecord record = new DynamicRecord(nextBlock);
            record.setCreated();
            record.setInUse(true);
            if (src.length - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                nextBlock = this.nextBlockId();
                record.setNextBlock(nextBlock);
                srcOffset += dataSize;
            } else {
                data = new byte[src.length - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextBlock = Record.NO_NEXT_BLOCK.intValue();
                record.setNextBlock(nextBlock);
            }
            recordList.add(record);
            assert (!record.isLight());
            assert (record.getData() != null);
        } while (nextBlock != (long)Record.NO_NEXT_BLOCK.intValue());
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DynamicRecord> getLightRecords(long startBlockId) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        long blockId = startBlockId;
        while (blockId != (long)Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
            try {
                DynamicRecord record = this.getRecord(blockId, window, RecordLoad.CHECK);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.releaseWindow(window);
            }
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeHeavy(DynamicRecord record) {
        long blockId = record.getId();
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
        try {
            Buffer buf = window.getBuffer();
            int offset = (int)(blockId - buf.position()) * this.getBlockSize() + 8;
            buf.setOffset(offset);
            byte[] bytes = new byte[record.getLength()];
            buf.get(bytes);
            record.setData(bytes);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    protected boolean isRecordInUse(ByteBuffer buffer) {
        return (buffer.get() & 0xFFFFFFF0) >> 4 == Record.IN_USE.byteValue();
    }

    private DynamicRecord getRecord(long blockId, PersistenceWindow window, RecordLoad load) {
        boolean readData;
        boolean inUse;
        DynamicRecord record = new DynamicRecord(blockId);
        Buffer buffer = window.getOffsettedBuffer(blockId);
        long firstInteger = buffer.getUnsignedInt();
        int inUseByte = (int)((firstInteger & 0xFFFFFFFFF0000000L) >> 28);
        boolean bl = inUse = inUseByte == Record.IN_USE.intValue();
        if (!inUse && load != RecordLoad.FORCE) {
            throw new InvalidRecordException("DynamicRecord Not in use, blockId[" + blockId + "]");
        }
        int dataSize = this.getBlockSize() - 8;
        int nrOfBytes = (int)(firstInteger & 0xFFFFFFL);
        long nextBlock = buffer.getUnsignedInt();
        long nextModifier = (firstInteger & 0xF000000L) << 8;
        long longNextBlock = this.longFromIntAndMod(nextBlock, nextModifier);
        boolean bl2 = readData = load != RecordLoad.CHECK;
        if (longNextBlock != (long)Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
            readData = false;
            if (load != RecordLoad.FORCE) {
                throw new InvalidRecordException("Next block set[" + nextBlock + "] current block illegal size[" + nrOfBytes + "/" + dataSize + "]");
            }
        }
        record.setInUse(inUse);
        record.setLength(nrOfBytes);
        record.setNextBlock(longNextBlock);
        if (readData) {
            byte[] byteArrayElement = new byte[nrOfBytes];
            buffer.get(byteArrayElement);
            record.setData(byteArrayElement);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            DynamicRecord dynamicRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return dynamicRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicRecord forceGetRecord(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new DynamicRecord(id);
        }
        try {
            DynamicRecord dynamicRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return dynamicRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public DynamicRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DynamicRecord> getRecords(long startBlockId) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        long blockId = startBlockId;
        while (blockId != (long)Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
            try {
                DynamicRecord record = this.getRecord(blockId, window, RecordLoad.NORMAL);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.releaseWindow(window);
            }
        }
        return recordList;
    }

    private long findHighIdBackwards() throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        int recordSize = this.getBlockSize();
        long fileSize = fileChannel.size();
        long highId = fileSize / (long)recordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        for (long i = highId; i > 0L; --i) {
            fileChannel.position(i * (long)recordSize);
            if (fileChannel.read(byteBuffer) <= 0) continue;
            byteBuffer.flip();
            boolean isInUse = this.isRecordInUse(byteBuffer);
            byteBuffer.clear();
            if (!isInUse) continue;
            return i;
        }
        return 0L;
    }

    @Override
    protected void rebuildIdGenerator() {
        if (this.getBlockSize() <= 0) {
            throw new InvalidRecordException("Illegal blockSize: " + this.getBlockSize());
        }
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        if (this.fileSystemAbstraction.fileExists(this.getStorageFileName() + ".id")) {
            boolean success = this.fileSystemAbstraction.deleteFile(this.getStorageFileName() + ".id");
            assert (success);
        }
        this.createIdGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator(false);
        this.setHighId(1L);
        FileChannel fileChannel = this.getFileChannel();
        long highId = 0L;
        long defraggedCount = 0L;
        try {
            long fileSize = fileChannel.size();
            boolean fullRebuild = true;
            if (this.conf.rebuild_idgenerators_fast(true)) {
                fullRebuild = false;
                highId = this.findHighIdBackwards();
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
            LinkedList<Long> freeIdList = new LinkedList<Long>();
            if (fullRebuild) {
                long i = 1L;
                while (i * (long)this.getBlockSize() < fileSize) {
                    fileChannel.position(i * (long)this.getBlockSize());
                    byteBuffer.clear();
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    if (!this.isRecordInUse(byteBuffer)) {
                        freeIdList.add(i);
                    } else {
                        highId = i;
                        this.setHighId(highId + 1L);
                        while (!freeIdList.isEmpty()) {
                            this.freeBlockId((Long)freeIdList.removeFirst());
                            ++defraggedCount;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1L);
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        if (this.stringLogger != null) {
            this.stringLogger.logMessage(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount, true);
        }
        this.closeIdGenerator();
        this.openIdGenerator(false);
    }

    @Override
    protected long figureOutHighestIdInUse() {
        try {
            return this.getFileChannel().size() / (long)this.getBlockSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[blockSize:" + (this.getRecordSize() - this.getRecordHeaderSize()) + "]";
    }

    static interface Configuration
    extends CommonAbstractStore.Configuration {
        public boolean rebuild_idgenerators_fast(boolean var1);
    }
}

