/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.impl.cache.EntityWithSize;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.PropertyEventData;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.util.ArrayMap;

abstract class Primitive
implements EntityWithSize {
    protected static final PropertyData[] NO_PROPERTIES = new PropertyData[0];

    protected abstract PropertyData changeProperty(NodeManager var1, PropertyData var2, Object var3);

    protected abstract PropertyData addProperty(NodeManager var1, PropertyIndex var2, Object var3);

    protected abstract void removeProperty(NodeManager var1, PropertyData var2);

    protected abstract ArrayMap<Integer, PropertyData> loadProperties(NodeManager var1, boolean var2);

    Primitive(boolean newPrimitive) {
        if (newPrimitive) {
            this.setEmptyProperties();
        }
    }

    @Override
    public abstract long getId();

    protected abstract void setEmptyProperties();

    protected abstract PropertyData[] allProperties();

    protected abstract PropertyData getPropertyForIndex(int var1);

    protected abstract void setProperties(ArrayMap<Integer, PropertyData> var1, NodeManager var2);

    protected abstract void commitPropertyMaps(ArrayMap<Integer, PropertyData> var1, ArrayMap<Integer, PropertyData> var2, long var3, NodeManager var5);

    public int hashCode() {
        long id = this.getId();
        return (int)(id >>> 32 ^ id);
    }

    public Iterable<Object> getPropertyValues(NodeManager nodeManager) {
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        ArrayList<Object> values = new ArrayList<Object>();
        for (PropertyData property : this.allProperties()) {
            Integer index = property.getIndex();
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            values.add(property.getValue());
        }
        if (addMap != null) {
            for (PropertyData property : addMap.values()) {
                values.add(property.getValue());
            }
        }
        return values;
    }

    public Iterable<String> getPropertyKeys(NodeManager nodeManager) {
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        ArrayList<String> keys = new ArrayList<String>();
        for (PropertyData property : this.allProperties()) {
            Integer index = property.getIndex();
            if (skipMap != null && skipMap.get(index) != null || addMap != null && addMap.get(index) != null) continue;
            keys.add(nodeManager.getIndexFor(index).getKey());
        }
        if (addMap != null) {
            for (Integer index : addMap.keySet()) {
                keys.add(nodeManager.getIndexFor(index).getKey());
            }
        }
        return keys;
    }

    public Object getProperty(NodeManager nodeManager, String key) throws NotFoundException {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        throw this.newPropertyNotFoundException(key);
    }

    private NotFoundException newPropertyNotFoundException(String key) {
        return new NotFoundException("'" + key + "' property not found for " + this + ".");
    }

    private PropertyData getSlowProperty(NodeManager nodeManager, ArrayMap<Integer, PropertyData> addMap, ArrayMap<Integer, PropertyData> skipMap, String key) {
        if (nodeManager.hasAllPropertyIndexes()) {
            return null;
        }
        if (addMap != null) {
            for (int keyId : addMap.keySet()) {
                PropertyIndex indexToCheck;
                if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                if (skipMap != null && skipMap.get(keyId) != null) {
                    throw this.newPropertyNotFoundException(key);
                }
                PropertyData property = addMap.get(indexToCheck.getKeyId());
                if (property == null) continue;
                return property;
            }
        }
        for (PropertyData property : this.allProperties()) {
            PropertyIndex indexToCheck;
            int keyId = property.getIndex();
            if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
            if (skipMap != null && skipMap.get(keyId) != null) {
                throw this.newPropertyNotFoundException(key);
            }
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public Object getProperty(NodeManager nodeManager, String key, Object defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return defaultValue;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return this.getPropertyValue(nodeManager, property);
            }
            property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        if (property != null) {
            return this.getPropertyValue(nodeManager, property);
        }
        return defaultValue;
    }

    public boolean hasProperty(NodeManager nodeManager, String key) {
        if (key == null) {
            return false;
        }
        ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
        ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
        this.ensureFullProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property;
            if (skipMap != null && skipMap.get(index.getKeyId()) != null) {
                return false;
            }
            if (addMap != null && (property = addMap.get(index.getKeyId())) != null) {
                return true;
            }
            property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return true;
        }
        PropertyData property = this.getSlowProperty(nodeManager, addMap, skipMap, key);
        return property != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(NodeManager nodeManager, PropertyContainer proxy, String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Null parameter, key=" + key + ", " + "value=" + value);
        }
        nodeManager.acquireLock(proxy, LockType.WRITE);
        boolean success = false;
        try {
            this.ensureFullProperties(nodeManager);
            ArrayMap<Integer, PropertyData> addMap = nodeManager.getOrCreateCowPropertyAddMap(this);
            ArrayMap<Integer, PropertyData> skipMap = nodeManager.getCowPropertyRemoveMap(this);
            PropertyIndex index = null;
            PropertyData property = null;
            boolean foundInSkipMap = false;
            for (PropertyIndex cachedIndex : nodeManager.index(key)) {
                if (skipMap != null && skipMap.remove(cachedIndex.getKeyId()) != null) {
                    foundInSkipMap = true;
                }
                index = cachedIndex;
                property = addMap.get(cachedIndex.getKeyId());
                if (property == null && (property = this.getPropertyForIndex(cachedIndex.getKeyId())) == null) continue;
                break;
            }
            if (property == null && !nodeManager.hasAllPropertyIndexes()) {
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    PropertyIndex indexToCheck;
                    int keyId = (Integer)i$.next();
                    if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                    if (skipMap != null) {
                        skipMap.remove(indexToCheck.getKeyId());
                    }
                    index = indexToCheck;
                    property = addMap.get(indexToCheck.getKeyId());
                    if (property == null) continue;
                    break;
                }
                if (property == null) {
                    for (PropertyData aProperty : this.allProperties()) {
                        PropertyIndex indexToCheck;
                        int keyId = aProperty.getIndex();
                        if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key)) continue;
                        if (skipMap != null) {
                            skipMap.remove(indexToCheck.getKeyId());
                        }
                        index = indexToCheck;
                        property = this.getPropertyForIndex(indexToCheck.getKeyId());
                        if (property != null) break;
                    }
                }
            }
            if (index == null) {
                index = nodeManager.createPropertyIndex(key);
            }
            property = property != null && !foundInSkipMap ? this.changeProperty(nodeManager, property, value) : this.addProperty(nodeManager, index, value);
            if (addMap == null) {
                System.out.println("addMap null");
            }
            if (index == null) {
                System.out.println("index null");
            }
            addMap.put(index.getKeyId(), property);
            success = true;
        }
        finally {
            nodeManager.releaseLock(proxy, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeProperty(NodeManager nodeManager, PropertyContainer proxy, String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null parameter.");
        }
        nodeManager.acquireLock(proxy, LockType.WRITE);
        boolean success = false;
        try {
            Object object;
            this.ensureFullProperties(nodeManager);
            PropertyData property = null;
            ArrayMap<Integer, PropertyData> addMap = nodeManager.getCowPropertyAddMap(this);
            ArrayMap<Integer, PropertyData> removeMap = nodeManager.getCowPropertyRemoveMap(this);
            for (PropertyIndex cachedIndex : nodeManager.index(key)) {
                if (addMap != null && (property = addMap.remove(cachedIndex.getKeyId())) != null) {
                    removeMap = removeMap != null ? removeMap : nodeManager.getOrCreateCowPropertyRemoveMap(this);
                    removeMap.put(cachedIndex.getKeyId(), property);
                    break;
                }
                if (removeMap != null && removeMap.get(cachedIndex.getKeyId()) != null) {
                    success = true;
                    Object var10_12 = null;
                    return var10_12;
                }
                property = this.getPropertyForIndex(cachedIndex.getKeyId());
                if (property == null) continue;
                removeMap = removeMap != null ? removeMap : nodeManager.getOrCreateCowPropertyRemoveMap(this);
                removeMap.put(cachedIndex.getKeyId(), property);
                break;
            }
            if (property == null && !nodeManager.hasAllPropertyIndexes() && addMap != null) {
                Iterator<Object> i$ = addMap.keySet().iterator();
                while (i$.hasNext()) {
                    PropertyIndex indexToCheck;
                    int keyId = (Integer)i$.next();
                    if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = addMap.remove(indexToCheck.getKeyId())) == null) continue;
                    removeMap = removeMap != null ? removeMap : nodeManager.getOrCreateCowPropertyRemoveMap(this);
                    removeMap.put(indexToCheck.getKeyId(), property);
                    break;
                }
                if (property == null) {
                    for (PropertyData aProperty : this.allProperties()) {
                        PropertyIndex indexToCheck;
                        int keyId = aProperty.getIndex();
                        if (nodeManager.hasIndexFor(keyId) || !(indexToCheck = nodeManager.getIndexFor(keyId)).getKey().equals(key) || (property = this.getPropertyForIndex(indexToCheck.getKeyId())) == null) continue;
                        removeMap = removeMap != null ? removeMap : nodeManager.getOrCreateCowPropertyRemoveMap(this);
                        removeMap.put(indexToCheck.getKeyId(), property);
                        break;
                    }
                }
            }
            if (property == null) {
                success = true;
                object = null;
                return object;
            }
            this.removeProperty(nodeManager, property);
            success = true;
            object = this.getPropertyValue(nodeManager, property);
            return object;
        }
        finally {
            nodeManager.releaseLock(proxy, LockType.WRITE);
            if (!success) {
                nodeManager.setRollbackOnly();
            }
        }
    }

    private Object getPropertyValue(NodeManager nodeManager, PropertyData property) {
        Object value = property.getValue();
        if (value == null) {
            value = nodeManager.loadPropertyValue(property);
            property.setNewValue(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFullProperties(NodeManager nodeManager) {
        if (this.allProperties() == null) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (this.allProperties() == null) {
                    this.setProperties(this.loadProperties(nodeManager, false), nodeManager);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFullLightProperties(NodeManager nodeManager) {
        if (this.allProperties() == null) {
            Primitive primitive = this;
            synchronized (primitive) {
                if (this.allProperties() == null) {
                    this.setProperties(this.loadProperties(nodeManager, true), nodeManager);
                }
            }
        }
    }

    protected List<PropertyEventData> getAllCommittedProperties(NodeManager nodeManager) {
        this.ensureFullLightProperties(nodeManager);
        if (this.allProperties() == null) {
            return new ArrayList<PropertyEventData>();
        }
        PropertyData[] properties = this.allProperties();
        ArrayList<PropertyEventData> props = new ArrayList<PropertyEventData>(properties.length);
        for (PropertyData property : properties) {
            PropertyIndex index = nodeManager.getIndexFor(property.getIndex());
            Object value = this.getPropertyValue(nodeManager, property);
            props.add(new PropertyEventData(index.getKey(), value));
        }
        return props;
    }

    protected Object getCommittedPropertyValue(NodeManager nodeManager, String key) {
        this.ensureFullLightProperties(nodeManager);
        for (PropertyIndex index : nodeManager.index(key)) {
            PropertyData property = this.getPropertyForIndex(index.getKeyId());
            if (property == null) continue;
            return this.getPropertyValue(nodeManager, property);
        }
        return null;
    }

    public abstract LockReleaser.CowEntityElement getEntityElement(LockReleaser.PrimitiveElement var1, boolean var2);

    abstract PropertyContainer asProxy(NodeManager var1);

    protected abstract void updateSize(int var1, int var2, NodeManager var3);
}

