/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.kernel.Lifecycle;

public class KernelEventHandlers
implements Lifecycle {
    protected final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void start() throws Throwable {
    }

    @Override
    public void stop() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
        for (KernelEventHandler kernelEventHandler : this.kernelEventHandlers) {
            kernelEventHandler.beforeShutdown();
        }
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        if (this.kernelEventHandlers.contains(handler)) {
            return handler;
        }
        for (KernelEventHandler registeredHandler : this.kernelEventHandlers) {
            KernelEventHandler.ExecutionOrder order = handler.orderComparedTo(registeredHandler);
            int index = this.kernelEventHandlers.indexOf(registeredHandler);
            if (order == KernelEventHandler.ExecutionOrder.BEFORE) {
                this.kernelEventHandlers.add(index, handler);
                return handler;
            }
            if (order != KernelEventHandler.ExecutionOrder.AFTER) continue;
            this.kernelEventHandlers.add(index + 1, handler);
            return handler;
        }
        this.kernelEventHandlers.add(handler);
        return handler;
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        if (!this.kernelEventHandlers.remove(handler)) {
            throw new IllegalStateException(handler + " isn't registered");
        }
        return handler;
    }

    public void kernelPanic(ErrorState error) {
        for (KernelEventHandler handler : this.kernelEventHandlers) {
            handler.kernelPanic(error);
        }
    }
}

