/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultLastCommittedTxIdSetter;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdGeneratorImpl;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.xaframework.DefaultLogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;

public class CommonFactories {
    public static IdGeneratorFactory defaultIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    public static FileSystemAbstraction defaultFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    public static LogBufferFactory defaultLogBufferFactory() {
        return new DefaultLogBufferFactory();
    }

    public static LastCommittedTxIdSetter defaultLastCommittedTxIdSetter() {
        return new DefaultLastCommittedTxIdSetter();
    }

    public static TxHook defaultTxHook() {
        return new DefaultTxHook();
    }

    public static RecoveryVerifier defaultRecoveryVerifier() {
        return RecoveryVerifier.ALWAYS_VALID;
    }

    public static class DefaultIdGeneratorFactory
    implements IdGeneratorFactory {
        private final Map<IdType, IdGenerator> generators = new HashMap<IdType, IdGenerator>();

        @Override
        public IdGenerator open(FileSystemAbstraction fs, String fileName, int grabSize, IdType idType, long highestIdInUse, boolean startup) {
            IdGeneratorImpl generator = new IdGeneratorImpl(fs, fileName, grabSize, idType.getMaxValue(), idType.allowAggressiveReuse());
            this.generators.put(idType, generator);
            return generator;
        }

        @Override
        public IdGenerator get(IdType idType) {
            return this.generators.get((Object)idType);
        }

        @Override
        public void create(FileSystemAbstraction fs, String fileName) {
            IdGeneratorImpl.createGenerator(fs, fileName);
        }
    }
}

