/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.ConfigProxy;
import org.neo4j.kernel.ConfigurationMigrator;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultLastCommittedTxIdSetter;
import org.neo4j.kernel.DefaultTxHook;
import org.neo4j.kernel.GraphDatabaseSPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.IndexManagerImpl;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.LifeSupport;
import org.neo4j.kernel.Lifecycle;
import org.neo4j.kernel.LifecycleAdapter;
import org.neo4j.kernel.LifecycleException;
import org.neo4j.kernel.NodeAutoIndexerImpl;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.TransactionBuilder;
import org.neo4j.kernel.TransactionBuilderImpl;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PropertyIndexManager;
import org.neo4j.kernel.impl.core.ReadOnlyNodeManager;
import org.neo4j.kernel.impl.core.RelationshipImpl;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.core.TransactionEventsSyncHook;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreFactory;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.persistence.PersistenceManager;
import org.neo4j.kernel.impl.persistence.PersistenceSource;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.RagManager;
import org.neo4j.kernel.impl.transaction.ReadOnlyTxManager;
import org.neo4j.kernel.impl.transaction.TransactionManagerProvider;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxManager;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.DefaultLogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.transaction.xaframework.XaFactory;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.tooling.GlobalGraphOperations;

public abstract class AbstractGraphDatabase
implements GraphDatabaseService,
GraphDatabaseSPI {
    private static final NodeManager.CacheType DEFAULT_CACHE_TYPE = NodeManager.CacheType.soft;
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    protected String storeDir;
    protected Map<String, String> params;
    private StoreId storeId;
    private Transaction placeboTransaction = null;
    private final TransactionBuilder defaultTxBuilder = new TransactionBuilderImpl(this, ForceMode.forced);
    protected StringLogger msgLog;
    protected KernelEventHandlers kernelEventHandlers;
    protected TransactionEventHandlers transactionEventHandlers;
    protected RelationshipTypeHolder relationshipTypeHolder;
    protected NodeManager nodeManager;
    protected IndexManagerImpl indexManager;
    protected Config config;
    protected KernelPanicEventGenerator kernelPanicEventGenerator;
    protected TxHook txHook;
    protected FileSystemAbstraction fileSystem;
    protected XaDataSourceManager xaDataSourceManager;
    protected RagManager ragManager;
    protected LockManager lockManager;
    protected IdGeneratorFactory idGeneratorFactory;
    protected RelationshipTypeCreator relationshipTypeCreator;
    protected LastCommittedTxIdSetter lastCommittedTxIdSetter;
    protected NioNeoDbPersistenceSource persistenceSource;
    protected TxEventSyncHookFactory syncHook;
    protected PersistenceManager persistenceManager;
    protected PropertyIndexManager propertyIndexManager;
    protected LockReleaser lockReleaser;
    protected IndexStore indexStore;
    protected LogBufferFactory logBufferFactory;
    protected AbstractTransactionManager txManager;
    protected TxIdGenerator txIdGenerator;
    protected StoreFactory storeFactory;
    protected XaFactory xaFactory;
    protected DiagnosticsManager diagnosticsManager;
    protected NeoStoreXaDataSource neoDataSource;
    protected RecoveryVerifier recoveryVerifier;
    protected MeasureDoNothing monitorGc;
    protected NodeAutoIndexerImpl nodeAutoIndexer;
    protected RelationshipAutoIndexerImpl relAutoIndexer;
    protected KernelData extensions;
    private final LifeSupport life = new LifeSupport();

    protected AbstractGraphDatabase(String storeDir, Map<String, String> params) {
        this.params = params;
        this.storeDir = FileUtils.fixSeparatorsInPath(this.canonicalize(storeDir));
    }

    protected void run() {
        this.create();
        try {
            this.life.start();
        }
        catch (LifecycleException throwable) {
            this.msgLog.logMessage("Startup failed", throwable);
            this.shutdown();
            throw throwable;
        }
    }

    private void create() {
        this.msgLog = this.createStringLogger();
        this.params = new ConfigurationMigrator(this.msgLog).migrateConfiguration(this.params);
        Configuration conf = ConfigProxy.config(this.params, Configuration.class);
        boolean readOnly = conf.read_only(false);
        NodeManager.CacheType cacheType = conf.cache_type(DEFAULT_CACHE_TYPE);
        this.kernelEventHandlers = new KernelEventHandlers();
        this.diagnosticsManager = this.life.add(new DiagnosticsManager(this.msgLog));
        this.kernelPanicEventGenerator = new KernelPanicEventGenerator(this.kernelEventHandlers);
        this.txHook = this.createTxHook();
        this.fileSystem = this.life.add(this.createFileSystemAbstraction());
        this.xaDataSourceManager = this.life.add(new XaDataSourceManager(this.msgLog));
        if (readOnly) {
            this.txManager = new ReadOnlyTxManager(this.xaDataSourceManager);
        } else {
            String serviceName = this.params.get("tx_manager_impl");
            if (serviceName == null) {
                this.txManager = new TxManager(this.storeDir, this.xaDataSourceManager, this.kernelPanicEventGenerator, this.txHook, this.msgLog, this.fileSystem);
            } else {
                TransactionManagerProvider provider = Service.load(TransactionManagerProvider.class, serviceName);
                if (provider == null) {
                    throw new IllegalStateException("Unknown transaction manager implementation: " + serviceName);
                }
                this.txManager = provider.loadTransactionManager(this.storeDir, this.kernelPanicEventGenerator, this.txHook, this.msgLog, this.fileSystem);
            }
        }
        this.life.add(this.txManager);
        this.transactionEventHandlers = new TransactionEventHandlers(this.txManager);
        this.txIdGenerator = this.createTxIdGenerator();
        this.ragManager = new RagManager(this.txManager);
        this.lockManager = this.createLockManager();
        this.idGeneratorFactory = this.createIdGeneratorFactory();
        this.relationshipTypeCreator = new DefaultRelationshipTypeCreator();
        this.lastCommittedTxIdSetter = this.createLastCommittedTxIdSetter();
        this.persistenceSource = this.life.add(new NioNeoDbPersistenceSource(this.xaDataSourceManager));
        this.syncHook = new DefaultTxEventSyncHookFactory();
        this.persistenceManager = new PersistenceManager(this.txManager, this.persistenceSource, this.syncHook, this.lockReleaser);
        this.propertyIndexManager = this.life.add(new PropertyIndexManager(this.txManager, this.persistenceManager, this.persistenceSource));
        this.lockReleaser = new LockReleaser(this.lockManager, this.txManager, this.nodeManager, this.propertyIndexManager);
        this.persistenceManager.setLockReleaser(this.lockReleaser);
        this.relationshipTypeHolder = new RelationshipTypeHolder(this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeCreator);
        this.nodeManager = !readOnly ? new NodeManager(ConfigProxy.config(this.params, NodeManager.Configuration.class), this, this.lockManager, this.lockReleaser, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), this.msgLog, this.diagnosticsManager) : new ReadOnlyNodeManager(ConfigProxy.config(this.params, NodeManager.Configuration.class), this, this.lockManager, this.lockReleaser, this.txManager, this.persistenceManager, this.persistenceSource, this.relationshipTypeHolder, cacheType, this.propertyIndexManager, this.createNodeLookup(), this.createRelationshipLookups(), this.msgLog, this.diagnosticsManager);
        this.life.add(this.nodeManager);
        this.lockReleaser.setNodeManager(this.nodeManager);
        this.indexStore = new IndexStore(this.storeDir, this.fileSystem);
        String separator = System.getProperty("file.separator");
        String store = this.storeDir + separator + "neostore";
        this.params.put("store_dir", this.storeDir);
        this.params.put("neo_store", store);
        String logicalLog = this.storeDir + separator + "nioneo_logical.log";
        this.params.put("logical_log", logicalLog);
        this.config = new Config(this.fileSystem, this.storeDir, this.params);
        this.diagnosticsManager.prependProvider(this.config);
        this.params = this.config.getParams();
        this.logBufferFactory = new DefaultLogBufferFactory();
        this.extensions = this.life.add(this.createKernelData());
        if (conf.load_kernel_extensions(true)) {
            this.life.add(new DefaultKernelExtensionLoader(this.extensions));
        }
        this.indexManager = new IndexManagerImpl(this.config, this.indexStore, this.xaDataSourceManager, this.txManager, this);
        this.nodeAutoIndexer = this.life.add(new NodeAutoIndexerImpl(ConfigProxy.config(this.params, NodeAutoIndexerImpl.Configuration.class), this.indexManager, this.nodeManager));
        this.relAutoIndexer = this.life.add(new RelationshipAutoIndexerImpl(ConfigProxy.config(this.params, RelationshipAutoIndexerImpl.Configuration.class), this.indexManager, this.nodeManager));
        this.indexManager.setNodeAutoIndexer(this.nodeAutoIndexer);
        this.indexManager.setRelAutoIndexer(this.relAutoIndexer);
        this.recoveryVerifier = this.createRecoveryVerifier();
        this.storeFactory = this.createStoreFactory();
        this.xaFactory = new XaFactory(this.params, this.txIdGenerator, this.txManager, this.logBufferFactory, this.fileSystem, this.msgLog, this.recoveryVerifier);
        ArrayList<Pair<TransactionInterceptorProvider, Object>> providers = new ArrayList<Pair<TransactionInterceptorProvider, Object>>(2);
        for (TransactionInterceptorProvider provider : Service.load(TransactionInterceptorProvider.class)) {
            String prov = this.params.get(TransactionInterceptorProvider.class.getSimpleName() + "." + provider.name());
            if (prov == null) continue;
            providers.add(Pair.of(provider, prov));
        }
        try {
            this.neoDataSource = new NeoStoreXaDataSource(ConfigProxy.config(this.params, NeoStoreXaDataSource.Configuration.class), this.fileSystem, this.storeFactory, this.lockManager, this.lockReleaser, this.msgLog, this.xaFactory, providers, new DependencyResolverImpl());
            this.xaDataSourceManager.registerDataSource(this.neoDataSource);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create Neo XA datasource", e);
        }
        this.life.add(new StuffToDoAfterRecovery());
        this.life.add(new MonitorGc(ConfigProxy.config(this.params, MonitorGc.Configuration.class), this.msgLog));
        this.life.add(new DatabaseAvailability());
        this.life.add(this.kernelEventHandlers);
    }

    @Override
    public void shutdown() {
        try {
            this.life.shutdown();
        }
        catch (LifecycleException throwable) {
            this.msgLog.logMessage("Shutdown failed", throwable);
        }
    }

    protected StoreFactory createStoreFactory() {
        return new StoreFactory(this.params, this.idGeneratorFactory, this.fileSystem, this.lastCommittedTxIdSetter, this.msgLog, this.txHook);
    }

    protected RecoveryVerifier createRecoveryVerifier() {
        return CommonFactories.defaultRecoveryVerifier();
    }

    protected KernelData createKernelData() {
        return new DefaultKernelData(this.config, this);
    }

    protected LastCommittedTxIdSetter createLastCommittedTxIdSetter() {
        return new DefaultLastCommittedTxIdSetter();
    }

    protected TxIdGenerator createTxIdGenerator() {
        return TxIdGenerator.DEFAULT;
    }

    protected RelationshipProxy.RelationshipLookups createRelationshipLookups() {
        return new RelationshipProxy.RelationshipLookups(){

            @Override
            public Node lookupNode(long nodeId) {
                return AbstractGraphDatabase.this.nodeManager.getNodeById(nodeId);
            }

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId) {
                return AbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId, null);
            }

            @Override
            public RelationshipImpl lookupRelationship(long relationshipId, LockType lock) {
                return AbstractGraphDatabase.this.nodeManager.getRelationshipForProxy(relationshipId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return AbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return AbstractGraphDatabase.this.nodeManager;
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return AbstractGraphDatabase.this.nodeManager.newNodeProxyById(nodeId);
            }
        };
    }

    protected NodeProxy.NodeLookup createNodeLookup() {
        return new NodeProxy.NodeLookup(){

            @Override
            public NodeImpl lookup(long nodeId) {
                return AbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, null);
            }

            @Override
            public NodeImpl lookup(long nodeId, LockType lock) {
                return AbstractGraphDatabase.this.nodeManager.getNodeForProxy(nodeId, lock);
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return AbstractGraphDatabase.this;
            }

            @Override
            public NodeManager getNodeManager() {
                return AbstractGraphDatabase.this.nodeManager;
            }
        };
    }

    protected TxHook createTxHook() {
        return new DefaultTxHook();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new CommonFactories.DefaultIdGeneratorFactory();
    }

    protected LockManager createLockManager() {
        return new LockManager(this.ragManager);
    }

    protected StringLogger createStringLogger() {
        final StringLogger stringLogger = StringLogger.logger(this.storeDir);
        this.life.add(new LifecycleAdapter(){

            @Override
            public void shutdown() throws Throwable {
                stringLogger.close();
            }
        });
        return stringLogger;
    }

    @Override
    public final String getStoreDir() {
        return this.storeDir;
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    @Override
    public Transaction beginTx() {
        return this.tx().begin();
    }

    Transaction beginTx(ForceMode forceMode) {
        if (this.transactionRunning()) {
            if (this.placeboTransaction == null) {
                this.placeboTransaction = new PlaceboTransaction(this.txManager);
            }
            return this.placeboTransaction;
        }
        TopLevelTransaction result = null;
        try {
            this.txManager.begin(forceMode);
            result = new TopLevelTransaction(this.txManager, this.lockManager, this.lockReleaser);
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to begin transaction", e);
        }
        return result;
    }

    public boolean transactionRunning() {
        try {
            return this.txManager.getTransaction() != null;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    @Deprecated
    public final <T> T getManagementBean(Class<T> type) {
        return this.getSingleManagementBean(type);
    }

    @Override
    public final <T> T getSingleManagementBean(Class<T> type) {
        Iterator<T> beans = this.getManagementBeans(type).iterator();
        if (beans.hasNext()) {
            T bean = beans.next();
            if (beans.hasNext()) {
                throw new NotFoundException("More than one management bean for " + type.getName());
            }
            return bean;
        }
        return null;
    }

    protected boolean isEphemeral() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadConfigurations(String file) {
        Properties props = new Properties();
        try {
            FileInputStream stream = new FileInputStream(new File(file));
            try {
                props.load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load " + file, e);
        }
        Set<Map.Entry<Object, Object>> entries = props.entrySet();
        HashMap<String, String> stringProps = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            stringProps.put(key, value);
        }
        return stringProps;
    }

    @Override
    public Node createNode() {
        return this.nodeManager.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new NotFoundException("Node[" + id + "]");
        }
        return this.nodeManager.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > MAX_RELATIONSHIP_ID) {
            throw new NotFoundException("Relationship[" + id + "]");
        }
        return this.nodeManager.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.nodeManager.getReferenceNode();
    }

    @Override
    public TransactionBuilder tx() {
        return this.defaultTxBuilder;
    }

    @Override
    public <T> Collection<T> getManagementBeans(Class<T> beanClass) {
        KernelExtension jmx = Service.load(KernelExtension.class, "kernel jmx");
        if (jmx != null) {
            Method getManagementBeans = null;
            Object state = jmx.getState(this.extensions);
            if (state != null) {
                try {
                    getManagementBeans = state.getClass().getMethod("getManagementBeans", Class.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (getManagementBeans != null) {
                try {
                    Collection result = (Collection)getManagementBeans.invoke(state, beanClass);
                    if (result == null) {
                        return Collections.emptySet();
                    }
                    return result;
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getTargetException();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        throw new UnsupportedOperationException("Neo4j JMX support not enabled");
    }

    @Override
    public KernelData getKernelData() {
        return this.extensions;
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public XaDataSourceManager getXaDataSourceManager() {
        return this.xaDataSourceManager;
    }

    @Override
    public TransactionManager getTxManager() {
        return this.txManager;
    }

    @Override
    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.relationshipTypeHolder;
    }

    @Override
    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    @Override
    public DiagnosticsManager getDiagnosticsManager() {
        return this.diagnosticsManager;
    }

    @Override
    public PersistenceSource getPersistenceSource() {
        return this.persistenceSource;
    }

    @Override
    public final StringLogger getMessageLog() {
        return this.msgLog;
    }

    @Override
    public KernelPanicEventGenerator getKernelPanicGenerator() {
        return this.kernelPanicEventGenerator;
    }

    private String canonicalize(String path) {
        try {
            return new File(path).getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractGraphDatabase that = (AbstractGraphDatabase)o;
        if (this.getStoreId() != null ? !this.getStoreId().equals(that.getStoreId()) : that.getStoreId() != null) {
            return false;
        }
        return this.storeDir.equals(that.storeDir);
    }

    public int hashCode() {
        return this.storeDir.hashCode();
    }

    class StuffToDoAfterRecovery
    implements Lifecycle {
        StuffToDoAfterRecovery() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
            AbstractGraphDatabase.this.storeId = AbstractGraphDatabase.this.neoDataSource.getStoreId();
            KernelDiagnostics.register(AbstractGraphDatabase.this.diagnosticsManager, AbstractGraphDatabase.this, AbstractGraphDatabase.this.neoDataSource);
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DatabaseAvailability
    implements Lifecycle {
        DatabaseAvailability() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DatabaseStartup
    implements Lifecycle {
        DatabaseStartup() {
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }
    }

    class DependencyResolverImpl
    implements DependencyResolver {
        DependencyResolverImpl() {
        }

        @Override
        public <T> T resolveDependency(Class<T> type) {
            if (type.equals(Map.class)) {
                return (T)AbstractGraphDatabase.this.params;
            }
            if (GraphDatabaseService.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this;
            }
            if (TransactionManager.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.txManager;
            }
            if (LockManager.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.lockManager;
            }
            if (LockReleaser.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.lockReleaser;
            }
            if (StoreFactory.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.storeFactory;
            }
            if (StringLogger.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.msgLog;
            }
            if (IndexStore.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.indexStore;
            }
            if (XaFactory.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.xaFactory;
            }
            if (XaDataSourceManager.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.xaDataSourceManager;
            }
            if (FileSystemAbstraction.class.isAssignableFrom(type)) {
                return (T)AbstractGraphDatabase.this.fileSystem;
            }
            throw new IllegalArgumentException("Could not resolve dependency of type:" + type.getName());
        }
    }

    private class DefaultTxEventSyncHookFactory
    implements TxEventSyncHookFactory {
        private DefaultTxEventSyncHookFactory() {
        }

        @Override
        public TransactionEventsSyncHook create() {
            return AbstractGraphDatabase.this.transactionEventHandlers.hasHandlers() ? new TransactionEventsSyncHook(AbstractGraphDatabase.this.nodeManager, AbstractGraphDatabase.this.transactionEventHandlers, AbstractGraphDatabase.this.txManager) : null;
        }
    }

    private class DefaultKernelExtensionLoader
    implements Lifecycle {
        private final KernelData extensions;
        private Collection<KernelExtension<?>> loaded;

        public DefaultKernelExtensionLoader(KernelData extensions) {
            this.extensions = extensions;
        }

        @Override
        public void init() throws Throwable {
            this.loaded = this.extensions.loadExtensionConfigurations(AbstractGraphDatabase.this.msgLog);
            this.loadIndexImplementations(AbstractGraphDatabase.this.indexManager, AbstractGraphDatabase.this.msgLog);
        }

        @Override
        public void start() throws Throwable {
            this.extensions.loadExtensions(this.loaded, AbstractGraphDatabase.this.msgLog);
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
        }

        void loadIndexImplementations(IndexManagerImpl indexes, StringLogger msgLog) {
            for (IndexProvider index : Service.load(IndexProvider.class)) {
                try {
                    indexes.addProvider(index.identifier(), index.load(new DependencyResolverImpl()));
                }
                catch (Throwable cause) {
                    msgLog.logMessage("Failed to load index provider " + index.identifier(), cause);
                    if (this.isAnUpgradeProblem(cause)) {
                        throw Exceptions.launderedException(cause);
                    }
                    cause.printStackTrace();
                }
            }
        }

        private boolean isAnUpgradeProblem(Throwable cause) {
            while (cause != null) {
                if (cause instanceof Throwable) {
                    return true;
                }
                cause = cause.getCause();
            }
            return false;
        }
    }

    protected class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final Config config;
        private final GraphDatabaseSPI graphDb;

        public DefaultKernelData(Config config, GraphDatabaseSPI graphDb) {
            this.config = config;
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public Config getConfig() {
            return this.config;
        }

        @Override
        public Map<String, String> getConfigParams() {
            return AbstractGraphDatabase.this.params;
        }

        @Override
        public GraphDatabaseSPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }

        @Override
        public void shutdown() throws Throwable {
            this.shutdown(AbstractGraphDatabase.this.msgLog);
        }
    }

    static interface Configuration {
        public boolean read_only(boolean var1);

        public NodeManager.CacheType cache_type(NodeManager.CacheType var1);

        public boolean load_kernel_extensions(boolean var1);
    }
}

