/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractStore;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.StringLogger;

public class RelationshipStore
extends AbstractStore
implements Store,
RecordStore<RelationshipRecord> {
    public static final String TYPE_DESCRIPTOR = "RelationshipStore";
    public static final int RECORD_SIZE = 33;

    public RelationshipStore(String fileName, Configuration configuration, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, configuration, IdType.RELATIONSHIP, idGeneratorFactory, fileSystemAbstraction, stringLogger);
    }

    @Override
    public void accept(RecordStore.Processor processor, RelationshipRecord record) {
        processor.processRelationship(this, record);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    public int getRecordSize() {
        return 33;
    }

    @Override
    public int getRecordHeaderSize() {
        return this.getRecordSize();
    }

    @Override
    public void close() {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationshipRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            RelationshipRecord relationshipRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelationshipRecord forceGetRecord(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new RelationshipRecord(id, -1L, -1L, -1);
        }
        try {
            RelationshipRecord relationshipRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public RelationshipRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getLightRel(long id) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            RelationshipRecord record;
            RelationshipRecord relationshipRecord = record = this.getRecord(id, window, RecordLoad.CHECK);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(RelationshipRecord record, boolean recovered) {
        assert (recovered);
        this.setRecovered();
        try {
            this.updateRecord(record);
            this.registerIdFromUpdateRecord(record.getId());
        }
        finally {
            this.unsetRecovered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(RelationshipRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, false);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateRecord(RelationshipRecord record) {
        PersistenceWindow window = this.acquireWindow(record.getId(), OperationType.WRITE);
        try {
            this.updateRecord(record, window, true);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    private void updateRecord(RelationshipRecord record, PersistenceWindow window, boolean force) {
        long id = record.getId();
        Buffer buffer = window.getOffsettedBuffer(id);
        if (record.inUse() || force) {
            long firstNode = record.getFirstNode();
            short firstNodeMod = (short)((firstNode & 0x700000000L) >> 31);
            long secondNode = record.getSecondNode();
            long secondNodeMod = (secondNode & 0x700000000L) >> 4;
            long firstPrevRel = record.getFirstPrevRel();
            long firstPrevRelMod = firstPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstPrevRel & 0x700000000L) >> 7;
            long firstNextRel = record.getFirstNextRel();
            long firstNextRelMod = firstNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (firstNextRel & 0x700000000L) >> 10;
            long secondPrevRel = record.getSecondPrevRel();
            long secondPrevRelMod = secondPrevRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondPrevRel & 0x700000000L) >> 13;
            long secondNextRel = record.getSecondNextRel();
            long secondNextRelMod = secondNextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? 0L : (secondNextRel & 0x700000000L) >> 16;
            long nextProp = record.getNextProp();
            long nextPropMod = nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0L : (nextProp & 0xF00000000L) >> 28;
            short inUseUnsignedByte = (short)((long)((record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue() | firstNodeMod) | nextPropMod);
            int typeInt = (int)((long)record.getType() | secondNodeMod | firstPrevRelMod | firstNextRelMod | secondPrevRelMod | secondNextRelMod);
            buffer.put((byte)inUseUnsignedByte).putInt((int)firstNode).putInt((int)secondNode).putInt(typeInt).putInt((int)firstPrevRel).putInt((int)firstNextRel).putInt((int)secondPrevRel).putInt((int)secondNextRel).putInt((int)nextProp);
        } else {
            buffer.put(Record.NOT_IN_USE.byteValue());
            if (!this.isInRecoveryMode()) {
                this.freeId(id);
            }
        }
    }

    private RelationshipRecord getRecord(long id, PersistenceWindow window, RecordLoad load) {
        boolean inUse;
        Buffer buffer = window.getOffsettedBuffer(id);
        long inUseByte = buffer.get();
        boolean bl = inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
        if (!inUse) {
            switch (load) {
                case NORMAL: {
                    throw new InvalidRecordException("RelationshipRecord[" + id + "] not in use");
                }
                case CHECK: {
                    return null;
                }
            }
        }
        long firstNode = buffer.getUnsignedInt();
        long firstNodeMod = (inUseByte & 0xEL) << 31;
        long secondNode = buffer.getUnsignedInt();
        long typeInt = buffer.getInt();
        long secondNodeMod = (typeInt & 0x70000000L) << 4;
        int type = (int)(typeInt & 0xFFFFL);
        RelationshipRecord record = new RelationshipRecord(id, this.longFromIntAndMod(firstNode, firstNodeMod), this.longFromIntAndMod(secondNode, secondNodeMod), type);
        record.setInUse(inUse);
        long firstPrevRel = buffer.getUnsignedInt();
        long firstPrevRelMod = (typeInt & 0xE000000L) << 7;
        record.setFirstPrevRel(this.longFromIntAndMod(firstPrevRel, firstPrevRelMod));
        long firstNextRel = buffer.getUnsignedInt();
        long firstNextRelMod = (typeInt & 0x1C00000L) << 10;
        record.setFirstNextRel(this.longFromIntAndMod(firstNextRel, firstNextRelMod));
        long secondPrevRel = buffer.getUnsignedInt();
        long secondPrevRelMod = (typeInt & 0x380000L) << 13;
        record.setSecondPrevRel(this.longFromIntAndMod(secondPrevRel, secondPrevRelMod));
        long secondNextRel = buffer.getUnsignedInt();
        long secondNextRelMod = (typeInt & 0x70000L) << 16;
        record.setSecondNextRel(this.longFromIntAndMod(secondNextRel, secondNextRelMod));
        long nextProp = buffer.getUnsignedInt();
        long nextPropMod = (inUseByte & 0xF0L) << 28;
        record.setNextProp(this.longFromIntAndMod(nextProp, nextPropMod));
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipRecord getChainRecord(long relId) {
        PersistenceWindow window = null;
        try {
            window = this.acquireWindow(relId, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return null;
        }
        try {
            RelationshipRecord relationshipRecord = this.getRecord(relId, window, RecordLoad.NORMAL);
            return relationshipRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public List<WindowPoolStats> getAllWindowPoolStats() {
        ArrayList<WindowPoolStats> list = new ArrayList<WindowPoolStats>();
        list.add(this.getWindowPoolStats());
        return list;
    }

    public static interface Configuration
    extends AbstractStore.Configuration {
    }
}

