/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;

public class IndexProviderStore {
    private static final int FILE_LENGTH = 40;
    private long creationTime;
    private long randomIdentifier;
    private long version;
    private long indexVersion;
    private final FileChannel fileChannel;
    private final ByteBuffer buf = ByteBuffer.allocate(40);
    private long lastCommittedTx;
    private final File file;

    public IndexProviderStore(File file, FileSystemAbstraction fileSystem, long expectedVersion, boolean allowUpgrade) {
        this.file = file;
        if (!file.exists()) {
            this.create(file, fileSystem, expectedVersion);
        }
        try {
            boolean versionDiffers;
            this.fileChannel = fileSystem.open(file.getAbsolutePath(), "rw");
            int bytesRead = this.fileChannel.read(this.buf);
            if (bytesRead != 40 && bytesRead != 32 && !allowUpgrade) {
                throw new RuntimeException("Expected to read 40 or 32 bytes");
            }
            this.buf.flip();
            this.creationTime = this.buf.getLong();
            this.randomIdentifier = this.buf.getLong();
            this.version = this.buf.getLong();
            this.lastCommittedTx = bytesRead / 8 >= 4 ? this.buf.getLong() : 1L;
            Long readIndexVersion = bytesRead / 8 >= 5 ? Long.valueOf(this.buf.getLong()) : null;
            boolean bl = versionDiffers = readIndexVersion == null || readIndexVersion != expectedVersion;
            if (versionDiffers && !allowUpgrade) {
                throw new UpgradeNotAllowedByConfigurationException();
            }
            this.indexVersion = expectedVersion;
            if (versionDiffers) {
                this.writeOut();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void create(File file, FileSystemAbstraction fileSystem, long indexVersion) {
        if (file.exists()) {
            throw new IllegalArgumentException(file + " already exist");
        }
        try {
            FileChannel fileChannel = fileSystem.open(file.getAbsolutePath(), "rw");
            ByteBuffer buf = ByteBuffer.allocate(40);
            long time = System.currentTimeMillis();
            long identifier = new Random(time).nextLong();
            buf.putLong(time).putLong(identifier).putLong(0L).putLong(1L).putLong(indexVersion);
            buf.flip();
            this.writeBuffer(fileChannel, buf);
            fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBuffer(FileChannel fileChannel, ByteBuffer buf) throws IOException {
        int written = fileChannel.write(buf);
        if (written != 40) {
            throw new RuntimeException("Expected to write 40 bytes, but wrote " + written);
        }
    }

    public File getFile() {
        return this.file;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomNumber() {
        return this.randomIdentifier;
    }

    public long getVersion() {
        return this.version;
    }

    public long getIndexVersion() {
        return this.indexVersion;
    }

    public synchronized long incrementVersion() {
        long current = this.getVersion();
        ++this.version;
        this.writeOut();
        return current;
    }

    public synchronized void setVersion(long version) {
        this.version = version;
        this.writeOut();
    }

    public synchronized void setLastCommittedTx(long txId) {
        this.lastCommittedTx = txId;
    }

    public synchronized void setIndexVersion(long indexVersion) {
        this.indexVersion = indexVersion;
        this.writeOut();
    }

    public long getLastCommittedTx() {
        return this.lastCommittedTx;
    }

    private void writeOut() {
        this.buf.clear();
        this.buf.putLong(this.creationTime).putLong(this.randomIdentifier).putLong(this.version).putLong(this.lastCommittedTx).putLong(this.indexVersion);
        this.buf.flip();
        try {
            this.fileChannel.position(0L);
            this.writeBuffer(this.fileChannel, this.buf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.fileChannel.isOpen()) {
            return;
        }
        this.writeOut();
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

