/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.factory.Default;
import org.neo4j.graphdb.factory.GraphDatabaseSetting;
import org.neo4j.helpers.collection.Iterables;

public class ConfigurationDefaults {
    private Iterable<Class<?>> settingsClasses;

    public static String getDefault(GraphDatabaseSetting realSetting, Class<?> settingsClass) {
        for (Field field : settingsClass.getFields()) {
            try {
                GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                if (setting != realSetting) continue;
                if (setting instanceof GraphDatabaseSetting.DefaultValue) {
                    return ((GraphDatabaseSetting.DefaultValue)((Object)setting)).getDefaultValue();
                }
                return ConfigurationDefaults.getDefaultValue(field);
            }
            catch (IllegalAccessException e) {
                assert (false) : "Field " + field.getName() + " is not public";
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Setting {0} not found in settings-class {1}", realSetting.name(), settingsClass.getName()));
    }

    private static String getDefaultValue(Field field) {
        Default defaultAnnotation = field.getAnnotation(Default.class);
        if (defaultAnnotation == null) {
            return null;
        }
        return defaultAnnotation.value();
    }

    public ConfigurationDefaults(Class<?> ... settingsClasses) {
        this(Iterables.iterable(settingsClasses));
    }

    public ConfigurationDefaults(Iterable<Class<?>> settingsClasses) {
        this.settingsClasses = settingsClasses;
    }

    public Map<String, String> apply(Map<String, String> config) {
        HashMap<String, String> configuration = new HashMap<String, String>(config);
        for (Class<?> settingsClass : this.settingsClasses) {
            for (Field field : settingsClass.getFields()) {
                try {
                    String defaultValue;
                    GraphDatabaseSetting setting = (GraphDatabaseSetting)field.get(null);
                    if (configuration.containsKey(setting.name())) continue;
                    if (setting instanceof GraphDatabaseSetting.DefaultValue) {
                        defaultValue = ((GraphDatabaseSetting.DefaultValue)((Object)setting)).getDefaultValue();
                        if (defaultValue == null) continue;
                        configuration.put(setting.name(), defaultValue);
                        continue;
                    }
                    defaultValue = ConfigurationDefaults.getDefaultValue(field);
                    if (defaultValue == null) continue;
                    configuration.put(setting.name(), defaultValue);
                }
                catch (IllegalAccessException e) {
                    assert (false) : "Field " + field.getName() + " is not public";
                }
            }
        }
        return configuration;
    }
}

