/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractStore
extends CommonAbstractStore {
    public abstract int getRecordSize();

    @Override
    protected long figureOutHighestIdInUse() {
        try {
            return this.getFileChannel().size() / (long)this.getRecordSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void createEmptyStore(String fileName, String typeAndVersionDescriptor, IdGeneratorFactory idGeneratorFactory, FileSystemAbstraction fileSystem) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename");
        }
        File file = new File(fileName);
        if (file.exists()) {
            throw new IllegalStateException("Can't create store[" + fileName + "], file already exists");
        }
        try {
            FileChannel channel = fileSystem.create(fileName);
            int endHeaderSize = UTF8.encode(typeAndVersionDescriptor).length;
            ByteBuffer buffer = ByteBuffer.allocate(endHeaderSize);
            buffer.put(UTF8.encode(typeAndVersionDescriptor)).flip();
            channel.write(buffer);
            channel.force(false);
            channel.close();
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create store " + fileName, e);
        }
        idGeneratorFactory.create(fileName + ".id");
    }

    public AbstractStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    @Override
    protected int getEffectiveRecordSize() {
        return this.getRecordSize();
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        int expectedVersionLength = UTF8.encode(AbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor())).length;
        long fileSize = this.getFileChannel().size();
        if (this.getRecordSize() != 0 && (fileSize - (long)expectedVersionLength) % (long)this.getRecordSize() != 0L && !this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Misaligned file size " + fileSize + " for " + this + ", expected version length:" + expectedVersionLength));
        }
        if (this.getStoreOk() && !this.isReadOnly()) {
            this.getFileChannel().truncate(fileSize - (long)expectedVersionLength);
        }
    }

    public void setHighId(int id) {
        super.setHighId(id);
    }

    private long findHighIdBackwards() throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        int recordSize = this.getRecordSize();
        long fileSize = fileChannel.size();
        long highId = fileSize / (long)recordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getRecordSize());
        for (long i = highId; i > 0L; --i) {
            fileChannel.position(i * (long)recordSize);
            if (fileChannel.read(byteBuffer) <= 0) continue;
            byteBuffer.flip();
            boolean isInUse = this.isRecordInUse(byteBuffer);
            byteBuffer.clear();
            if (!isInUse) continue;
            return i;
        }
        return 0L;
    }

    protected boolean isRecordInUse(ByteBuffer buffer) {
        byte inUse = buffer.get();
        return (inUse & 1) == Record.IN_USE.byteValue();
    }

    @Override
    protected void rebuildIdGenerator() {
        if (this.isReadOnly() && !this.isBackupSlave()) {
            throw new ReadOnlyDbException();
        }
        logger.fine("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        File file = new File(this.getStorageFileName() + ".id");
        if (file.exists()) {
            boolean success = file.delete();
            assert (success);
        }
        this.createIdGenerator(this.getStorageFileName() + ".id");
        this.openIdGenerator(false);
        FileChannel fileChannel = this.getFileChannel();
        long highId = 1L;
        long defraggedCount = 0L;
        try {
            String mode;
            long fileSize = fileChannel.size();
            int recordSize = this.getRecordSize();
            boolean fullRebuild = true;
            if (this.getConfig() != null && (mode = (String)this.getConfig().get("rebuild_idgenerators_fast")) != null && mode.toLowerCase().equals("true")) {
                fullRebuild = false;
                highId = this.findHighIdBackwards();
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
            LinkedList<Long> freeIdList = new LinkedList<Long>();
            if (fullRebuild) {
                long i = 0L;
                while (i * (long)recordSize < fileSize && recordSize > 0) {
                    fileChannel.position(i * (long)recordSize);
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    byte inUse = byteBuffer.get();
                    byteBuffer.flip();
                    this.nextId();
                    if ((inUse & 1) == Record.NOT_IN_USE.byteValue()) {
                        freeIdList.add(i);
                    } else {
                        highId = i;
                        while (!freeIdList.isEmpty()) {
                            this.freeId((Long)freeIdList.removeFirst());
                            ++defraggedCount;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1L);
        if (this.getConfig() != null) {
            StringLogger msgLog = (StringLogger)this.getConfig().get(StringLogger.class);
            msgLog.logMessage(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount, true);
        }
        logger.fine("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.closeIdGenerator();
        this.openIdGenerator(false);
    }

    public abstract List<WindowPoolStats> getAllWindowPoolStats();
}

