/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.wrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;
import org.neo4j.tooling.wrap.WrappedObject;

class WrappedTraverser
extends WrappedObject<Traverser>
implements Traverser {
    WrappedTraverser(WrappedGraphDatabase graphdb, Traverser traverser) {
        super(graphdb, traverser);
    }

    @Override
    public TraversalPosition currentPosition() {
        return new Position(this.graphdb, ((Traverser)this.wrapped).currentPosition());
    }

    @Override
    public Collection<Node> getAllNodes() {
        Collection<Node> all = ((Traverser)this.wrapped).getAllNodes();
        ArrayList<Node> wrapped = new ArrayList<Node>(all.size());
        for (Node node : all) {
            wrapped.add(this.graphdb.node(node, false));
        }
        return wrapped;
    }

    @Override
    public Iterator<Node> iterator() {
        return new IteratorWrapper<Node, Node>(((Traverser)this.wrapped).iterator()){

            @Override
            protected Node underlyingObjectToObject(Node object) {
                return WrappedTraverser.this.graphdb.node(object, false);
            }
        };
    }

    private static class Position
    extends WrappedObject<TraversalPosition>
    implements TraversalPosition {
        Position(WrappedGraphDatabase graphdb, TraversalPosition pos) {
            super(graphdb, pos);
        }

        @Override
        public Node currentNode() {
            return this.graphdb.node(((TraversalPosition)this.wrapped).currentNode(), false);
        }

        @Override
        public Node previousNode() {
            return this.graphdb.node(((TraversalPosition)this.wrapped).previousNode(), false);
        }

        @Override
        public Relationship lastRelationshipTraversed() {
            return this.graphdb.relationship(((TraversalPosition)this.wrapped).lastRelationshipTraversed(), false);
        }

        @Override
        public int depth() {
            return ((TraversalPosition)this.wrapped).depth();
        }

        @Override
        public int returnedNodesCount() {
            return ((TraversalPosition)this.wrapped).returnedNodesCount();
        }

        @Override
        public boolean notStartNode() {
            return ((TraversalPosition)this.wrapped).notStartNode();
        }

        @Override
        public boolean isStartNode() {
            return ((TraversalPosition)this.wrapped).isStartNode();
        }
    }

    static class Evaluator
    implements StopEvaluator,
    ReturnableEvaluator {
        private final WrappedGraphDatabase graphdb;
        private final StopEvaluator stopEvaluator;
        private final ReturnableEvaluator returnableEvaluator;

        Evaluator(WrappedGraphDatabase graphdb, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator) {
            this.graphdb = graphdb;
            this.stopEvaluator = stopEvaluator;
            this.returnableEvaluator = returnableEvaluator;
        }

        @Override
        public boolean isStopNode(TraversalPosition currentPos) {
            return this.stopEvaluator.isStopNode(new Position(this.graphdb, currentPos));
        }

        @Override
        public boolean isReturnableNode(TraversalPosition currentPos) {
            return this.returnableEvaluator.isReturnableNode(new Position(this.graphdb, currentPos));
        }
    }
}

