/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.neo4j.helpers.Format;

public abstract class StringLogger {
    public static final String DEFAULT_NAME = "messages.log";
    public static final StringLogger SYSTEM = new ActualStringLogger(new PrintWriter(System.out));
    private static final int DEFAULT_THRESHOLD_FOR_ROTATION = 0x6400000;
    private static final int NUMBER_OF_OLD_LOGS_TO_KEEP = 2;
    public static final StringLogger DEV_NULL = new StringLogger(){

        @Override
        public void logMessage(String msg) {
        }

        @Override
        public void logMessage(String msg, Throwable cause) {
        }

        @Override
        public synchronized void logMessage(String msg, boolean flush) {
        }

        @Override
        public synchronized void logMessage(String msg, Throwable cause, boolean flush) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    };

    public static StringLogger logger(String storeDir) {
        return StringLogger.logger(storeDir, 0x6400000);
    }

    public static StringLogger logger(String storeDir, int rotationThreshold) {
        return new ActualStringLogger(new File(storeDir, DEFAULT_NAME).getAbsolutePath(), rotationThreshold);
    }

    public abstract void logMessage(String var1);

    public abstract void logMessage(String var1, Throwable var2);

    public abstract void logMessage(String var1, boolean var2);

    public abstract void logMessage(String var1, Throwable var2, boolean var3);

    public abstract void flush();

    public abstract void close();

    private static class ActualStringLogger
    extends StringLogger {
        private PrintWriter out;
        private final Integer rotationThreshold;
        private final File file;

        private ActualStringLogger(String filename, int rotationThreshold) {
            this.rotationThreshold = rotationThreshold;
            try {
                this.file = new File(filename);
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private ActualStringLogger(PrintWriter writer) {
            this.out = writer;
            this.rotationThreshold = null;
            this.file = null;
        }

        private void instantiateWriter() throws IOException {
            this.out = new PrintWriter(new FileWriter(this.file, true));
        }

        @Override
        public void logMessage(String msg) {
            this.logMessage(msg, false);
        }

        @Override
        public void logMessage(String msg, Throwable cause) {
            this.logMessage(msg, cause, false);
        }

        @Override
        public synchronized void logMessage(String msg, boolean flush) {
            this.out.println(this.time() + ": " + msg);
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        private String time() {
            return Format.date();
        }

        @Override
        public synchronized void logMessage(String msg, Throwable cause, boolean flush) {
            this.out.println(this.time() + ": " + msg + " " + cause.getMessage());
            cause.printStackTrace(this.out);
            if (flush) {
                this.out.flush();
            }
            this.checkRotation();
        }

        private void checkRotation() {
            if (this.rotationThreshold != null && this.file.length() > (long)this.rotationThreshold.intValue()) {
                this.doRotation();
            }
        }

        private void doRotation() {
            this.out.close();
            this.moveAwayFile();
            try {
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void moveAwayFile() {
            File oldLogFile = new File(this.file.getParentFile(), this.file.getName() + "." + 2);
            if (oldLogFile.exists()) {
                oldLogFile.delete();
            }
            for (int i = 1; i >= 0; --i) {
                oldLogFile = new File(this.file.getParentFile(), this.file.getName() + (i == 0 ? "" : "." + i));
                if (!oldLogFile.exists()) continue;
                oldLogFile.renameTo(new File(this.file.getParentFile(), this.file.getName() + "." + (i + 1)));
            }
        }

        @Override
        public void flush() {
            this.out.flush();
        }

        @Override
        public void close() {
            this.out.close();
        }
    }
}

