/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;

public class CompareTxStreams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        EmbeddedGraphDatabase db1 = new EmbeddedGraphDatabase(args[0]);
        EmbeddedGraphDatabase db2 = new EmbeddedGraphDatabase(args[1]);
        try {
            XaLogicalLog.LogExtractor extractor1 = CompareTxStreams.getLogExtractor(db1);
            XaLogicalLog.LogExtractor extractor2 = CompareTxStreams.getLogExtractor(db2);
            boolean branchingDetected = false;
            long lastTx = 1L;
            while (true) {
                long tx2;
                long tx1;
                if ((tx1 = extractor1.extractNext(new InMemoryLogBuffer())) != (tx2 = extractor2.extractNext(new InMemoryLogBuffer()))) {
                    throw new RuntimeException("Differing tx " + tx1 + " and " + tx2);
                }
                if (tx1 == -1L || tx2 == -1L) break;
                lastTx = tx1;
                if (!branchingDetected) {
                    if (extractor1.getLastStartEntry().getMasterId() == extractor2.getLastStartEntry().getMasterId() && extractor1.getLastTxChecksum() == extractor2.getLastTxChecksum()) continue;
                    branchingDetected = true;
                    System.out.println("Branch at " + tx1 + ": masters:" + extractor1.getLastStartEntry().getMasterId() + "," + extractor2.getLastStartEntry().getMasterId() + " checksums:" + extractor1.getLastTxChecksum() + "," + extractor2.getLastTxChecksum());
                    continue;
                }
                if (extractor1.getLastStartEntry().getMasterId() == extractor2.getLastStartEntry().getMasterId() && extractor1.getLastTxChecksum() == extractor2.getLastTxChecksum()) {
                    branchingDetected = false;
                    System.out.println("Merged again at " + tx1);
                    continue;
                }
                System.out.println("Still branched at " + tx1 + ": masters:" + extractor1.getLastStartEntry().getMasterId() + "," + extractor2.getLastStartEntry().getMasterId() + " checksums:" + extractor1.getLastTxChecksum() + "," + extractor2.getLastTxChecksum());
            }
            System.out.println("Last tx " + lastTx);
        }
        finally {
            db1.shutdown();
            db2.shutdown();
        }
    }

    private static XaLogicalLog.LogExtractor getLogExtractor(EmbeddedGraphDatabase db) throws IOException {
        XaDataSource ds = db.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
        return ds.getLogExtractor(2L, ds.getLastCommittedTxId());
    }
}

