/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.KernelData;

public final class EmbeddedReadOnlyGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService {
    private static Map<String, String> readOnlyParams = new HashMap<String, String>();
    private final EmbeddedGraphDbImpl graphDbImpl;

    public EmbeddedReadOnlyGraphDatabase(String storeDir) {
        this(storeDir, readOnlyParams);
    }

    public EmbeddedReadOnlyGraphDatabase(String storeDir, Map<String, String> params) {
        super(storeDir);
        params.put("read_only", "true");
        this.graphDbImpl = new EmbeddedGraphDbImpl(this.getStoreDir(), null, params, this, CommonFactories.defaultLockManagerFactory(), CommonFactories.defaultIdGeneratorFactory(), CommonFactories.defaultRelationshipTypeCreator(), CommonFactories.defaultTxIdGeneratorFactory(), CommonFactories.defaultTxHook(), CommonFactories.defaultLastCommittedTxIdSetter(), CommonFactories.defaultFileSystemAbstraction());
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDbImpl.loadConfigurations(file);
    }

    @Override
    public Node createNode() {
        return this.graphDbImpl.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        return this.graphDbImpl.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.graphDbImpl.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.graphDbImpl.getReferenceNode();
    }

    @Override
    protected void close() {
        this.graphDbImpl.shutdown();
    }

    @Override
    public Transaction beginTx() {
        return this.graphDbImpl.beginTx();
    }

    @Override
    public Config getConfig() {
        return this.graphDbImpl.getConfig();
    }

    @Override
    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.graphDbImpl.getManagementBeans(type);
    }

    @Override
    public KernelData getKernelData() {
        return this.graphDbImpl.getKernelData();
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.graphDbImpl.getStoreDir() + "]";
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexManager index() {
        return this.graphDbImpl.index();
    }

    static {
        readOnlyParams.put("read_only", "true");
    }
}

