/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.transaction.TransactionImpl;

public class UserTransactionImpl
implements UserTransaction {
    private final AbstractGraphDatabase neo4j;

    public UserTransactionImpl(GraphDatabaseService neo4j) {
        this.neo4j = (AbstractGraphDatabase)neo4j;
    }

    private TransactionManager getTxManager() {
        return this.neo4j.getConfig().getTxModule().getTxManager();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getTxManager().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTxManager().commit();
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        this.getTxManager().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTxManager().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.getTxManager().getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getTxManager().setTransactionTimeout(seconds);
    }

    public Integer getEventIdentifier() {
        try {
            TransactionImpl tx = (TransactionImpl)this.getTxManager().getTransaction();
            if (tx != null) {
                return tx.getEventIdentifier();
            }
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        return null;
    }
}

