/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.transaction.TransactionManager;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.kernel.impl.core.GraphDbModule;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.core.RelationshipTypeHolder;
import org.neo4j.kernel.impl.core.TxEventSyncHookFactory;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreId;
import org.neo4j.kernel.impl.persistence.IdGenerator;
import org.neo4j.kernel.impl.persistence.IdGeneratorModule;
import org.neo4j.kernel.impl.persistence.PersistenceModule;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxHook;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;

public class Config
implements DiagnosticsProvider {
    static final String NIO_NEO_DB_CLASS = "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource";
    public static final String DEFAULT_DATA_SOURCE_NAME = "nioneodb";
    static final String LUCENE_DS_CLASS = "org.neo4j.index.lucene.LuceneDataSource";
    static final String LUCENE_FULLTEXT_DS_CLASS = "org.neo4j.index.lucene.LuceneFulltextDataSource";
    @Documented(value=" Tell Neo4j to use memory mapped buffers for accessing the native storage\n layer\n")
    public static final String USE_MEMORY_MAPPED_BUFFERS = "use_memory_mapped_buffers";
    @Documented(value="Print out the effective Neo4j configuration after startup ")
    public static final String DUMP_CONFIGURATION = "dump_configuration";
    @Documented(value=" Make Neo4j keep the logical transaction logs for being able to backup the\n database\n")
    public static final String KEEP_LOGICAL_LOGS = "keep_logical_logs";
    @Documented(value="Enable a remote shell server which shell clients can log in to ")
    public static final String ENABLE_REMOTE_SHELL = "enable_remote_shell";
    @Documented(value="Enable a support for running online backups ")
    public static final String ENABLE_ONLINE_BACKUP = "enable_online_backup";
    @Documented(value="Mark this database as a backup slave. ")
    public static final String BACKUP_SLAVE = "backup_slave";
    @Documented(value="Only allow read operations from this Neo4j instance. ")
    public static final String READ_ONLY = "read_only";
    @Documented(value="Relative path for where the Neo4j storage directory is located ")
    public static final String STORAGE_DIRECTORY = "store_dir";
    @Documented(value=" Use a quick approach for rebuilding the ID generators. This give quicker\n recovery time, but will limit the ability to reuse the space of deleted\n entities.\n")
    public static final String REBUILD_IDGENERATORS_FAST = "rebuild_idgenerators_fast";
    @Documented(value="The size to allocate for memory mapping the node store ")
    public static final String NODE_STORE_MMAP_SIZE = "neostore.nodestore.db.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the array property store ")
    public static final String ARRAY_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.arrays.mapped_memory";
    @Documented(value=" The size to allocate for memory mapping the store for property key\n strings\n")
    public static final String PROPERTY_INDEX_KEY_STORE_MMAP_SIZE = "neostore.propertystore.db.index.keys.mapped_memory";
    @Documented(value=" The size to allocate for memory mapping the store for property key\n indexes\n")
    public static final String PROPERTY_INDEX_STORE_MMAP_SIZE = "neostore.propertystore.db.index.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the property value store ")
    public static final String PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the string property store ")
    public static final String STRING_PROPERTY_STORE_MMAP_SIZE = "neostore.propertystore.db.strings.mapped_memory";
    @Documented(value="The size to allocate for memory mapping the relationship store ")
    public static final String RELATIONSHIP_STORE_MMAP_SIZE = "neostore.relationshipstore.db.mapped_memory";
    @Documented(value="Relative path for where the Neo4j logical log is located ")
    public static final String LOGICAL_LOG = "logical_log";
    @Documented(value="Relative path for where the Neo4j storage information file is located ")
    public static final String NEO_STORE = "neo_store";
    @Documented(value=" The type of cache to use for nodes and relationships, one of [weak, soft,\n none, array]\n")
    public static final String CACHE_TYPE = "cache_type";
    @Documented(value=" The amount of memory to use for the node cache (when using the 'gcr' cache).\n")
    public static final String NODE_CACHE_SIZE = "node_cache_size";
    @Documented(value=" The amount of memory to use for the relationship cache (when using the 'gcr' cache).\n")
    public static final String RELATIONSHIP_CACHE_SIZE = "relationship_cache_size";
    @Documented(value=" The fraction of the heap (1%-10%) to use for the base array in the node cache (when using the 'gcr' cache).\n")
    public static final String NODE_CACHE_ARRAY_FRACTION = "node_cache_array_fraction";
    @Documented(value=" The fraction of the heap (1%-10%) to use for the base array in the relationship cache (when using the 'gcr' cache).\n")
    public static final String RELATIONSHIP_CACHE_ARRAY_FRACTION = "relationship_cache_array_fraction";
    @Documented(value=" The minimal time that must pass in between logging statistics from the cache (when using the 'gcr' cache).\n Default unit is seconds, suffix with 's', 'm', or 'ms' to have the unit be seconds, minutes or milliseconds respectively.\n")
    public static final String GCR_CACHE_MIN_LOG_INTERVAL = "gcr_cache_min_log_interval";
    @Documented(value=" The name of the Transaction Manager service to use as defined in the TM\n service provider constructor, defaults to native.\n")
    public static final String TXMANAGER_IMPLEMENTATION = "tx_manager_impl";
    @Documented(value=" Determines whether any TransactionInterceptors loaded will intercept\n prepared transactions before they reach the logical log. Defaults to\n false.\n")
    public static final String INTERCEPT_COMMITTING_TRANSACTIONS = "intercept_committing_transactions";
    @Documented(value=" Determines whether any TransactionInterceptors loaded will intercept\n externally received transactions (e.g. in HA) before they reach the\n logical log and are applied to the store. Defaults to false.\n")
    public static final String INTERCEPT_DESERIALIZED_TRANSACTIONS = "intercept_deserialized_transactions";
    @Documented(value=" Boolean (one of true,false) defining whether to allow a store upgrade\n in case the current version of the database starts against an older store\n version. Setting this to true does not guarantee successful upgrade, just\n allows an attempt at it.\n")
    public static final String ALLOW_STORE_UPGRADE = "allow_store_upgrade";
    public static final String STRING_BLOCK_SIZE = "string_block_size";
    public static final String ARRAY_BLOCK_SIZE = "array_block_size";
    @Documented(value=" A list of property names (comma separated) that will be indexed by\n default.\n This applies to Nodes only.\n")
    public static final String NODE_KEYS_INDEXABLE = "node_keys_indexable";
    @Documented(value=" A list of property names (comma separated) that will be indexed by\n default.\n This applies to Relationships only.\n")
    public static final String RELATIONSHIP_KEYS_INDEXABLE = "relationship_keys_indexable";
    @Documented(value=" Boolean value (one of true, false) that controls the auto indexing\n feature for nodes. Setting to false shuts it down unconditionally,\n while true enables it for every property, subject to restrictions\n in the configuration.\n The default is false.\n")
    public static final String NODE_AUTO_INDEXING = "node_auto_indexing";
    @Documented(value=" Boolean value (one of true, false) that controls the auto indexing\n feature for relationships. Setting to false shuts it down\n unconditionally, while true enables it for every property, subject\n to restrictions in the configuration.\n The default is false.\n")
    public static final String RELATIONSHIP_AUTO_INDEXING = "relationship_auto_indexing";
    @Documented(value=" Integer value that sets the maximum number of open lucene index searchers.\n The default is Integer.MAX_VALUE\n")
    public static final String LUCENE_SEARCHER_CACHE_SIZE = "lucene_searcher_cache_size";
    @Documented(value=" Integer value that sets the maximum number of open lucene index writers.\n The default is Integer.MAX_VALUE\n")
    public static final String LUCENE_WRITER_CACHE_SIZE = "lucene_writer_cache_size";
    @Documented(value=" Amount of time in ms the GC monitor thread will wait before taking another measurement.\n Default is 100 ms.\n")
    public static final String GC_MONITOR_WAIT_TIME = "gc_monitor_wait_time";
    @Documented(value=" The amount of time in ms the monitor thread has to be blocked before logging a message it was blocked.\n Default is 200ms\n")
    public static final String GC_MONITOR_THRESHOLD = "gc_monitor_threshold";
    static final String LOAD_EXTENSIONS = "load_kernel_extensions";
    private final TxModule txModule;
    private final LockManager lockManager;
    private final LockReleaser lockReleaser;
    private final PersistenceModule persistenceModule;
    private boolean create = false;
    private String persistenceSourceName;
    private final IdGeneratorModule idGeneratorModule;
    private final GraphDbModule graphDbModule;
    private final String storeDir;
    private final IndexStore indexStore;
    private final Map<Object, Object> params;
    private final Map inputParams;
    private final TxEventSyncHookFactory syncHookFactory;
    private final RelationshipTypeCreator relTypeCreator;
    private final boolean readOnly;
    private final boolean ephemeral;
    private final boolean backupSlave;
    private final IdGeneratorFactory idGeneratorFactory;
    private final TxIdGenerator txIdGenerator;
    private final DiagnosticsManager diagnostics;
    private final KernelPanicEventGenerator kpe;

    Config(AbstractGraphDatabase graphDb, StoreId storeId, Map<String, String> inputParams, KernelPanicEventGenerator kpe, TxModule txModule, LockManager lockManager, LockReleaser lockReleaser, IdGeneratorFactory idGeneratorFactory, TxEventSyncHookFactory txSyncHookFactory, RelationshipTypeCreator relTypeCreator, TxIdGenerator txIdGenerator, LastCommittedTxIdSetter lastCommittedTxIdSetter, FileSystemAbstraction fileSystem) {
        this.kpe = kpe;
        this.storeDir = graphDb.getStoreDir();
        this.inputParams = inputParams;
        this.ephemeral = graphDb.isEphemeral();
        this.params = Config.getDefaultParams();
        this.params.putAll(inputParams);
        this.idGeneratorFactory = idGeneratorFactory;
        this.relTypeCreator = relTypeCreator;
        this.txIdGenerator = txIdGenerator;
        this.txModule = txModule;
        this.lockManager = lockManager;
        this.lockReleaser = lockReleaser;
        this.idGeneratorModule = new IdGeneratorModule(new IdGenerator());
        this.readOnly = Boolean.parseBoolean((String)this.params.get(READ_ONLY));
        this.backupSlave = Boolean.parseBoolean((String)this.params.get(BACKUP_SLAVE));
        this.syncHookFactory = txSyncHookFactory;
        this.persistenceModule = new PersistenceModule();
        this.params.put(FileSystemAbstraction.class, fileSystem);
        this.graphDbModule = new GraphDbModule(graphDb, lockManager, txModule.getTxManager(), this.idGeneratorModule.getIdGenerator(), this.readOnly);
        this.indexStore = new IndexStore(this.storeDir, fileSystem);
        this.params.put(IndexStore.class, this.indexStore);
        if (storeId != null) {
            this.params.put(StoreId.class, storeId);
        }
        this.params.put(IdGeneratorFactory.class, idGeneratorFactory);
        this.params.put(TxIdGenerator.class, txIdGenerator);
        this.params.put(TransactionManager.class, txModule.getTxManager());
        this.params.put(LastCommittedTxIdSetter.class, lastCommittedTxIdSetter);
        this.params.put(GraphDbModule.class, this.graphDbModule);
        this.params.put(TxHook.class, txModule.getTxHook());
        this.params.put(StringLogger.class, graphDb.getMessageLog());
        this.diagnostics = new DiagnosticsManager(graphDb.getMessageLog());
        this.params.put(DiagnosticsManager.class, this.diagnostics);
        this.diagnostics.appendProvider(this);
    }

    public static Map<Object, Object> getDefaultParams() {
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        params.put(NODE_STORE_MMAP_SIZE, "20M");
        params.put(PROPERTY_STORE_MMAP_SIZE, "90M");
        params.put(PROPERTY_INDEX_STORE_MMAP_SIZE, "1M");
        params.put(PROPERTY_INDEX_KEY_STORE_MMAP_SIZE, "1M");
        params.put(STRING_PROPERTY_STORE_MMAP_SIZE, "130M");
        params.put(ARRAY_PROPERTY_STORE_MMAP_SIZE, "130M");
        params.put(RELATIONSHIP_STORE_MMAP_SIZE, "100M");
        if (Config.osIsWindows()) {
            params.put(USE_MEMORY_MAPPED_BUFFERS, "false");
        } else {
            params.put(USE_MEMORY_MAPPED_BUFFERS, "true");
        }
        params.put(NODE_AUTO_INDEXING, "false");
        params.put(RELATIONSHIP_AUTO_INDEXING, "false");
        params.put(NODE_CACHE_ARRAY_FRACTION, "1.0");
        params.put(RELATIONSHIP_CACHE_ARRAY_FRACTION, "1.0");
        params.put(GCR_CACHE_MIN_LOG_INTERVAL, "60s");
        params.put(GC_MONITOR_WAIT_TIME, "100");
        params.put(GC_MONITOR_THRESHOLD, "200");
        return params;
    }

    public static boolean osIsWindows() {
        String nameOs = System.getProperty("os.name");
        return nameOs.startsWith("Windows");
    }

    public static boolean osIsMacOS() {
        String nameOs = System.getProperty("os.name");
        return nameOs.equalsIgnoreCase("Mac OS X");
    }

    void setPersistenceSource(String name, boolean create) {
        this.persistenceSourceName = name;
        this.create = create;
    }

    String getPersistenceSource() {
        return this.persistenceSourceName;
    }

    boolean getCreatePersistenceSource() {
        return this.create;
    }

    public TxModule getTxModule() {
        return this.txModule;
    }

    public GraphDbModule getGraphDbModule() {
        return this.graphDbModule;
    }

    public PersistenceModule getPersistenceModule() {
        return this.persistenceModule;
    }

    public IdGeneratorModule getIdGeneratorModule() {
        return this.idGeneratorModule;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public LockReleaser getLockReleaser() {
        return this.lockReleaser;
    }

    public Map<Object, Object> getParams() {
        return this.params;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    boolean isBackupSlave() {
        return this.backupSlave;
    }

    Map<Object, Object> getInputParams() {
        return this.inputParams;
    }

    TxEventSyncHookFactory getSyncHookFactory() {
        return this.syncHookFactory;
    }

    public RelationshipTypeCreator getRelationshipTypeCreator() {
        return this.relTypeCreator;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    public RelationshipTypeHolder getRelationshipTypeHolder() {
        return this.graphDbModule.getNodeManager().getRelationshipTypeHolder();
    }

    public static void dumpConfiguration(Map<?, ?> config) {
        for (Object key : config.keySet()) {
            Object value;
            if (!(key instanceof String) || !((value = config.get(key)) instanceof String)) continue;
            System.out.println(key + "=" + value);
        }
    }

    public static boolean configValueContainsMultipleParameters(String configValue) {
        return configValue != null && configValue.contains("=");
    }

    public static Args parseMapFromConfigValue(String name, String configValue) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String part : configValue.split(Pattern.quote(","))) {
            String[] tokens = part.split(Pattern.quote("="));
            if (tokens.length != 2) {
                throw new RuntimeException("Invalid configuration value '" + configValue + "' for " + name + ". The format is [true/false] or [key1=value1,key2=value2...]");
            }
            result.put(tokens[0], tokens[1]);
        }
        return new Args(result);
    }

    public static Object getFromConfig(Map<?, ?> config, Object key, Object defaultValue) {
        Object result = config != null ? config.get(key) : defaultValue;
        return result != null ? result : defaultValue;
    }

    public DiagnosticsManager getDiagnosticsManager() {
        return this.diagnostics;
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, StringLogger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            log.logLongMessage("Neo4j Kernel properties:", (Iterator<String>)new PrefetchingIterator<String>(){
                final Iterator<Object> keys;
                {
                    this.keys = Config.this.params.keySet().iterator();
                }

                @Override
                protected String fetchNextOrNull() {
                    while (this.keys.hasNext()) {
                        Object key = this.keys.next();
                        if (!(key instanceof String)) continue;
                        Object value = Config.this.params.get(key);
                        return key + "=" + value;
                    }
                    return null;
                }
            }, true);
        }
    }

    public KernelPanicEventGenerator getKernelPanicGenerator() {
        return this.kpe;
    }
}

