/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.Primitive;
import org.neo4j.kernel.impl.core.PropertyIndex;
import org.neo4j.kernel.impl.nioneo.store.PropertyData;
import org.neo4j.kernel.impl.util.ArrayMap;

public class GraphProperties
extends Primitive
implements PropertyContainer {
    private final NodeManager nodeManager;
    private Map<Integer, PropertyData> properties;
    private boolean loaded;

    GraphProperties(NodeManager nodeManager) {
        super(false);
        this.nodeManager = nodeManager;
    }

    @Override
    public void setRegisteredSize(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRegisteredSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void updateSize(NodeManager nodeManager) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nodeManager.getGraphDbService();
    }

    @Override
    protected PropertyData changeProperty(NodeManager nodeManager, PropertyData property, Object value) {
        return nodeManager.graphChangeProperty(property, value);
    }

    @Override
    protected PropertyData addProperty(NodeManager nodeManager, PropertyIndex index, Object value) {
        return nodeManager.graphAddProperty(index, value);
    }

    @Override
    protected void removeProperty(NodeManager nodeManager, PropertyData property) {
        nodeManager.graphRemoveProperty(property);
    }

    @Override
    protected ArrayMap<Integer, PropertyData> loadProperties(NodeManager nodeManager, boolean light) {
        return nodeManager.loadGraphProperties(light);
    }

    @Override
    public long getId() {
        return -1L;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.hasProperty(this.nodeManager, key);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(this.nodeManager, key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.getProperty(this.nodeManager, key, defaultValue);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.setProperty(this.nodeManager, this, key, value);
    }

    @Override
    public Object removeProperty(String key) {
        return this.removeProperty(this.nodeManager, this, key);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.getPropertyKeys(this.nodeManager);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.getPropertyValues(this.nodeManager);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    protected void commitPropertyMaps(ArrayMap<Integer, PropertyData> cowPropertyAddMap, ArrayMap<Integer, PropertyData> cowPropertyRemoveMap, long firstProp, NodeManager nodeManager) {
        if (cowPropertyAddMap != null) {
            for (Map.Entry<Integer, PropertyData> property : cowPropertyAddMap.entrySet()) {
                this.properties.put(property.getKey(), property.getValue());
            }
        }
        if (cowPropertyRemoveMap != null) {
            for (Map.Entry<Integer, PropertyData> property : cowPropertyRemoveMap.entrySet()) {
                this.properties.remove(property.getKey());
            }
        }
    }

    @Override
    protected void setEmptyProperties() {
        this.properties = new HashMap<Integer, PropertyData>();
        this.loaded = true;
    }

    @Override
    protected PropertyData[] allProperties() {
        return !this.loaded ? null : this.properties.values().toArray(new PropertyData[this.properties.size()]);
    }

    @Override
    protected PropertyData getPropertyForIndex(int keyId) {
        return this.properties.get(keyId);
    }

    @Override
    protected void setProperties(ArrayMap<Integer, PropertyData> loadedProperties, NodeManager nodeManager) {
        if (loadedProperties != null && loadedProperties.size() > 0) {
            HashMap<Integer, PropertyData> newProperties = new HashMap<Integer, PropertyData>();
            for (Map.Entry<Integer, PropertyData> property : loadedProperties.entrySet()) {
                newProperties.put(property.getKey(), property.getValue());
            }
            this.properties = newProperties;
        } else {
            this.properties = new HashMap<Integer, PropertyData>();
        }
        this.loaded = true;
    }

    @Override
    public LockReleaser.CowEntityElement getEntityElement(LockReleaser.PrimitiveElement element, boolean create) {
        return element.graphElement(create);
    }

    @Override
    PropertyContainer asProxy(NodeManager nm) {
        return this;
    }
}

