/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.AutoConfigurator;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.KernelExtensionLoader;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.NioNeoDbPersistenceSource;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.TxModule;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.FileUtils;

class GraphDbInstance {
    private boolean started = false;
    private final boolean create;
    private String storeDir;
    private final Config config;
    private NioNeoDbPersistenceSource persistenceSource = null;

    GraphDbInstance(String storeDir, boolean create, Config config) {
        this.storeDir = storeDir;
        this.create = create;
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<Object, Object> start(AbstractGraphDatabase graphDb, KernelExtensionLoader kernelExtensionLoader, Caches caches) {
        if (this.started) {
            throw new IllegalStateException("Neo4j instance already started");
        }
        Map<Object, Object> params = this.config.getParams();
        boolean useMemoryMapped = Boolean.parseBoolean((String)this.config.getInputParams().get("use_memory_mapped_buffers"));
        boolean dumpToConsole = Boolean.parseBoolean((String)this.config.getInputParams().get("dump_configuration"));
        this.storeDir = FileUtils.fixSeparatorsInPath(this.storeDir);
        AutoConfigurator autoConfigurator = new AutoConfigurator(this.storeDir, useMemoryMapped, dumpToConsole);
        HashMap<Object, Object> autoConf = new HashMap<Object, Object>();
        autoConfigurator.configure(autoConf);
        for (Map.Entry entry : autoConf.entrySet()) {
            if (this.config.getInputParams().containsKey(entry.getKey())) continue;
            params.put(entry.getKey(), entry.getValue());
        }
        String separator = System.getProperty("file.separator");
        String store = this.storeDir + separator + "neostore";
        params.put("store_dir", this.storeDir);
        params.put("neo_store", store);
        params.put("create", String.valueOf(this.create));
        String logicalLog = this.storeDir + separator + "nioneo_logical.log";
        params.put("logical_log", logicalLog);
        params.put(LockManager.class, this.config.getLockManager());
        params.put(LockReleaser.class, this.config.getLockReleaser());
        kernelExtensionLoader.configureKernelExtensions();
        XaDataSource nioneoDs = this.config.getTxModule().registerDataSource("nioneodb", "org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource", NeoStoreXaDataSource.BRANCH_ID, params);
        boolean success = false;
        try {
            if (!this.config.isReadOnly() || this.config.isBackupSlave()) {
                byte[] luceneId;
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.neo4j.index.lucene.LuceneDataSource");
                    this.cleanWriteLocksInLuceneDirectory(this.storeDir + File.separator + "lucene");
                    luceneId = UTF8.encode("162373");
                    this.registerLuceneDataSource("lucene", clazz.getName(), this.config.getTxModule(), this.storeDir + File.separator + "lucene", this.config.getLockManager(), luceneId, params);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError err) {
                    // empty catch block
                }
                try {
                    clazz = Class.forName("org.neo4j.index.lucene.LuceneFulltextDataSource");
                    this.cleanWriteLocksInLuceneDirectory(this.storeDir + File.separator + "lucene-fulltext");
                    luceneId = UTF8.encode("262374");
                    this.registerLuceneDataSource("lucene-fulltext", clazz.getName(), this.config.getTxModule(), this.storeDir + File.separator + "lucene-fulltext", this.config.getLockManager(), luceneId, params);
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoClassDefFoundError err) {
                    // empty catch block
                }
            }
            this.persistenceSource = new NioNeoDbPersistenceSource();
            this.config.setPersistenceSource("nioneodb", this.create);
            this.config.getIdGeneratorModule().setPersistenceSourceInstance(this.persistenceSource);
            this.config.getTxModule().init();
            this.config.getPersistenceModule().init();
            this.persistenceSource.init();
            this.config.getIdGeneratorModule().init();
            this.config.getGraphDbModule().init();
            kernelExtensionLoader.initializeIndexProviders();
            this.config.getTxModule().start();
            this.config.getPersistenceModule().start(this.config.getTxModule().getTxManager(), this.persistenceSource, this.config.getSyncHookFactory(), this.config.getLockReleaser());
            this.persistenceSource.start(this.config.getTxModule().getXaDataSourceManager());
            this.config.getIdGeneratorModule().start();
            this.config.getGraphDbModule().start(this.config.getLockReleaser(), this.config.getPersistenceModule().getPersistenceManager(), this.config.getRelationshipTypeCreator(), this.config.getDiagnosticsManager(), params, caches);
            this.started = true;
            KernelDiagnostics.register(this.config.getDiagnosticsManager(), graphDb, (NeoStoreXaDataSource)this.persistenceSource.getXaDataSource());
            this.config.getDiagnosticsManager().startup();
            success = true;
            Map<Object, Object> map = Collections.unmodifiableMap(params);
            return map;
        }
        finally {
            if (!success) {
                nioneoDs.close();
            }
        }
    }

    private static Map<Object, Object> subset(Map<Object, Object> source, String ... keys) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (String key : keys) {
            if (!source.containsKey(key)) continue;
            result.put(key, source.get(key));
        }
        return result;
    }

    private void cleanWriteLocksInLuceneDirectory(String luceneDir) {
        File dir = new File(luceneDir);
        if (!dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.cleanWriteLocksInLuceneDirectory(file.getAbsolutePath());
                continue;
            }
            if (!file.getName().equals("write.lock")) continue;
            boolean success = file.delete();
            assert (success);
        }
    }

    private XaDataSource registerLuceneDataSource(String name, String className, TxModule txModule, String luceneDirectory, LockManager lockManager, byte[] resourceId, Map<Object, Object> params) {
        params.put("dir", luceneDirectory);
        params.put(LockManager.class, lockManager);
        return txModule.registerDataSource(name, className, resourceId, params, true);
    }

    public boolean started() {
        return this.started;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.config.getGraphDbModule().stop();
            this.config.getIdGeneratorModule().stop();
            this.persistenceSource.stop();
            this.config.getPersistenceModule().stop();
            this.config.getTxModule().stop();
            this.config.getGraphDbModule().destroy();
            this.config.getIdGeneratorModule().destroy();
            this.persistenceSource.destroy();
            this.config.getPersistenceModule().destroy();
            this.config.getTxModule().destroy();
        }
        this.started = false;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.config.getGraphDbModule().getRelationshipTypes();
    }

    public boolean transactionRunning() {
        try {
            return this.config.getTxModule().getTxManager().getTransaction() != null;
        }
        catch (Exception e) {
            throw new TransactionFailureException("Unable to get transaction.", e);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.config.getTxModule().getTxManager();
    }
}

