/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.helpers.Counter;

final class HitCounter {
    private final Counter hits;
    private final Counter miss;

    public HitCounter(Counter hits, Counter miss) {
        this.hits = hits;
        this.miss = miss;
    }

    public <T> T count(T item) {
        (item == null ? this.miss : this.hits).inc();
        return item;
    }

    public long getHitsCount() {
        return this.hits.count();
    }

    public long getMissCount() {
        return this.miss.count();
    }

    public static HitCounter create() {
        return new HitCounter(Counter.atomic(), Counter.atomic());
    }
}

