/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.TransactionBuilder;

public final class EmbeddedGraphDatabase
extends AbstractGraphDatabase {
    private final EmbeddedGraphDbImpl graphDbImpl;

    public EmbeddedGraphDatabase(String storeDir) {
        this(storeDir, new HashMap<String, String>());
    }

    public EmbeddedGraphDatabase(String storeDir, Map<String, String> params) {
        super(storeDir);
        this.graphDbImpl = new EmbeddedGraphDbImpl(this.getStoreDir(), null, params, this, CommonFactories.defaultLockManagerFactory(), CommonFactories.defaultIdGeneratorFactory(), CommonFactories.defaultRelationshipTypeCreator(), CommonFactories.defaultTxIdGeneratorFactory(), CommonFactories.defaultTxHook(), CommonFactories.defaultLastCommittedTxIdSetter(), CommonFactories.defaultFileSystemAbstraction());
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDbImpl.loadConfigurations(file);
    }

    @Override
    public Node createNode() {
        return this.graphDbImpl.createNode();
    }

    @Override
    public Node getNodeById(long id) {
        return this.graphDbImpl.getNodeById(id);
    }

    @Override
    public Relationship getRelationshipById(long id) {
        return this.graphDbImpl.getRelationshipById(id);
    }

    @Override
    public Node getReferenceNode() {
        return this.graphDbImpl.getReferenceNode();
    }

    @Override
    protected void close() {
        this.graphDbImpl.shutdown();
    }

    @Override
    public TransactionBuilder tx() {
        return this.graphDbImpl.tx();
    }

    @Override
    public Config getConfig() {
        return this.graphDbImpl.getConfig();
    }

    @Override
    public <T> Collection<T> getManagementBeans(Class<T> type) {
        return this.graphDbImpl.getManagementBeans(type);
    }

    @Override
    public KernelData getKernelData() {
        return this.graphDbImpl.getKernelData();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.graphDbImpl.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.graphDbImpl.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.graphDbImpl.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.graphDbImpl.unregisterTransactionEventHandler(handler);
    }

    @Override
    public IndexManager index() {
        return this.graphDbImpl.index();
    }
}

