/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.kernel.Expansion;

public abstract class StandardExpander
implements Expander {
    public static final StandardExpander DEFAULT = new AllExpander(Direction.BOTH){

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            return 1.create(type, direction);
        }
    };

    private StandardExpander() {
    }

    public final Expansion<Relationship> expand(Node start) {
        return new RelationshipExpansion(this, start);
    }

    static <T> T[] append(T[] array, T item) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = item;
        return result;
    }

    private static <T> T[] extract(Class<T[]> type, T obj1, T obj2, Object[] more, boolean odd) {
        if (more.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        Object[] target = (Object[])Array.newInstance(type.getComponentType(), more.length / 2 + 2);
        try {
            target[0] = obj1;
            target[1] = obj2;
            for (int i = 2; i < target.length; ++i) {
                target[i] = more[(i - 2) * 2 + (odd ? 1 : 0)];
            }
        }
        catch (ArrayStoreException cast) {
            throw new IllegalArgumentException(cast);
        }
        return type.cast(target);
    }

    static boolean matchDirection(Direction dir, Node start, Relationship rel) {
        switch (dir) {
            case INCOMING: {
                return rel.getEndNode().equals(start);
            }
            case OUTGOING: {
                return rel.getStartNode().equals(start);
            }
        }
        return true;
    }

    abstract Iterator<Relationship> doExpand(Node var1);

    public final String toString() {
        StringBuilder result = new StringBuilder("Expander[");
        this.buildString(result);
        result.append("]");
        return result.toString();
    }

    abstract void buildString(StringBuilder var1);

    @Override
    public final StandardExpander add(RelationshipType type) {
        return this.add(type, Direction.BOTH);
    }

    @Override
    public abstract StandardExpander add(RelationshipType var1, Direction var2);

    @Override
    public abstract StandardExpander remove(RelationshipType var1);

    @Override
    public abstract StandardExpander reversed();

    @Override
    public StandardExpander addNodeFilter(Predicate<? super Node> filter) {
        return new FilteringExpander(this, new NodeFilter(filter));
    }

    @Override
    public StandardExpander addRelationshipFilter(Predicate<? super Relationship> filter) {
        return new FilteringExpander(this, new RelationshipFilter(filter));
    }

    @Override
    public StandardExpander addRelationsipFilter(Predicate<? super Relationship> filter) {
        return this.addRelationshipFilter((Predicate)filter);
    }

    static StandardExpander wrap(RelationshipExpander expander) {
        return new WrappingExpander(expander);
    }

    static Expander create(Direction direction) {
        return new AllExpander(direction);
    }

    static StandardExpander create(RelationshipType type, Direction dir) {
        EnumMap<Direction, RelationshipType[]> types = new EnumMap<Direction, RelationshipType[]>(Direction.class);
        types.put(dir, new RelationshipType[]{type});
        return new RegularExpander(types);
    }

    static StandardExpander create(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2) {
        Map<Direction, Collection<RelationshipType>> tempMap = StandardExpander.temporaryTypeMap();
        tempMap.get((Object)dir1).add(type1);
        tempMap.get((Object)dir2).add(type2);
        return new RegularExpander(StandardExpander.toTypeMap(tempMap));
    }

    private static Map<Direction, RelationshipType[]> toTypeMap(Map<Direction, Collection<RelationshipType>> tempMap) {
        Collection<RelationshipType> both = tempMap.get((Object)Direction.BOTH);
        tempMap.get((Object)Direction.OUTGOING).removeAll(both);
        tempMap.get((Object)Direction.INCOMING).removeAll(both);
        EnumMap<Direction, RelationshipType[]> map = new EnumMap<Direction, RelationshipType[]>(Direction.class);
        for (Map.Entry<Direction, Collection<RelationshipType>> entry : tempMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            map.put(entry.getKey(), entry.getValue().toArray(new RelationshipType[entry.getValue().size()]));
        }
        return map;
    }

    private static Map<Direction, Collection<RelationshipType>> temporaryTypeMap() {
        EnumMap<Direction, Collection<RelationshipType>> map = new EnumMap<Direction, Collection<RelationshipType>>(Direction.class);
        for (Direction direction : Direction.values()) {
            map.put(direction, new ArrayList());
        }
        return map;
    }

    private static Map<Direction, Collection<RelationshipType>> temporaryTypeMapFrom(Map<Direction, RelationshipType[]> typeMap) {
        EnumMap<Direction, Collection<RelationshipType>> map = new EnumMap<Direction, Collection<RelationshipType>>(Direction.class);
        for (Direction direction : Direction.values()) {
            ArrayList<RelationshipType> types = new ArrayList<RelationshipType>();
            map.put(direction, types);
            RelationshipType[] existing = typeMap.get((Object)direction);
            if (existing == null) continue;
            types.addAll(Arrays.asList(existing));
        }
        return map;
    }

    static StandardExpander create(RelationshipType type1, Direction dir1, RelationshipType type2, Direction dir2, Object ... more) {
        Map<Direction, Collection<RelationshipType>> tempMap = StandardExpander.temporaryTypeMap();
        tempMap.get((Object)dir1).add(type1);
        tempMap.get((Object)dir2).add(type2);
        for (int i = 0; i < more.length; ++i) {
            RelationshipType type = (RelationshipType)more[i++];
            Direction direction = (Direction)((Object)more[i]);
            tempMap.get((Object)direction).add(type);
        }
        return new RegularExpander(StandardExpander.toTypeMap(tempMap));
    }

    private static final class RelationshipFilter
    extends Filter {
        private final Predicate<? super Relationship> predicate;

        RelationshipFilter(Predicate<? super Relationship> predicate) {
            this.predicate = predicate;
        }

        public String toString() {
            return this.predicate.toString();
        }

        @Override
        boolean exclude(Node start, Relationship item) {
            return !this.predicate.accept(item);
        }
    }

    private static final class NodeFilter
    extends Filter {
        private final Predicate<? super Node> predicate;

        NodeFilter(Predicate<? super Node> predicate) {
            this.predicate = predicate;
        }

        public String toString() {
            return this.predicate.toString();
        }

        @Override
        boolean exclude(Node start, Relationship item) {
            return !this.predicate.accept(item.getOtherNode(start));
        }
    }

    private static abstract class Filter {
        private Filter() {
        }

        abstract boolean exclude(Node var1, Relationship var2);
    }

    private static final class WrappingExpander
    extends StandardExpander {
        private static final String IMMUTABLE = "Immutable Expander ";
        private final RelationshipExpander expander;

        WrappingExpander(RelationshipExpander expander) {
            this.expander = expander;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append(this.expander);
        }

        @Override
        Iterator<Relationship> doExpand(Node start) {
            return this.expander.expand(start).iterator();
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }

        @Override
        public StandardExpander reversed() {
            throw new UnsupportedOperationException(IMMUTABLE + this.expander);
        }
    }

    private static final class TypeLimitingExpander
    extends StandardExpander {
        private final StandardExpander expander;
        private final Map<String, Direction> exclusion;

        TypeLimitingExpander(StandardExpander expander, Map<String, Direction> exclusion) {
            this.expander = expander;
            this.exclusion = exclusion;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append("*");
            for (Map.Entry<String, Direction> entry : this.exclusion.entrySet()) {
                result.append(",!");
                if (entry.getValue() != Direction.BOTH) {
                    result.append(entry.getValue().name());
                    result.append(":");
                }
                result.append(entry.getKey());
            }
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            HashMap<String, Direction> newExclusion;
            Direction excluded = this.exclusion.get(type.name());
            if (excluded == null) {
                return this;
            }
            if (excluded == direction || direction == Direction.BOTH) {
                if (this.exclusion.size() == 1) {
                    return this.expander;
                }
                newExclusion = new HashMap<String, Direction>(this.exclusion);
                newExclusion.remove(type.name());
            } else {
                newExclusion = new HashMap<String, Direction>(this.exclusion);
                newExclusion.put(type.name(), direction.reverse());
            }
            return new TypeLimitingExpander(this.expander, newExclusion);
        }

        @Override
        Iterator<Relationship> doExpand(final Node start) {
            return new FilteringIterator<Relationship>(start.getRelationships().iterator(), new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship item) {
                    Direction dir = (Direction)((Object)TypeLimitingExpander.this.exclusion.get(item.getType().name()));
                    return !StandardExpander.matchDirection(dir, start, item);
                }
            });
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            Direction excluded = this.exclusion.get(type.name());
            if (excluded == Direction.BOTH) {
                return this;
            }
            HashMap<String, Direction> newExclusion = new HashMap<String, Direction>(this.exclusion);
            newExclusion.put(type.name(), Direction.BOTH);
            return new TypeLimitingExpander(this.expander, newExclusion);
        }

        @Override
        public StandardExpander reversed() {
            HashMap<String, Direction> newExclusion = new HashMap<String, Direction>();
            for (Map.Entry<String, Direction> entry : this.exclusion.entrySet()) {
                newExclusion.put(entry.getKey(), entry.getValue().reverse());
            }
            return new TypeLimitingExpander(this.expander, newExclusion);
        }
    }

    private static final class FilteringExpander
    extends StandardExpander {
        private final StandardExpander expander;
        private final Filter[] filters;

        FilteringExpander(StandardExpander expander, Filter ... filters) {
            this.expander = expander;
            this.filters = filters;
        }

        @Override
        void buildString(StringBuilder result) {
            this.expander.buildString(result);
            result.append("; filter:");
            for (Filter filter : this.filters) {
                result.append(" ");
                result.append(filter);
            }
        }

        @Override
        Iterator<Relationship> doExpand(final Node start) {
            return new FilteringIterator<Relationship>(this.expander.doExpand(start), new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship item) {
                    for (Filter filter : FilteringExpander.this.filters) {
                        if (!filter.exclude(start, item)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        @Override
        public StandardExpander addNodeFilter(Predicate<? super Node> filter) {
            return new FilteringExpander(this.expander, FilteringExpander.append(this.filters, new NodeFilter(filter)));
        }

        @Override
        public StandardExpander addRelationshipFilter(Predicate<? super Relationship> filter) {
            return new FilteringExpander(this.expander, FilteringExpander.append(this.filters, new RelationshipFilter(filter)));
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            return new FilteringExpander(this.expander.add(type, direction), this.filters);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            return new FilteringExpander(this.expander.remove(type), this.filters);
        }

        @Override
        public StandardExpander reversed() {
            return new FilteringExpander(this.expander.reversed(), this.filters);
        }
    }

    static class RegularExpander
    extends StandardExpander {
        final Map<Direction, RelationshipType[]> types;

        RegularExpander(Map<Direction, RelationshipType[]> types) {
            this.types = types;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append(this.types.toString());
        }

        @Override
        Iterator<Relationship> doExpand(final Node start) {
            if (this.types.isEmpty()) {
                return start.getRelationships().iterator();
            }
            if (this.types.size() == 1) {
                Map.Entry<Direction, RelationshipType[]> entry = this.types.entrySet().iterator().next();
                return start.getRelationships(entry.getKey(), entry.getValue()).iterator();
            }
            return new NestingIterator<Relationship, Map.Entry<Direction, RelationshipType[]>>(this.types.entrySet().iterator()){

                @Override
                protected Iterator<Relationship> createNestedIterator(Map.Entry<Direction, RelationshipType[]> item) {
                    return start.getRelationships(item.getKey(), item.getValue()).iterator();
                }
            };
        }

        StandardExpander createNew(Map<Direction, RelationshipType[]> types) {
            return new RegularExpander(types);
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            Map tempMap = StandardExpander.temporaryTypeMapFrom(this.types);
            ((Collection)tempMap.get((Object)direction)).add(type);
            return this.createNew(StandardExpander.toTypeMap(tempMap));
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            Map tempMap = StandardExpander.temporaryTypeMapFrom(this.types);
            for (Direction direction : Direction.values()) {
                ((Collection)tempMap.get((Object)direction)).remove(type);
            }
            return this.createNew(StandardExpander.toTypeMap(tempMap));
        }

        @Override
        public StandardExpander reversed() {
            Map tempMap = StandardExpander.temporaryTypeMapFrom(this.types);
            Collection out = (Collection)tempMap.get((Object)Direction.OUTGOING);
            Collection in = (Collection)tempMap.get((Object)Direction.INCOMING);
            tempMap.put(Direction.OUTGOING, in);
            tempMap.put(Direction.INCOMING, out);
            return this.createNew(StandardExpander.toTypeMap(tempMap));
        }
    }

    private static final class ExcludingExpander
    extends StandardExpander {
        private final Exclusion defaultExclusion;
        private final Map<String, Exclusion> exclusion;

        ExcludingExpander(Exclusion defaultExclusion, Map<String, Exclusion> exclusion) {
            this.defaultExclusion = defaultExclusion;
            this.exclusion = exclusion;
        }

        @Override
        void buildString(StringBuilder result) {
            result.append((Object)this.defaultExclusion);
            result.append("*");
            for (Map.Entry<String, Exclusion> entry : this.exclusion.entrySet()) {
                result.append(",");
                result.append((Object)entry.getValue());
                result.append(entry.getKey());
            }
        }

        @Override
        Iterator<Relationship> doExpand(final Node start) {
            return new FilteringIterator<Relationship>(start.getRelationships().iterator(), new Predicate<Relationship>(){

                @Override
                public boolean accept(Relationship rel) {
                    Exclusion exclude = (Exclusion)((Object)ExcludingExpander.this.exclusion.get(rel.getType().name()));
                    exclude = exclude == null ? ExcludingExpander.this.defaultExclusion : exclude;
                    return exclude.accept(start, rel);
                }
            });
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction direction) {
            HashMap<String, Exclusion> newExclusion;
            Exclusion excluded = this.exclusion.get(type.name());
            if ((excluded == null ? this.defaultExclusion : excluded).includes(direction)) {
                return this;
            }
            excluded = Exclusion.include(direction);
            if (excluded == this.defaultExclusion) {
                if (this.exclusion.size() == 1) {
                    return new AllExpander(this.defaultExclusion.direction);
                }
                newExclusion = new HashMap<String, Exclusion>(this.exclusion);
                newExclusion.remove(type.name());
            } else {
                newExclusion = new HashMap<String, Exclusion>(this.exclusion);
                newExclusion.put(type.name(), excluded);
            }
            return new ExcludingExpander(this.defaultExclusion, newExclusion);
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            Exclusion excluded = this.exclusion.get(type.name());
            if (excluded == Exclusion.ALL) {
                return this;
            }
            HashMap<String, Exclusion> newExclusion = new HashMap<String, Exclusion>(this.exclusion);
            newExclusion.put(type.name(), Exclusion.ALL);
            return new ExcludingExpander(this.defaultExclusion, newExclusion);
        }

        @Override
        public StandardExpander reversed() {
            HashMap<String, Exclusion> newExclusion = new HashMap<String, Exclusion>();
            for (Map.Entry<String, Exclusion> entry : this.exclusion.entrySet()) {
                newExclusion.put(entry.getKey(), entry.getValue().reversed());
            }
            return new ExcludingExpander(this.defaultExclusion.reversed(), newExclusion);
        }
    }

    private static enum Exclusion {
        ALL(null, "!"){

            @Override
            public boolean accept(Node start, Relationship rel) {
                return false;
            }
        }
        ,
        INCOMING(Direction.OUTGOING){

            @Override
            Exclusion reversed() {
                return OUTGOING;
            }
        }
        ,
        OUTGOING(Direction.INCOMING){

            @Override
            Exclusion reversed() {
                return INCOMING;
            }
        }
        ,
        NONE(Direction.BOTH, ""){

            @Override
            boolean includes(Direction direction) {
                return true;
            }
        };

        private final String string;
        private final Direction direction;

        private Exclusion(Direction direction, String string2) {
            this.direction = direction;
            this.string = string2;
        }

        private Exclusion(Direction direction) {
            this.direction = direction;
            this.string = "!" + this.name() + ":";
        }

        public final String toString() {
            return this.string;
        }

        boolean accept(Node start, Relationship rel) {
            return StandardExpander.matchDirection(this.direction, start, rel);
        }

        Exclusion reversed() {
            return this;
        }

        boolean includes(Direction dir) {
            return this.direction == dir;
        }

        static Exclusion include(Direction direction) {
            switch (direction) {
                case INCOMING: {
                    return OUTGOING;
                }
                case OUTGOING: {
                    return INCOMING;
                }
            }
            return NONE;
        }
    }

    private static class AllExpander
    extends StandardExpander {
        private final Direction direction;

        AllExpander(Direction direction) {
            this.direction = direction;
        }

        @Override
        void buildString(StringBuilder result) {
            if (this.direction != Direction.BOTH) {
                result.append((Object)this.direction);
                result.append(":");
            }
            result.append("*");
        }

        @Override
        Iterator<Relationship> doExpand(Node start) {
            return this.direction == Direction.BOTH ? start.getRelationships().iterator() : start.getRelationships(this.direction).iterator();
        }

        @Override
        public StandardExpander add(RelationshipType type, Direction dir) {
            return this;
        }

        @Override
        public StandardExpander remove(RelationshipType type) {
            HashMap<String, Exclusion> exclude = new HashMap<String, Exclusion>();
            exclude.put(type.name(), Exclusion.ALL);
            return new ExcludingExpander(Exclusion.include(this.direction), exclude);
        }

        @Override
        public StandardExpander reversed() {
            return new AllExpander(this.direction.reverse());
        }
    }

    private static final class PairExpansion
    extends StandardExpansion<Pair<Relationship, Node>> {
        PairExpansion(StandardExpander expander, Node start) {
            super(expander, start);
        }

        public String toString() {
            return this.stringRepresentation("pairs");
        }

        @Override
        StandardExpansion<Pair<Relationship, Node>> createNew(StandardExpander expander) {
            return new PairExpansion(expander, this.start);
        }

        @Override
        public StandardExpansion<Pair<Relationship, Node>> pairs() {
            return this;
        }

        @Override
        public Iterator<Pair<Relationship, Node>> iterator() {
            return new IteratorWrapper<Pair<Relationship, Node>, Relationship>(this.expander.doExpand(this.start)){

                @Override
                protected Pair<Relationship, Node> underlyingObjectToObject(Relationship rel) {
                    return Pair.of(rel, rel.getOtherNode(PairExpansion.this.start));
                }
            };
        }
    }

    private static final class NodeExpansion
    extends StandardExpansion<Node> {
        NodeExpansion(StandardExpander expander, Node start) {
            super(expander, start);
        }

        public String toString() {
            return this.stringRepresentation("nodes");
        }

        @Override
        StandardExpansion<Node> createNew(StandardExpander expander) {
            return new NodeExpansion(expander, this.start);
        }

        @Override
        public StandardExpansion<Node> nodes() {
            return this;
        }

        @Override
        public Iterator<Node> iterator() {
            return new IteratorWrapper<Node, Relationship>(this.expander.doExpand(this.start)){

                @Override
                protected Node underlyingObjectToObject(Relationship rel) {
                    return rel.getOtherNode(NodeExpansion.this.start);
                }
            };
        }
    }

    private static final class RelationshipExpansion
    extends StandardExpansion<Relationship> {
        RelationshipExpansion(StandardExpander expander, Node start) {
            super(expander, start);
        }

        public String toString() {
            return this.stringRepresentation("relationships");
        }

        @Override
        StandardExpansion<Relationship> createNew(StandardExpander expander) {
            return new RelationshipExpansion(expander, this.start);
        }

        @Override
        public StandardExpansion<Relationship> relationships() {
            return this;
        }

        @Override
        public Iterator<Relationship> iterator() {
            return this.expander.doExpand(this.start);
        }
    }

    static abstract class StandardExpansion<T>
    implements Expansion<T> {
        final StandardExpander expander;
        final Node start;

        StandardExpansion(StandardExpander expander, Node start) {
            this.expander = expander;
            this.start = start;
        }

        String stringRepresentation(String nodesORrelationships) {
            return "Expansion[" + this.start + ".expand( " + this.expander + " )." + nodesORrelationships + "()]";
        }

        abstract StandardExpansion<T> createNew(StandardExpander var1);

        @Override
        public StandardExpansion<T> including(RelationshipType type) {
            return this.createNew(this.expander.add(type));
        }

        @Override
        public StandardExpansion<T> including(RelationshipType type, Direction direction) {
            return this.createNew(this.expander.add(type, direction));
        }

        @Override
        public StandardExpansion<T> excluding(RelationshipType type) {
            return this.createNew(this.expander.remove(type));
        }

        @Override
        public StandardExpander expander() {
            return this.expander;
        }

        @Override
        public StandardExpansion<T> filterNodes(Predicate<? super Node> filter) {
            return this.createNew((StandardExpander)this.expander.addNodeFilter((Predicate)filter));
        }

        @Override
        public StandardExpansion<T> filterRelationships(Predicate<? super Relationship> filter) {
            return this.createNew((StandardExpander)this.expander.addRelationshipFilter((Predicate)filter));
        }

        @Override
        public T getSingle() {
            Iterator expanded = this.iterator();
            if (expanded.hasNext()) {
                Object result = expanded.next();
                if (expanded.hasNext()) {
                    throw new NotFoundException("More than one relationship found for " + this);
                }
                return result;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return !this.expander.doExpand(this.start).hasNext();
        }

        public StandardExpansion<Node> nodes() {
            return new NodeExpansion(this.expander, this.start);
        }

        public StandardExpansion<Relationship> relationships() {
            return new RelationshipExpansion(this.expander, this.start);
        }

        public StandardExpansion<Pair<Relationship, Node>> pairs() {
            return new PairExpansion(this.expander, this.start);
        }
    }
}

