/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.BufferedReadableByteChannel;
import org.neo4j.kernel.impl.transaction.xaframework.CloseableByteBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;

public class DefaultLogBufferFactory
implements LogBufferFactory {
    @Override
    public LogBuffer create(FileChannel fileChannel) throws IOException {
        return new DirectMappedLogBuffer(fileChannel);
    }

    @Override
    public FileChannel combine(FileChannel fileChannel, LogBuffer logBuffer) throws IOException {
        CloseableByteBuffer byteBuffer = ((DirectMappedLogBuffer)logBuffer).getBuffer();
        byteBuffer.flip();
        return new BufferedReadableByteChannel(fileChannel, byteBuffer);
    }
}

