/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;

public class UpgradableDatabase {
    private Map<String, String> fileNamesToExpectedVersions = new HashMap<String, String>();

    public UpgradableDatabase() {
        this.fileNamesToExpectedVersions.put("neostore", "NeoStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.nodestore.db", "NodeStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.propertystore.db", "PropertyStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.propertystore.db.arrays", "ArrayPropertyStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.propertystore.db.index", "PropertyIndex v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.propertystore.db.index.keys", "StringPropertyStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.propertystore.db.strings", "StringPropertyStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.relationshipstore.db", "RelationshipStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.relationshiptypestore.db", "RelationshipTypeStore v0.9.9");
        this.fileNamesToExpectedVersions.put("neostore.relationshiptypestore.db.names", "StringPropertyStore v0.9.9");
    }

    public void checkUpgradeable(File neoStoreFile) {
        if (!this.storeFilesUpgradeable(neoStoreFile)) {
            throw new StoreUpgrader.UnableToUpgradeException("Not all store files match the version required for successful upgrade");
        }
    }

    public boolean storeFilesUpgradeable(File neoStoreFile) {
        File storeDirectory = neoStoreFile.getParentFile();
        for (String fileName : this.fileNamesToExpectedVersions.keySet()) {
            boolean bl;
            String expectedVersion = this.fileNamesToExpectedVersions.get(fileName);
            AbstractInterruptibleChannel fileChannel = null;
            byte[] expectedVersionBytes = UTF8.encode(expectedVersion);
            try {
                File storeFile = new File(storeDirectory, fileName);
                if (!storeFile.exists()) {
                    boolean bl2 = false;
                    return bl2;
                }
                fileChannel = new RandomAccessFile(storeFile, "r").getChannel();
                ((FileChannel)fileChannel).position(((FileChannel)fileChannel).size() - (long)expectedVersionBytes.length);
                byte[] foundVersionBytes = new byte[expectedVersionBytes.length];
                ((FileChannel)fileChannel).read(ByteBuffer.wrap(foundVersionBytes));
                if (expectedVersion.equals(UTF8.decode(foundVersionBytes))) continue;
                bl = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (fileChannel == null) continue;
                try {
                    fileChannel.close();
                    continue;
                }
                catch (IOException e) {}
            }
            return bl;
        }
        return true;
    }
}

