/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;
import org.neo4j.kernel.impl.util.Bits;

public class DynamicArrayStore
extends AbstractDynamicStore {
    static final String VERSION = "ArrayPropertyStore v0.A.0";
    public static final String TYPE_DESCRIPTOR = "ArrayPropertyStore";

    public DynamicArrayStore(String fileName, Map<?, ?> config, IdType idType) {
        super(fileName, config, idType);
    }

    @Override
    public String getTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    public static void createStore(String fileName, int blockSize, IdGeneratorFactory idGeneratorFactory) {
        DynamicArrayStore.createEmptyStore(fileName, blockSize, VERSION, idGeneratorFactory, IdType.ARRAY_BLOCK);
    }

    private Collection<DynamicRecord> allocateFromNumbers(long startBlock, Object array) {
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            throw new IllegalArgumentException(array + " not a valid array type.");
        }
        int arrayLength = Array.getLength(array);
        int requiredBits = type.calculateRequiredBitsForArray(array);
        int totalBits = requiredBits * arrayLength;
        int bytes = (totalBits - 1) / 8 + 1;
        int bitsUsedInLastByte = totalBits % 8;
        bitsUsedInLastByte = bitsUsedInLastByte == 0 ? 8 : bitsUsedInLastByte;
        Bits bits = Bits.bits(bytes += 3);
        bits.put((byte)type.intValue());
        bits.put((byte)bitsUsedInLastByte);
        bits.put((byte)requiredBits);
        int length = arrayLength;
        for (int i = 0; i < length; ++i) {
            type.put(Array.get(array, i), bits, requiredBits);
        }
        return this.allocateRecords(startBlock, bits.asBytes());
    }

    private Collection<DynamicRecord> allocateFromString(long startBlock, String[] array) {
        ArrayList<byte[]> stringsAsBytes = new ArrayList<byte[]>();
        int totalBytesRequired = 5;
        for (String string : array) {
            byte[] bytes = PropertyStore.encodeString(string);
            stringsAsBytes.add(bytes);
            totalBytesRequired += 4 + bytes.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalBytesRequired);
        buf.put(PropertyType.STRING.byteValue());
        buf.putInt(array.length);
        for (byte[] stringAsBytes : stringsAsBytes) {
            buf.putInt(stringAsBytes.length);
            buf.put(stringAsBytes);
        }
        return this.allocateRecords(startBlock, buf.array());
    }

    public Collection<DynamicRecord> allocateRecords(long startBlock, Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array + " not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type.equals(String.class)) {
            return this.allocateFromString(startBlock, (String[])array);
        }
        return this.allocateFromNumbers(startBlock, array);
    }

    public Object getRightArray(byte[] bArray) {
        byte typeId = bArray[0];
        if (typeId == PropertyType.STRING.intValue()) {
            ByteBuffer buf = ByteBuffer.wrap(bArray);
            buf.get();
            int arrayLength = buf.getInt();
            String[] result = new String[arrayLength];
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = buf.getInt();
                byte[] stringByteArray = new byte[byteLength];
                buf.get(stringByteArray);
                result[i] = (String)PropertyStore.getStringFor(stringByteArray);
            }
            return result;
        }
        ShortArray type = ShortArray.typeOf(typeId);
        Bits bits = Bits.bitsFromBytes(bArray);
        bits.getByte();
        byte bitsUsedInLastByte = bits.getByte();
        byte requiredBits = bits.getByte();
        if (requiredBits == 0) {
            return type.createArray(0);
        }
        int length = ((bArray.length - 3) * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
        Object result = type.createArray(length);
        for (int i = 0; i < length; ++i) {
            type.get(result, i, bits, requiredBits);
        }
        return result;
    }
}

