/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.cache.HitCounter;
import org.neo4j.kernel.impl.cache.ReferenceCache;
import org.neo4j.kernel.impl.cache.WeakReferenceQueue;
import org.neo4j.kernel.impl.cache.WeakValue;

public class WeakLruCache<K, V>
extends ReferenceCache<K, V> {
    private final ConcurrentHashMap<K, WeakValue<K, V>> cache = new ConcurrentHashMap();
    private final WeakReferenceQueue<K, V> refQueue = new WeakReferenceQueue();
    private final String name;
    private final HitCounter counter = HitCounter.create();

    public WeakLruCache(String name) {
        this.name = name;
    }

    @Override
    public void put(K key, V value) {
        WeakValue<K, WeakValue> ref = new WeakValue<K, WeakValue>(key, (WeakValue)value, this.refQueue);
        this.cache.put(key, ref);
        this.pollClearedValues();
    }

    @Override
    public void putAll(Map<K, V> map) {
        HashMap<K, WeakValue<K, WeakValue>> softMap = new HashMap<K, WeakValue<K, WeakValue>>(map.size() * 2);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            WeakValue<K, WeakValue> ref = new WeakValue<K, WeakValue>(entry.getKey(), (WeakValue)entry.getValue(), this.refQueue);
            softMap.put(entry.getKey(), ref);
        }
        this.cache.putAll(softMap);
        this.pollClearedValues();
    }

    @Override
    public V get(K key) {
        WeakReference ref = this.cache.get(key);
        if (ref != null) {
            if (ref.get() == null) {
                this.cache.remove(key);
            }
            return (V)this.counter.count(ref.get());
        }
        return this.counter.count(null);
    }

    @Override
    public V remove(K key) {
        WeakReference ref = this.cache.remove(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    protected void pollClearedValues() {
        WeakValue<K, V> clearedValue = this.refQueue.safePoll();
        while (clearedValue != null) {
            this.cache.remove(clearedValue.key);
            clearedValue = this.refQueue.safePoll();
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public long hitCount() {
        return this.counter.getHitsCount();
    }

    @Override
    public long missCount() {
        return this.counter.getMissCount();
    }

    @Override
    public void elementCleaned(V value) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAdaptive() {
        return true;
    }

    @Override
    public int maxSize() {
        return -1;
    }

    @Override
    public void resize(int newSize) {
    }

    @Override
    public void setAdaptiveStatus(boolean status) {
    }
}

