/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.Stack;
import org.neo4j.graphdb.NotFoundException;

public class FileUtils {
    private static int WINDOWS_RETRY_COUNT = 3;

    public static void deleteRecursively(File directory) throws IOException {
        Stack<File> stack = new Stack<File>();
        LinkedList<File> temp = new LinkedList<File>();
        stack.push(directory.getAbsoluteFile());
        while (!stack.isEmpty()) {
            File top = (File)stack.pop();
            if (top.listFiles() != null) {
                for (File child : top.listFiles()) {
                    if (child.isFile()) {
                        if (FileUtils.deleteFile(child)) continue;
                        throw new IOException("Failed to delete " + child.getCanonicalPath());
                    }
                    temp.add(child);
                }
            }
            if (top.listFiles() == null || top.listFiles().length == 0) {
                if (!FileUtils.deleteFile(top)) {
                    throw new IOException("Failed to delete " + top.getCanonicalPath());
                }
            } else {
                stack.push(top);
                for (File f : temp) {
                    stack.push(f);
                }
            }
            temp.clear();
        }
    }

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        int count = 0;
        boolean deleted = false;
        do {
            if (deleted = file.delete()) continue;
            ++count;
            FileUtils.waitSome();
        } while (!deleted && count <= WINDOWS_RETRY_COUNT);
        return deleted;
    }

    public static boolean renameFile(File srcFile, File renameToFile) {
        if (!srcFile.exists()) {
            throw new NotFoundException("Source file[" + srcFile.getName() + "] not found");
        }
        if (renameToFile.exists()) {
            throw new NotFoundException("Target file[" + renameToFile.getName() + "] already exists");
        }
        int count = 0;
        boolean renamed = false;
        do {
            if (renamed = srcFile.renameTo(renameToFile)) continue;
            ++count;
            FileUtils.waitSome();
        } while (!renamed && count <= WINDOWS_RETRY_COUNT);
        return renamed;
    }

    public static void truncateFile(FileChannel fileChannel, long position) throws IOException {
        int count = 0;
        boolean success = false;
        IOException cause = null;
        do {
            ++count;
            try {
                fileChannel.truncate(position);
                success = true;
            }
            catch (IOException e) {
                cause = e;
            }
        } while (!success && count <= WINDOWS_RETRY_COUNT);
        if (!success) {
            throw cause;
        }
    }

    private static void waitSome() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ee) {
            Thread.interrupted();
        }
        System.gc();
    }

    public static String fixSeparatorsInPath(String path) {
        String fileSeparator = System.getProperty("file.separator");
        if ("\\".equals(fileSeparator)) {
            path = path.replace('/', '\\');
        } else if ("/".equals(fileSeparator)) {
            path = path.replace('\\', '/');
        }
        return path;
    }
}

