/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractAutoIndexerImpl;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.NodeAutoIndexerImpl;
import org.neo4j.kernel.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.index.IndexXaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

class IndexManagerImpl
implements IndexManager {
    private final IndexStore indexStore;
    private final Map<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();
    private final EmbeddedGraphDbImpl graphDbImpl;
    private final NodeAutoIndexerImpl nodeAutoIndexer;
    private final RelationshipAutoIndexerImpl relAutoIndexer;

    IndexManagerImpl(EmbeddedGraphDbImpl graphDbImpl, IndexStore indexStore) {
        this.graphDbImpl = graphDbImpl;
        this.indexStore = indexStore;
        this.nodeAutoIndexer = new NodeAutoIndexerImpl(graphDbImpl);
        this.relAutoIndexer = new RelationshipAutoIndexerImpl(graphDbImpl);
    }

    void start() {
        this.nodeAutoIndexer.start();
        this.relAutoIndexer.start();
    }

    private IndexImplementation getIndexProvider(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException("No 'provider' given in configuration map");
        }
        Map<String, IndexImplementation> map = this.indexProviders;
        synchronized (map) {
            IndexImplementation result = this.indexProviders.get(provider);
            if (result != null) {
                return result;
            }
            throw new IllegalArgumentException("No index provider '" + provider + "' found");
        }
    }

    void addProvider(String name, IndexImplementation provider) {
        this.indexProviders.put(name, provider);
    }

    private Pair<Map<String, String>, Boolean> findIndexConfig(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> suppliedConfig, Map<?, ?> dbConfig) {
        Map<String, String> storedConfig = this.indexStore.get(cls, indexName);
        if (storedConfig != null && suppliedConfig == null) {
            Map<String, String> newConfig = this.injectDefaultProviderIfMissing(cls, indexName, dbConfig, storedConfig);
            if (newConfig != storedConfig) {
                this.indexStore.set(cls, indexName, newConfig);
            }
            return Pair.of(newConfig, Boolean.FALSE);
        }
        Map<String, String> configToUse = suppliedConfig;
        String provider = null;
        IndexImplementation indexProvider = null;
        if (configToUse == null) {
            provider = this.getDefaultProvider(indexName, dbConfig);
            configToUse = MapUtil.stringMap("provider", provider);
        } else {
            provider = configToUse.get("provider");
            provider = provider == null ? this.getDefaultProvider(indexName, dbConfig) : provider;
        }
        indexProvider = this.getIndexProvider(provider);
        configToUse = indexProvider.fillInDefaults(configToUse);
        configToUse = this.injectDefaultProviderIfMissing(cls, indexName, dbConfig, configToUse);
        if (storedConfig != null) {
            if (suppliedConfig != null && !indexProvider.configMatches(storedConfig, suppliedConfig)) {
                throw new IllegalArgumentException("Supplied index configuration:\n" + suppliedConfig + "\ndoesn't match stored config in a valid way:\n" + storedConfig + "\nfor '" + indexName + "'");
            }
            Map<String, String> newConfig = this.injectDefaultProviderIfMissing(cls, indexName, dbConfig, storedConfig);
            if (newConfig != storedConfig) {
                this.indexStore.set(cls, indexName, newConfig);
            }
            configToUse = newConfig;
        }
        boolean created = this.indexStore.setIfNecessary(cls, indexName, configToUse);
        return Pair.of(Collections.unmodifiableMap(configToUse), created);
    }

    private Map<String, String> injectDefaultProviderIfMissing(Class<? extends PropertyContainer> cls, String indexName, Map<?, ?> dbConfig, Map<String, String> config) {
        String provider = config.get("provider");
        if (provider == null) {
            config = new HashMap<String, String>(config);
            config.put("provider", this.getDefaultProvider(indexName, dbConfig));
        }
        return config;
    }

    private String getDefaultProvider(String indexName, Map<?, ?> dbConfig) {
        String provider = null;
        if (dbConfig != null && (provider = (String)dbConfig.get("index." + indexName)) == null) {
            provider = (String)dbConfig.get("index");
        }
        if (provider == null) {
            provider = "lucene";
        }
        return provider;
    }

    private Map<String, String> getOrCreateIndexConfig(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> suppliedConfig) {
        Pair<Map<String, String>, Boolean> result = this.findIndexConfig(cls, indexName, suppliedConfig, this.graphDbImpl.getConfig().getParams());
        if (result.other().booleanValue()) {
            IndexCreatorThread creator = new IndexCreatorThread(cls, indexName, result.first());
            creator.start();
            try {
                creator.join();
                if (creator.exception != null) {
                    throw new TransactionFailureException("Index creation failed for " + indexName + ", " + result.first(), creator.exception);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        return result.first();
    }

    @Override
    public boolean existsForNodes(String indexName) {
        return this.indexStore.get(Node.class, indexName) != null;
    }

    @Override
    public Index<Node> forNodes(String indexName) {
        return this.forNodes(indexName, null);
    }

    @Override
    public Index<Node> forNodes(String indexName, Map<String, String> customConfiguration) {
        Index<Node> toReturn = this.getOrCreateNodeIndex(indexName, customConfiguration);
        if ("node_auto_index".equals(indexName)) {
            toReturn = new AbstractAutoIndexerImpl.ReadOnlyIndexToIndexAdapter<Node>(toReturn);
        }
        return toReturn;
    }

    Index<Node> getOrCreateNodeIndex(String indexName, Map<String, String> customConfiguration) {
        Map<String, String> config = this.getOrCreateIndexConfig(Node.class, indexName, customConfiguration);
        return this.getIndexProvider(config.get("provider")).nodeIndex(indexName, config);
    }

    RelationshipIndex getOrCreateRelationshipIndex(String indexName, Map<String, String> customConfiguration) {
        Map<String, String> config = this.getOrCreateIndexConfig(Relationship.class, indexName, customConfiguration);
        return this.getIndexProvider(config.get("provider")).relationshipIndex(indexName, config);
    }

    @Override
    public String[] nodeIndexNames() {
        return this.indexStore.getNames(Node.class);
    }

    @Override
    public boolean existsForRelationships(String indexName) {
        return this.indexStore.get(Relationship.class, indexName) != null;
    }

    @Override
    public RelationshipIndex forRelationships(String indexName) {
        return this.forRelationships(indexName, null);
    }

    @Override
    public RelationshipIndex forRelationships(String indexName, Map<String, String> customConfiguration) {
        RelationshipIndex toReturn = this.getOrCreateRelationshipIndex(indexName, customConfiguration);
        if ("relationship_auto_index".equals(indexName)) {
            toReturn = new RelationshipAutoIndexerImpl.RelationshipReadOnlyIndexToIndexAdapter(toReturn);
        }
        return toReturn;
    }

    @Override
    public String[] relationshipIndexNames() {
        return this.indexStore.getNames(Relationship.class);
    }

    @Override
    public Map<String, String> getConfiguration(Index<? extends PropertyContainer> index) {
        Map<String, String> config = this.indexStore.get(index.getEntityType(), index.getName());
        if (config == null) {
            throw new NotFoundException("No " + index.getEntityType().getSimpleName() + " index '" + index.getName() + "' found");
        }
        return config;
    }

    @Override
    public String setConfiguration(Index<? extends PropertyContainer> index, String key, String value) {
        this.assertLegalConfigKey(key);
        Map<String, String> config = this.getMutableConfig(index);
        String oldValue = config.put(key, value);
        this.indexStore.set(index.getEntityType(), index.getName(), config);
        return oldValue;
    }

    private void assertLegalConfigKey(String key) {
        if (key.equals("provider")) {
            throw new IllegalArgumentException("'" + key + "' cannot be modified");
        }
    }

    private Map<String, String> getMutableConfig(Index<? extends PropertyContainer> index) {
        return new HashMap<String, String>(this.getConfiguration(index));
    }

    @Override
    public String removeConfiguration(Index<? extends PropertyContainer> index, String key) {
        this.assertLegalConfigKey(key);
        Map<String, String> config = this.getMutableConfig(index);
        String value = config.remove(key);
        if (value != null) {
            this.indexStore.set(index.getEntityType(), index.getName(), config);
        }
        return value;
    }

    @Override
    public AutoIndexer<Node> getNodeAutoIndexer() {
        return this.nodeAutoIndexer;
    }

    @Override
    public RelationshipAutoIndexer getRelationshipAutoIndexer() {
        return this.relAutoIndexer;
    }

    private class IndexCreatorThread
    extends Thread {
        private final String indexName;
        private final Map<String, String> config;
        private Exception exception;
        private final Class<? extends PropertyContainer> cls;

        IndexCreatorThread(Class<? extends PropertyContainer> cls, String indexName, Map<String, String> config) {
            this.cls = cls;
            this.indexName = indexName;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String provider = this.config.get("provider");
            String dataSourceName = IndexManagerImpl.this.getIndexProvider(provider).getDataSourceName();
            XaDataSource dataSource = IndexManagerImpl.this.graphDbImpl.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource(dataSourceName);
            IndexXaConnection connection = (IndexXaConnection)dataSource.getXaConnection();
            org.neo4j.graphdb.Transaction tx = IndexManagerImpl.this.graphDbImpl.beginTx();
            try {
                Transaction javaxTx = IndexManagerImpl.this.graphDbImpl.getConfig().getTxModule().getTxManager().getTransaction();
                javaxTx.enlistResource(connection.getXaResource());
                connection.createIndex(this.cls, this.indexName, this.config);
                tx.success();
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                tx.finish();
            }
        }
    }
}

