/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.util.Bits;

public enum ShortArray {
    BOOLEAN(PropertyType.BOOL, 1, (Class)Boolean.class){

        @Override
        int getRequiredBits(Object value) {
            return 1;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put((Boolean)value != false ? 1 : 0, 1);
        }

        @Override
        Object createArray(int ofLength) {
            return new boolean[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            Array.setBoolean(array, position, bits.getByte(requiredBits) != 0);
        }
    }
    ,
    BYTE(PropertyType.BYTE, 8, (Class)Byte.class){

        @Override
        int getRequiredBits(Object value) {
            byte v = ((Number)value).byteValue();
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & (long)v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put((Byte)value, requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new byte[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            Array.setByte(array, position, bits.getByte(requiredBits));
        }
    }
    ,
    SHORT(PropertyType.SHORT, 16, (Class)Short.class){

        @Override
        int getRequiredBits(Object value) {
            short v = ((Number)value).shortValue();
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & (long)v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put((Short)value, requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new short[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            Array.setShort(array, position, bits.getShort(requiredBits));
        }
    }
    ,
    CHAR(PropertyType.CHAR, 16, (Class)Character.class){

        @Override
        int getRequiredBits(Object value) {
            char v = ((Character)value).charValue();
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & (long)v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put(((Character)value).charValue(), requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new char[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            Array.setChar(array, position, (char)bits.getShort(requiredBits));
        }
    }
    ,
    INT(PropertyType.INT, 32, (Class)Integer.class){

        @Override
        int getRequiredBits(Object value) {
            int v = ((Number)value).intValue();
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & (long)v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put((Integer)value, requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new int[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            Array.setInt(array, position, bits.getInt(requiredBits));
        }
    }
    ,
    LONG(PropertyType.LONG, 64, (Class)Long.class){

        @Override
        int getRequiredBits(Object value) {
            long v = ((Number)value).longValue();
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put((Long)value, requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new long[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            Array.setLong(array, position, bits.getLong(requiredBits));
        }
    }
    ,
    FLOAT(PropertyType.FLOAT, 32, (Class)Float.class){

        @Override
        int getRequiredBits(Object value) {
            int v = Float.floatToIntBits(((Number)value).floatValue());
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & (long)v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put(Float.floatToIntBits(((Float)value).floatValue()), requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new float[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            int value = bits.getInt(requiredBits);
            Array.setFloat(array, position, Float.intBitsToFloat(value));
        }
    }
    ,
    DOUBLE(PropertyType.DOUBLE, 64, (Class)Double.class){

        @Override
        int getRequiredBits(Object value) {
            long v = Double.doubleToLongBits(((Number)value).doubleValue());
            int highest = 0;
            long mask = 1L;
            int i = 1;
            while (i <= this.maxBits) {
                if ((mask & v) != 0L) {
                    highest = i;
                }
                ++i;
                mask <<= 1;
            }
            return highest;
        }

        @Override
        void put(Object value, Bits bytes, int requiredBits) {
            bytes.put(Double.doubleToLongBits((Double)value), requiredBits);
        }

        @Override
        Object createArray(int ofLength) {
            return new double[ofLength];
        }

        @Override
        void get(Object array, int position, Bits bits, int requiredBits) {
            long value = bits.getLong(requiredBits);
            Array.setDouble(array, position, Double.longBitsToDouble(value));
        }
    };

    final int maxBits;
    private final Class<?> boxedClass;
    private final PropertyType type;

    private ShortArray(PropertyType type, int maxBits, Class<?> boxedClass) {
        this.type = type;
        this.maxBits = maxBits;
        this.boxedClass = boxedClass;
    }

    public int intValue() {
        return this.type.intValue();
    }

    abstract int getRequiredBits(Object var1);

    abstract void put(Object var1, Bits var2, int var3);

    abstract void get(Object var1, int var2, Bits var3, int var4);

    abstract Object createArray(int var1);

    boolean matches(Class<?> cls) {
        return this.boxedClass.equals(cls);
    }

    public static boolean encode(int keyId, Object array, PropertyBlock target, int payloadSizeInBytes) {
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            return false;
        }
        int arrayLength = Array.getLength(array);
        if (arrayLength > 63) {
            return false;
        }
        int requiredBits = type.calculateRequiredBitsForArray(array);
        if (!ShortArray.willFit(requiredBits, arrayLength, payloadSizeInBytes)) {
            return false;
        }
        Bits result = Bits.bits(ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits) * 8);
        if (result.getLongs().length > PropertyType.getPayloadSizeLongs()) {
            return false;
        }
        result.put(keyId, 24);
        result.put(PropertyType.SHORT_ARRAY.intValue(), 4);
        result.put(type.type.intValue(), 4);
        result.put(arrayLength, 6);
        result.put(requiredBits, 6);
        for (int i = 0; i < arrayLength; ++i) {
            type.put(Array.get(array, i), result, requiredBits);
        }
        target.setValueBlocks(result.getLongs());
        return true;
    }

    public static Object decode(PropertyBlock block) {
        Bits bits = Bits.bitsFromLongs(Arrays.copyOf(block.getValueBlocks(), block.getValueBlocks().length));
        bits.getInt(24);
        bits.getByte(4);
        byte typeId = bits.getByte(4);
        int arrayLength = bits.getByte(6);
        int requiredBits = bits.getByte(6);
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        ShortArray type = ShortArray.typeOf(typeId);
        Object array = type.createArray(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            type.get(array, i, bits, requiredBits);
        }
        return array;
    }

    private static boolean willFit(int requiredBits, int arrayLength, int payloadSizeInBytes) {
        int totalBitsRequired = requiredBits * arrayLength;
        int maxBits = payloadSizeInBytes * 8 - 24 - 4 - 4 - 6 - 6;
        return totalBitsRequired <= maxBits;
    }

    public int calculateRequiredBitsForArray(Object array) {
        int arrayLength = Array.getLength(array);
        if (arrayLength == 0) {
            return 0;
        }
        int highest = 1;
        for (int i = 0; i < arrayLength; ++i) {
            Object value = Array.get(array, i);
            highest = Math.max(highest, this.getRequiredBits(value));
        }
        return highest;
    }

    public static ShortArray typeOf(byte typeId) {
        return ShortArray.values()[typeId - 1];
    }

    public static ShortArray typeOf(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            String name = componentType.getSimpleName();
            return ShortArray.valueOf(name.toUpperCase());
        }
        for (ShortArray type : ShortArray.values()) {
            if (!type.matches(componentType)) continue;
            return type;
        }
        return null;
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        Bits bits = Bits.bitsFromLongs(new long[]{firstBlock});
        bits.getInt(24);
        bits.getByte(4);
        bits.getByte(4);
        byte arrayLength = bits.getByte(6);
        int requiredBits = bits.getByte(6);
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        return ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits);
    }

    public static int calculateNumberOfBlocksUsed(int arrayLength, int requiredBits) {
        int bitsForItems = arrayLength * requiredBits;
        int totalBits = 44 + bitsForItems;
        int result = (totalBits - 1) / 64 + 1;
        return result;
    }
}

