/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.LockType;

class RelationshipProxy
implements Relationship {
    private final long relId;
    private final NodeManager nm;

    RelationshipProxy(long relId, NodeManager nodeManager) {
        this.relId = relId;
        this.nm = nodeManager;
    }

    @Override
    public long getId() {
        return this.relId;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.nm.getGraphDbService();
    }

    @Override
    public void delete() {
        this.nm.getRelForProxy(this, LockType.WRITE).delete(this.nm);
    }

    @Override
    public Node[] getNodes() {
        return this.nm.getRelForProxy(this, null).getNodes(this.nm);
    }

    @Override
    public Node getOtherNode(Node node) {
        return this.nm.getRelForProxy(this, null).getOtherNode(this.nm, node);
    }

    @Override
    public Node getStartNode() {
        return this.nm.getRelForProxy(this, null).getStartNode(this.nm);
    }

    @Override
    public Node getEndNode() {
        return this.nm.getRelForProxy(this, null).getEndNode(this.nm);
    }

    @Override
    public RelationshipType getType() {
        return this.nm.getRelForProxy(this, null).getType(this.nm);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return this.nm.getRelForProxy(this, null).getPropertyKeys(this.nm);
    }

    @Override
    public Iterable<Object> getPropertyValues() {
        return this.nm.getRelForProxy(this, null).getPropertyValues(this.nm);
    }

    @Override
    public Object getProperty(String key) {
        return this.nm.getRelForProxy(this, null).getProperty(this.nm, key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        return this.nm.getRelForProxy(this, null).getProperty(this.nm, key, defaultValue);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.nm.getRelForProxy(this, null).hasProperty(this.nm, key);
    }

    @Override
    public void setProperty(String key, Object property) {
        this.nm.getRelForProxy(this, LockType.WRITE).setProperty(this.nm, key, property);
    }

    @Override
    public Object removeProperty(String key) {
        return this.nm.getRelForProxy(this, LockType.WRITE).removeProperty(this.nm, key);
    }

    @Override
    public boolean isType(RelationshipType type) {
        return this.nm.getRelForProxy(this, null).isType(this.nm, type);
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Relationship)) {
            return false;
        }
        return this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.relId >>> 32 ^ this.relId);
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }
}

