/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tooling.wrap;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;
import org.neo4j.tooling.wrap.WrappedEntity;
import org.neo4j.tooling.wrap.WrappedGraphDatabase;
import org.neo4j.tooling.wrap.WrappedTraverser;

public abstract class WrappedNode<G extends WrappedGraphDatabase>
extends WrappedEntity<G, Node>
implements Node {
    protected WrappedNode(G graphdb) {
        super(graphdb);
    }

    @Override
    public long getId() {
        return ((Node)this.actual()).getId();
    }

    @Override
    public void delete() {
        ((Node)this.actual()).delete();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.graphdb.relationships(((Node)this.actual()).getRelationships());
    }

    @Override
    public boolean hasRelationship() {
        return ((Node)this.actual()).hasRelationship();
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        return this.graphdb.relationships(((Node)this.actual()).getRelationships(types));
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        return this.graphdb.relationships(((Node)this.actual()).getRelationships(direction, types));
    }

    @Override
    public boolean hasRelationship(RelationshipType ... types) {
        return ((Node)this.actual()).hasRelationship(types);
    }

    @Override
    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        return ((Node)this.actual()).hasRelationship(direction, types);
    }

    @Override
    public Iterable<Relationship> getRelationships(Direction dir) {
        return this.graphdb.relationships(((Node)this.actual()).getRelationships(dir));
    }

    @Override
    public boolean hasRelationship(Direction dir) {
        return ((Node)this.actual()).hasRelationship(dir);
    }

    @Override
    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.graphdb.relationships(((Node)this.actual()).getRelationships(type, dir));
    }

    @Override
    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return ((Node)this.actual()).hasRelationship(type, dir);
    }

    @Override
    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        Relationship rel = ((Node)this.actual()).getSingleRelationship(type, dir);
        if (rel == null) {
            return null;
        }
        return this.graphdb.relationship(rel, false);
    }

    @Override
    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        return this.graphdb.relationship(((Node)this.actual()).createRelationshipTo(WrappedNode.unwrap(otherNode), type), true);
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        WrappedTraverser.Evaluator evaluator = new WrappedTraverser.Evaluator(this.graphdb, stopEvaluator, returnableEvaluator);
        return new WrappedTraverser(this.graphdb, ((Node)this.actual()).traverse(traversalOrder, (StopEvaluator)evaluator, (ReturnableEvaluator)evaluator, relationshipType, direction));
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        WrappedTraverser.Evaluator evaluator = new WrappedTraverser.Evaluator(this.graphdb, stopEvaluator, returnableEvaluator);
        return new WrappedTraverser(this.graphdb, ((Node)this.actual()).traverse(traversalOrder, (StopEvaluator)evaluator, (ReturnableEvaluator)evaluator, firstRelationshipType, firstDirection, secondRelationshipType, secondDirection));
    }

    @Override
    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        WrappedTraverser.Evaluator evaluator = new WrappedTraverser.Evaluator(this.graphdb, stopEvaluator, returnableEvaluator);
        return new WrappedTraverser(this.graphdb, ((Node)this.actual()).traverse(traversalOrder, (StopEvaluator)evaluator, (ReturnableEvaluator)evaluator, relationshipTypesAndDirections));
    }
}

