/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;

public class LegacyNodeStoreReader {
    public static final String FROM_VERSION = "NodeStore v0.9.9";
    public static final int RECORD_LENGTH = 9;
    private final FileChannel fileChannel;
    private final long maxId;

    public LegacyNodeStoreReader(String fileName) throws IOException {
        this.fileChannel = new RandomAccessFile(fileName, "r").getChannel();
        int endHeaderSize = UTF8.encode(FROM_VERSION).length;
        this.maxId = (this.fileChannel.size() - (long)endHeaderSize) / 9L;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public Iterable<NodeRecord> readNodeStore() throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(9);
        return new Iterable<NodeRecord>(){

            @Override
            public Iterator<NodeRecord> iterator() {
                return new PrefetchingIterator<NodeRecord>(){
                    long id = 0L;

                    @Override
                    protected NodeRecord fetchNextOrNull() {
                        NodeRecord nodeRecord = null;
                        while (nodeRecord == null && this.id <= LegacyNodeStoreReader.this.maxId) {
                            buffer.clear();
                            try {
                                LegacyNodeStoreReader.this.fileChannel.read(buffer);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            buffer.flip();
                            long inUseByte = buffer.get();
                            boolean inUse = (inUseByte & 1L) == (long)Record.IN_USE.intValue();
                            nodeRecord = new NodeRecord(this.id);
                            nodeRecord.setInUse(inUse);
                            if (inUse) {
                                long nextRel = LegacyStore.getUnsignedInt(buffer);
                                long nextProp = LegacyStore.getUnsignedInt(buffer);
                                long relModifier = (inUseByte & 0xEL) << 31;
                                long propModifier = (inUseByte & 0xF0L) << 28;
                                nodeRecord.setNextRel(LegacyStore.longFromIntAndMod(nextRel, relModifier));
                                nodeRecord.setNextProp(LegacyStore.longFromIntAndMod(nextProp, propModifier));
                            }
                            ++this.id;
                        }
                        return nodeRecord;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }
}

