/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.core.FastRelTypeElement;
import org.neo4j.kernel.impl.core.NodeImpl;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.RelTypeElementIterator;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.util.RelIdArray;

class IntArrayIterator
implements Iterable<Relationship>,
Iterator<Relationship> {
    private Iterator<RelTypeElementIterator> typeIterator;
    private RelTypeElementIterator currentTypeIterator = null;
    private final NodeImpl fromNode;
    private final RelIdArray.DirectionWrapper direction;
    private Relationship nextElement = null;
    private final NodeManager nodeManager;
    private final RelationshipType[] types;
    private final List<RelTypeElementIterator> rels;
    private boolean isFullyLoaded;

    IntArrayIterator(List<RelTypeElementIterator> rels, NodeImpl fromNode, RelIdArray.DirectionWrapper direction, NodeManager nodeManager, RelationshipType[] types, boolean isFullyLoaded) {
        this.rels = rels;
        this.isFullyLoaded = isFullyLoaded;
        this.typeIterator = rels.iterator();
        this.currentTypeIterator = this.typeIterator.hasNext() ? this.typeIterator.next() : RelTypeElementIterator.EMPTY;
        this.fromNode = fromNode;
        this.direction = direction;
        this.nodeManager = nodeManager;
        this.types = types;
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement != null) {
            return true;
        }
        block2: do {
            if (this.currentTypeIterator.hasNext(this.nodeManager)) {
                long nextId = this.currentTypeIterator.next(this.nodeManager);
                try {
                    this.nextElement = new RelationshipProxy(nextId, this.nodeManager);
                    return true;
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            while (!this.currentTypeIterator.hasNext(this.nodeManager)) {
                if (this.typeIterator.hasNext()) {
                    this.currentTypeIterator = this.typeIterator.next();
                    continue;
                }
                if (!this.fromNode.getMoreRelationships(this.nodeManager) && this.isFullyLoaded) continue block2;
                HashMap<String, RelTypeElementIterator> newRels = new HashMap<String, RelTypeElementIterator>();
                Iterator<RelTypeElementIterator> i$ = this.rels.iterator();
                while (i$.hasNext()) {
                    RelTypeElementIterator itr;
                    RelTypeElementIterator newItr = itr = i$.next();
                    RelIdArray newSrc = this.fromNode.getRelationshipIds(itr.getType());
                    if (newSrc != null) {
                        if (itr.isSrcEmpty()) {
                            newItr = itr.setSrc(newSrc);
                        } else if (newSrc.couldBeNeedingUpdate()) {
                            itr.updateSrc(newSrc);
                        }
                        newItr.notifyAboutMoreRelationships();
                    }
                    newRels.put(newItr.getType(), newItr);
                }
                if (this.types.length == 0) {
                    for (RelIdArray ids : this.fromNode.getRelationshipIds()) {
                        String type = ids.getType();
                        RelTypeElementIterator itr = (RelTypeElementIterator)newRels.get(type);
                        if (itr != null && !itr.isSrcEmpty()) continue;
                        itr = itr == null ? new FastRelTypeElement(type, this.fromNode, ids, this.direction) : itr.setSrc(ids);
                        newRels.put(type, itr);
                    }
                }
                this.rels.clear();
                this.rels.addAll(newRels.values());
                this.typeIterator = this.rels.iterator();
                this.currentTypeIterator = this.typeIterator.hasNext() ? this.typeIterator.next() : RelTypeElementIterator.EMPTY;
                this.isFullyLoaded = !this.fromNode.hasMoreRelationshipsToLoad();
            }
        } while (this.currentTypeIterator.hasNext(this.nodeManager));
        return false;
    }

    @Override
    public Relationship next() {
        this.hasNext();
        if (this.nextElement != null) {
            Relationship elementToReturn = this.nextElement;
            this.nextElement = null;
            return elementToReturn;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

