/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;

public class RelIdArray {
    private static final DirectionWrapper[] DIRECTIONS_FOR_OUTGOING = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_INCOMING = new DirectionWrapper[]{DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_BOTH = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    public static final RelIdArray EMPTY = new RelIdArray(""){
        private RelIdIterator emptyIterator = new RelIdIterator(null, new DirectionWrapper[0]){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            protected boolean nextBlock() {
                return false;
            }

            @Override
            public void doAnotherRound() {
            }
        };

        @Override
        public RelIdIterator iterator(DirectionWrapper direction) {
            return this.emptyIterator;
        }
    };
    private final String type;
    private IdBlock lastOutBlock;
    private IdBlock lastInBlock;
    public static final IdBlock EMPTY_BLOCK = new LowIdBlock();

    public RelIdArray(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    protected RelIdArray(RelIdArray from) {
        this(from.type);
        this.lastOutBlock = from.lastOutBlock;
        this.lastInBlock = from.lastInBlock;
    }

    protected RelIdArray(String type, IdBlock out, IdBlock in) {
        this(type);
        this.lastOutBlock = out;
        this.lastInBlock = in;
    }

    public void add(long id, DirectionWrapper direction) {
        IdBlock lastBlock = direction.getLastBlock(this);
        long highBits = id & 0xFFFFFFFF00000000L;
        if (lastBlock == null || lastBlock.getHighBits() != highBits) {
            IdBlock newLastBlock = null;
            if (highBits == 0L && lastBlock == null) {
                newLastBlock = new LowIdBlock();
            } else {
                newLastBlock = new HighIdBlock(highBits);
                if (lastBlock != null) {
                    lastBlock = lastBlock.upgradeIfNeeded();
                    newLastBlock.setPrev(lastBlock);
                }
            }
            direction.setLastBlock(this, newLastBlock);
            lastBlock = newLastBlock;
        }
        lastBlock.add((int)id);
    }

    public RelIdArray addAll(RelIdArray source) {
        if (source == null) {
            return this;
        }
        if (source.getLastLoopBlock() != null) {
            return this.upgradeIfNeeded(source).addAll(source);
        }
        this.append(source, DirectionWrapper.OUTGOING);
        this.append(source, DirectionWrapper.INCOMING);
        this.append(source, DirectionWrapper.BOTH);
        return this;
    }

    protected IdBlock getLastLoopBlock() {
        return null;
    }

    public RelIdArray shrink() {
        IdBlock shrunkOut = this.lastOutBlock != null ? this.lastOutBlock.shrink() : null;
        IdBlock shrunkIn = this.lastInBlock != null ? this.lastInBlock.shrink() : null;
        return shrunkOut == this.lastOutBlock && shrunkIn == this.lastInBlock ? this : new RelIdArray(this.type, shrunkOut, shrunkIn);
    }

    protected void setLastLoopBlock(IdBlock block) {
        throw new UnsupportedOperationException("Should've upgraded to RelIdArrayWithLoops before this");
    }

    public RelIdArray upgradeIfNeeded(RelIdArray capabilitiesToMatch) {
        return capabilitiesToMatch.getLastLoopBlock() != null ? new RelIdArrayWithLoops(this) : this;
    }

    public RelIdArray downgradeIfPossible() {
        return this;
    }

    protected void append(RelIdArray source, DirectionWrapper direction) {
        IdBlock toBlock = direction.getLastBlock(this);
        IdBlock fromBlock = direction.getLastBlock(source);
        if (fromBlock != null) {
            if (toBlock == null) {
                direction.setLastBlock(this, fromBlock.copy());
            } else if (toBlock.getHighBits() == fromBlock.getHighBits()) {
                toBlock.addAll(fromBlock);
                if (fromBlock.getPrev() != null) {
                    boolean isTheOnlyOne = toBlock.getPrev() == null;
                    IdBlock last = RelIdArray.last(toBlock);
                    last.setPrev(fromBlock.getPrev().copy());
                    if (isTheOnlyOne) {
                        direction.setLastBlock(this, last);
                    }
                }
            } else {
                boolean isTheOnlyOne = toBlock.getPrev() == null;
                IdBlock last = RelIdArray.last(toBlock);
                last.setPrev(fromBlock.copy());
                if (isTheOnlyOne) {
                    direction.setLastBlock(this, last);
                }
            }
        }
    }

    private static IdBlock last(IdBlock block) {
        IdBlock previousInLoop = null;
        while (true) {
            IdBlock prev;
            block = block.upgradeIfNeeded();
            if (previousInLoop != null) {
                previousInLoop.setPrev(block);
            }
            if ((prev = block.getPrev()) == null) {
                return block;
            }
            previousInLoop = block;
            block = prev;
        }
    }

    public boolean isEmpty() {
        return this.lastOutBlock == null && this.lastInBlock == null && this.getLastLoopBlock() == null;
    }

    public RelIdIterator iterator(DirectionWrapper direction) {
        return direction.iterator(this);
    }

    public RelIdArray newSimilarInstance() {
        return new RelIdArray(this.type);
    }

    public static DirectionWrapper wrap(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return DirectionWrapper.OUTGOING;
            }
            case INCOMING: {
                return DirectionWrapper.INCOMING;
            }
            case BOTH: {
                return DirectionWrapper.BOTH;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)direction));
    }

    public static RelIdArray from(RelIdArray src, RelIdArray add, RelIdArray remove) {
        if (remove == null) {
            if (src == null) {
                return add.downgradeIfPossible();
            }
            if (add != null) {
                RelIdArray newArray = src.newSimilarInstance();
                newArray.addAll(src);
                newArray = newArray.addAll(add);
                return newArray;
            }
            return src;
        }
        if (src == null && add == null) {
            return null;
        }
        RelIdArray newArray = null;
        Set<Long> removedSet = remove.asSet();
        if (src != null) {
            newArray = src.newSimilarInstance();
            newArray.addAll(src);
            RelIdArray.evictExcluded(newArray, removedSet);
        } else {
            newArray = add.newSimilarInstance();
        }
        if (add != null) {
            newArray = newArray.upgradeIfNeeded(add);
            RelIdIterator fromIterator = add.iterator(DirectionWrapper.BOTH);
            while (fromIterator.hasNext()) {
                long value = fromIterator.next();
                if (removedSet.contains(value)) continue;
                newArray.add(value, fromIterator.currentDirection);
            }
        }
        return newArray.shrink();
    }

    private static void evictExcluded(RelIdArray ids, Set<Long> excluded) {
        RelIdIterator iterator = DirectionWrapper.BOTH.iterator(ids);
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (!excluded.contains(value)) continue;
            boolean swapSuccessful = false;
            IteratorState state = iterator.currentState;
            IdBlock block = state.block;
            for (int j = block.length() - 1; j >= state.relativePosition; --j) {
                long backValue = block.get(j);
                ((IdBlock)block).ids[0] = block.ids[0] - 1;
                if (excluded.contains(backValue)) continue;
                block.set(backValue, state.relativePosition - 1);
                swapSuccessful = true;
                break;
            }
            if (swapSuccessful) continue;
            ((IdBlock)block).ids[0] = block.ids[0] - 1;
        }
    }

    private Set<Long> asSet() {
        HashSet<Long> set = new HashSet<Long>();
        RelIdIterator iterator = DirectionWrapper.BOTH.iterator(this);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public boolean couldBeNeedingUpdate() {
        return this.lastOutBlock != null && this.lastOutBlock.getPrev() != null || this.lastInBlock != null && this.lastInBlock.getPrev() != null;
    }

    public static class RelIdIterator {
        private final DirectionWrapper[] directions;
        private int directionPosition = -1;
        private DirectionWrapper currentDirection;
        private IteratorState currentState;
        private final IteratorState[] states;
        private long nextElement;
        private boolean nextElementDetermined;
        private RelIdArray ids;

        RelIdIterator(RelIdArray ids, DirectionWrapper[] directions) {
            this.ids = ids;
            this.directions = directions;
            this.states = new IteratorState[directions.length];
            IdBlock block = null;
            while (block == null && this.directionPosition + 1 < directions.length) {
                this.currentDirection = directions[++this.directionPosition];
                block = this.currentDirection.getLastBlock(ids);
            }
            if (block != null) {
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
            }
        }

        public void updateSource(RelIdArray newSource) {
            this.ids = newSource;
            for (int i = 0; i < this.states.length; ++i) {
                if (this.states[i] == null) continue;
                this.states[i].update(this.directions[i].getLastBlock(this.ids));
            }
        }

        public boolean hasNext() {
            if (this.nextElementDetermined) {
                return this.nextElement != -1L;
            }
            do {
                if (this.currentState == null || !this.currentState.hasNext()) continue;
                this.nextElement = this.currentState.next();
                this.nextElementDetermined = true;
                return true;
            } while (this.nextBlock());
            this.nextElementDetermined = false;
            this.nextElement = -1L;
            return false;
        }

        protected boolean nextBlock() {
            if (this.currentState != null && this.currentState.nextBlock()) {
                return true;
            }
            return this.findNextBlock();
        }

        public void doAnotherRound() {
            this.directionPosition = -1;
            this.findNextBlock();
        }

        protected boolean findNextBlock() {
            while (this.directionPosition + 1 < this.directions.length) {
                this.currentDirection = this.directions[++this.directionPosition];
                IteratorState nextState = this.states[this.directionPosition];
                if (nextState != null) {
                    this.currentState = nextState;
                    return true;
                }
                IdBlock block = this.currentDirection.getLastBlock(this.ids);
                if (block == null) continue;
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
                return true;
            }
            return false;
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextElementDetermined = false;
            return this.nextElement;
        }
    }

    private static class IteratorState {
        private int blockIndex;
        private IdBlock block;
        private int relativePosition;
        private int absolutePosition;

        public IteratorState(IdBlock block, int relativePosition) {
            this.block = block;
            this.relativePosition = relativePosition;
        }

        boolean nextBlock() {
            if (this.block.getPrev() != null) {
                this.block = this.block.getPrev();
                this.relativePosition = 0;
                ++this.blockIndex;
                return true;
            }
            return false;
        }

        boolean hasNext() {
            return this.relativePosition < this.block.length();
        }

        long next() {
            ++this.absolutePosition;
            return this.block.get(this.relativePosition++);
        }

        public void update(IdBlock lastBlock) {
            for (int i = 0; i < this.blockIndex; ++i) {
                lastBlock = lastBlock.getPrev();
            }
            this.block = lastBlock;
        }
    }

    private static class HighIdBlock
    extends IdBlock {
        private final long highBits;
        private IdBlock prev;

        HighIdBlock(long highBits) {
            this.highBits = highBits;
        }

        @Override
        IdBlock upgradeIfNeeded() {
            return this;
        }

        @Override
        IdBlock copy() {
            IdBlock copy = super.copy();
            if (this.prev != null) {
                copy.setPrev(this.prev.copy());
            }
            return copy;
        }

        @Override
        IdBlock getPrev() {
            return this.prev;
        }

        @Override
        void setPrev(IdBlock prev) {
            this.prev = prev;
        }

        @Override
        long transform(int id) {
            return (long)id & 0xFFFFFFFFL | this.highBits;
        }

        @Override
        protected IdBlock copyInstance() {
            return new HighIdBlock(this.highBits);
        }

        @Override
        long getHighBits() {
            return this.highBits;
        }
    }

    private static class LowIdBlock
    extends IdBlock {
        private LowIdBlock() {
        }

        @Override
        void setPrev(IdBlock prev) {
            throw new UnsupportedOperationException();
        }

        @Override
        IdBlock upgradeIfNeeded() {
            HighIdBlock highBlock = new HighIdBlock(0L);
            IdBlock.access$702(highBlock, ((IdBlock)this).ids);
            return highBlock;
        }

        @Override
        long transform(int id) {
            return (long)id & 0xFFFFFFFFL;
        }

        @Override
        protected IdBlock copyInstance() {
            return new LowIdBlock();
        }

        @Override
        long getHighBits() {
            return 0L;
        }
    }

    public static abstract class IdBlock {
        private int[] ids = new int[3];

        IdBlock copy() {
            IdBlock copy = this.copyInstance();
            int length = this.length();
            copy.ids = new int[length + 1];
            System.arraycopy(this.ids, 0, copy.ids, 0, length + 1);
            return copy;
        }

        IdBlock shrink() {
            return this.length() == this.ids.length - 1 ? this : this.copy();
        }

        abstract IdBlock upgradeIfNeeded();

        int length() {
            return this.ids[0];
        }

        IdBlock getPrev() {
            return null;
        }

        abstract void setPrev(IdBlock var1);

        protected abstract IdBlock copyInstance();

        void add(int id) {
            int length = this.ensureSpace(1);
            this.ids[length + 1] = id;
            this.ids[0] = length + 1;
        }

        int ensureSpace(int delta) {
            int length = this.length();
            int newLength = length + delta;
            if (newLength >= this.ids.length - 1) {
                int calculatedLength = this.ids.length * 3;
                if (newLength > calculatedLength) {
                    calculatedLength = newLength * 2;
                }
                int[] newIds = new int[calculatedLength];
                System.arraycopy(this.ids, 0, newIds, 0, length + 1);
                this.ids = newIds;
            }
            return length;
        }

        void addAll(IdBlock block) {
            int otherBlockLength = block.length();
            int length = this.ensureSpace(otherBlockLength + 1);
            System.arraycopy(block.ids, 1, this.ids, length + 1, otherBlockLength);
            this.ids[0] = otherBlockLength + length;
        }

        long get(int index) {
            assert (index >= 0 && index < this.length());
            return this.transform(this.ids[index + 1]);
        }

        abstract long transform(int var1);

        void set(long id, int index) {
            this.ids[index + 1] = (int)id;
        }

        abstract long getHighBits();

        static /* synthetic */ int[] access$702(IdBlock x0, int[] x1) {
            x0.ids = x1;
            return x1;
        }
    }

    public static enum DirectionWrapper {
        OUTGOING(Direction.OUTGOING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIterator(ids, DIRECTIONS_FOR_OUTGOING);
            }

            @Override
            IdBlock getLastBlock(RelIdArray ids) {
                return ids.lastOutBlock;
            }

            @Override
            void setLastBlock(RelIdArray ids, IdBlock block) {
                ids.lastOutBlock = block;
            }
        }
        ,
        INCOMING(Direction.INCOMING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIterator(ids, DIRECTIONS_FOR_INCOMING);
            }

            @Override
            IdBlock getLastBlock(RelIdArray ids) {
                return ids.lastInBlock;
            }

            @Override
            void setLastBlock(RelIdArray ids, IdBlock block) {
                ids.lastInBlock = block;
            }
        }
        ,
        BOTH(Direction.BOTH){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIterator(ids, DIRECTIONS_FOR_BOTH);
            }

            @Override
            IdBlock getLastBlock(RelIdArray ids) {
                return ids.getLastLoopBlock();
            }

            @Override
            void setLastBlock(RelIdArray ids, IdBlock block) {
                ids.setLastLoopBlock(block);
            }
        };

        private final Direction direction;

        private DirectionWrapper(Direction direction) {
            this.direction = direction;
        }

        abstract RelIdIterator iterator(RelIdArray var1);

        abstract IdBlock getLastBlock(RelIdArray var1);

        abstract void setLastBlock(RelIdArray var1, IdBlock var2);

        public Direction direction() {
            return this.direction;
        }
    }
}

